/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.comp.Deletion;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class DeletionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020901, 1020903);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020901: {
                func = new ValidationFunction<Deletion>(){

                    public boolean check(ValidationContext ctx, Deletion deletion) {
                        return deletion.isSetPortRef() || deletion.isSetIdRef() || deletion.isSetUnitRef() || deletion.isSetMetaIdRef();
                    }
                };
                break;
            }
            case 1020902: {
                func = new ValidationFunction<Deletion>(){

                    public boolean check(ValidationContext ctx, Deletion deletion) {
                        int nbDefined = 0;
                        if (deletion.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        return nbDefined <= 1;
                    }
                };
                break;
            }
            case 1020903: {
                func = new ValidationFunction<Deletion>(){

                    public boolean check(ValidationContext ctx, Deletion deletion) {
                        int nbDefined = 0;
                        if (deletion.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (deletion.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        boolean otherAttributes = new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)deletion);
                        return nbDefined == 1 && otherAttributes;
                    }
                };
            }
        }
        return func;
    }
}

