/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.comp.Port;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class PortConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1020801, 1020803);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1020801: {
                func = new ValidationFunction<Port>(){

                    public boolean check(ValidationContext ctx, Port port) {
                        return port.isSetIdRef() || port.isSetUnitRef() || port.isSetMetaIdRef();
                    }
                };
                break;
            }
            case 1020802: {
                func = new ValidationFunction<Port>(){

                    public boolean check(ValidationContext ctx, Port port) {
                        int nbDefined = 0;
                        if (port.isSetPortRef()) {
                            ++nbDefined;
                            ++nbDefined;
                        }
                        if (port.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (port.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (port.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        return nbDefined <= 1;
                    }
                };
                break;
            }
            case 1020803: {
                func = new ValidationFunction<Port>(){

                    public boolean check(ValidationContext ctx, Port port) {
                        int nbDefined = 0;
                        if (!port.isSetId()) {
                            return false;
                        }
                        if (port.isSetPortRef()) {
                            ++nbDefined;
                            ++nbDefined;
                        }
                        if (port.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (port.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (port.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        boolean otherAttributes = new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)port);
                        return nbDefined == 1 && otherAttributes;
                    }
                };
            }
        }
        return func;
    }
}

