/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.comp.CompModelPlugin;
import org.sbml.jsbml.ext.comp.ReplacedBy;
import org.sbml.jsbml.ext.comp.Submodel;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ReplacedByConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 1021101, 1021104);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1021101: {
                func = new ValidationFunction<ReplacedBy>(){

                    public boolean check(ValidationContext ctx, ReplacedBy replBy) {
                        return replBy.isSetPortRef() || replBy.isSetIdRef() || replBy.isSetUnitRef() || replBy.isSetMetaIdRef();
                    }
                };
                break;
            }
            case 1021102: {
                func = new ValidationFunction<ReplacedBy>(){

                    public boolean check(ValidationContext ctx, ReplacedBy replBy) {
                        int nbDefined = 0;
                        if (replBy.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        return nbDefined <= 1;
                    }
                };
                break;
            }
            case 1021103: {
                func = new ValidationFunction<ReplacedBy>(){

                    public boolean check(ValidationContext ctx, ReplacedBy replBy) {
                        int nbDefined = 0;
                        if (!replBy.isSetSubmodelRef()) {
                            return false;
                        }
                        if (replBy.isSetPortRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetIdRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetUnitRef()) {
                            ++nbDefined;
                        }
                        if (replBy.isSetMetaIdRef()) {
                            ++nbDefined;
                        }
                        boolean otherAttributes = new UnknownPackageAttributeValidationFunction("comp").check(ctx, (TreeNodeWithChangeSupport)replBy);
                        return nbDefined == 1 && otherAttributes;
                    }
                };
                break;
            }
            case 1021104: {
                func = new ValidationFunction<ReplacedBy>(){

                    public boolean check(ValidationContext ctx, ReplacedBy replBy) {
                        Model m;
                        if (replBy.isSetSubmodelRef() && (m = replBy.getModel()) != null && m.isSetPlugin("comp")) {
                            CompModelPlugin compM = (CompModelPlugin)m.getPlugin("comp");
                            Submodel subModel = compM.getSubmodel(replBy.getSubmodelRef());
                            return subModel != null;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

