/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.distrib.util;

import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBMLWriter;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.distrib.DistribFunctionDefinitionPlugin;
import org.sbml.jsbml.ext.distrib.DistribInput;
import org.sbml.jsbml.ext.distrib.DistribSBasePlugin;
import org.sbml.jsbml.ext.distrib.DrawFromDistribution;
import org.sbml.jsbml.ext.distrib.Uncertainty;
import org.sbml.jsbml.xml.XMLAttributes;
import org.sbml.jsbml.xml.XMLNamespaces;
import org.sbml.jsbml.xml.XMLNode;
import org.sbml.jsbml.xml.XMLTriple;

public class DistribModelBuilder {
    public static void createDistribution(FunctionDefinition f, String distribution, String[] inputTypes, String[] inputs) {
        String annotationStr = "<annotation><distribution xmlns=\"http://sbml.org/annotations/distribution\" definition=\"http://en.wikipedia.org/wiki/Normal_distribution\"/></annotation>";
        try {
            f.getAnnotation().setNonRDFAnnotation(annotationStr);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        DistribFunctionDefinitionPlugin distrib = (DistribFunctionDefinitionPlugin)f.getPlugin("distrib");
        DrawFromDistribution draw = distrib.createDrawFromDistribution();
        for (int i = 0; i < inputs.length; ++i) {
            DistribInput input = draw.createDistribInput();
            input.setId(inputs[i]);
        }
        String distribUrl = distribution;
        if (distribUrl.endsWith("Distribution")) {
            distribUrl = distribUrl.substring(0, distribUrl.length() - 12);
        }
        String definition = "http://www.uncertml.org/distributions/" + DistribModelBuilder.toUncertmlURL(distribUrl);
        XMLNode xmlNode = new XMLNode(new XMLTriple("UncertML"), new XMLAttributes(), new XMLNamespaces());
        xmlNode.addNamespace("http://www.uncertml.org/3.0");
        XMLNode distNode = new XMLNode(new XMLTriple(distribution), new XMLAttributes(), new XMLNamespaces());
        distNode.addAttr("definition", definition);
        xmlNode.addChild(distNode);
        for (int i = 0; i < inputs.length; ++i) {
            XMLNode inputNode = new XMLNode(new XMLTriple(inputTypes[i]), new XMLAttributes(), new XMLNamespaces());
            distNode.addChild(inputNode);
            distNode.addChild(new XMLNode("\n              "));
            XMLNode varNode = new XMLNode(new XMLTriple("var"), new XMLAttributes(), new XMLNamespaces());
            varNode.addAttr("varId", inputs[i]);
            inputNode.addChild(varNode);
            inputNode.addChild(new XMLNode("\n              "));
        }
        draw.setUncertML(xmlNode);
    }

    public static void createRange(SBase sbase, String lower, String upper) {
        DistribSBasePlugin distrib = (DistribSBasePlugin)sbase.getPlugin("distrib");
        Uncertainty draw = distrib.createUncertainty();
        XMLNode xmlNode = new XMLNode(new XMLTriple("UncertML"), new XMLAttributes(), new XMLNamespaces());
        xmlNode.addNamespace("http://www.uncertml.org/3.0");
        XMLNode distNode = new XMLNode(new XMLTriple("Range"), new XMLAttributes(), new XMLNamespaces());
        distNode.addAttr("definition", "http://www.uncertml.org/statistics/range");
        xmlNode.addChild(distNode);
        XMLNode lowerNode = new XMLNode(new XMLTriple("lower"), new XMLAttributes(), new XMLNamespaces());
        XMLNode rValNode = new XMLNode(new XMLTriple("rVal"), new XMLAttributes(), new XMLNamespaces());
        rValNode.addChild(new XMLNode(lower));
        lowerNode.addChild(rValNode);
        lowerNode.addChild(new XMLNode("\n              "));
        distNode.addChild(lowerNode);
        distNode.addChild(new XMLNode("\n              "));
        XMLNode upperNode = new XMLNode(new XMLTriple("upper"), new XMLAttributes(), new XMLNamespaces());
        rValNode = new XMLNode(new XMLTriple("rVal"), new XMLAttributes(), new XMLNamespaces());
        rValNode.addChild(new XMLNode(upper));
        upperNode.addChild(rValNode);
        upperNode.addChild(new XMLNode("\n              "));
        distNode.addChild(upperNode);
        distNode.addChild(new XMLNode("\n            "));
        draw.setUncertML(xmlNode);
    }

    public static void createStatisticsCollection(SBase sbase, String[] inputTypes, String[] inputs, String[] values) {
        DistribModelBuilder.createStatisticsCollection(sbase, inputTypes, inputs, values, new String[inputs.length], new String[inputs.length]);
    }

    public static void createStatisticsCollection(SBase sbase, String[] inputTypes, String[] inputs, String[] values, String[] attributeNames, String[] attributeValues) {
        DistribSBasePlugin distrib = (DistribSBasePlugin)sbase.getPlugin("distrib");
        Uncertainty draw = distrib.createUncertainty();
        String definition_base = "http://www.uncertml.org/statistics";
        if (attributeNames == null) {
            attributeNames = new String[inputs.length];
        }
        if (attributeValues == null) {
            attributeValues = new String[inputs.length];
        }
        XMLNode xmlNode = new XMLNode(new XMLTriple("UncertML"), new XMLAttributes(), new XMLNamespaces());
        xmlNode.addNamespace("http://www.uncertml.org/3.0");
        XMLNode distNode = new XMLNode(new XMLTriple("StatisticsCollection"), new XMLAttributes(), new XMLNamespaces());
        distNode.addAttr("definition", definition_base + "/statistics-collection");
        xmlNode.addChild(distNode);
        for (int i = 0; i < inputs.length; ++i) {
            String definition = definition_base + "/" + DistribModelBuilder.toUncertmlURL(inputTypes[i]);
            XMLNode inputNode = new XMLNode(new XMLTriple(inputTypes[i]), new XMLAttributes(), new XMLNamespaces());
            inputNode.addAttr("definition", definition);
            if (attributeNames[i] != null && attributeValues[i] != null) {
                inputNode.addAttr(attributeNames[i], attributeValues[i]);
            }
            distNode.addChild(inputNode);
            distNode.addChild(new XMLNode("\n              "));
            XMLNode valueNode = new XMLNode(new XMLTriple("value"), new XMLAttributes(), new XMLNamespaces());
            inputNode.addChild(valueNode);
            inputNode.addChild(new XMLNode("\n                "));
            XMLNode varNode = new XMLNode(new XMLTriple(inputs[i]), new XMLAttributes(), new XMLNamespaces());
            varNode.addChild(new XMLNode(values[i]));
            valueNode.addChild(varNode);
            valueNode.addChild(new XMLNode("\n                "));
        }
        draw.setUncertML(xmlNode);
    }

    private static String toUncertmlURL(String string) {
        StringBuffer sb = new StringBuffer();
        String lowercase = string.toLowerCase();
        sb.append(lowercase.charAt(0));
        for (int i = 1; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                sb.append('-').append(Character.toLowerCase(currentChar));
                continue;
            }
            sb.append(currentChar);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws SBMLException, XMLStreamException {
        SBMLDocument doc = new SBMLDocument(3, 1);
        Model m = doc.createModel("m");
        FunctionDefinition f = m.createFunctionDefinition("f");
        DistribModelBuilder.createDistribution(f, "NormalDistribution", new String[]{"mean", "stddev"}, new String[]{"avg", "sd"});
        Parameter p = m.createParameter("p1");
        DistribModelBuilder.createRange((SBase)p, "2.1", "4.5");
        Parameter p2 = m.createParameter("p2");
        DistribModelBuilder.createStatisticsCollection((SBase)p2, new String[]{"Mean", "StandardDeviation"}, new String[]{"rVal", "prVal"}, new String[]{"4.1", "0.5"});
        Parameter p3 = m.createParameter("p3");
        DistribModelBuilder.createStatisticsCollection((SBase)p3, new String[]{"Moment", "Moment"}, new String[]{"rVal", "rVal"}, new String[]{"4.1", "0.5"}, new String[]{"order", "order"}, new String[]{"1", "2"});
        String docStr = new SBMLWriter().writeSBMLToString(doc);
        System.out.println("Document = \n" + docStr);
        SBMLDocument doc2 = new SBMLReader().readSBMLFromString(docStr);
        String docStr2 = new SBMLWriter().writeSBMLToString(doc2);
        System.out.println(docStr.equals(docStr2));
    }
}

