/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.Constraint;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.distrib.DrawFromDistribution;
import org.sbml.jsbml.ext.distrib.Uncertainty;
import org.sbml.jsbml.xml.XMLAttributes;
import org.sbml.jsbml.xml.XMLNamespaces;
import org.sbml.jsbml.xml.XMLNode;
import org.sbml.jsbml.xml.XMLTriple;
import org.sbml.jsbml.xml.parsers.XMLNodeReader;

public class UncertMLXMLNodeReader
extends XMLNodeReader {
    private static final transient Logger logger = Logger.getLogger(UncertMLXMLNodeReader.class);
    private static final List<String> namespaces = new ArrayList<String>();

    public void processCharactersOf(String elementName, String characters, Object contextObject) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("processCharactersOf called: characters = @{0}@", characters));
        }
        XMLNode textNode = new XMLNode(characters);
        if (contextObject instanceof XMLNode) {
            XMLNode xmlNode = (XMLNode)contextObject;
            xmlNode.addChild(textNode);
        } else if (contextObject instanceof DrawFromDistribution) {
            DrawFromDistribution parentSBMLElement = (DrawFromDistribution)((Object)contextObject);
            XMLNode xmlNode = null;
            if (!parentSBMLElement.isSetUncertML()) {
                if (characters != null && characters.trim().length() > 0) {
                    logger.warn((Object)MessageFormat.format("The type of String ''{0}'' on the element {1} is unknown! Some data might be lost: ''{2}''.", "UncertML", parentSBMLElement.getElementName(), characters));
                }
                return;
            }
            xmlNode = parentSBMLElement.getUncertML();
            xmlNode.addChild(textNode);
        } else if (contextObject instanceof Uncertainty) {
            Uncertainty parentSBMLElement = (Uncertainty)((Object)contextObject);
            XMLNode xmlNode = null;
            if (!parentSBMLElement.isSetUncertML()) {
                if (characters != null && characters.trim().length() > 0) {
                    logger.warn((Object)MessageFormat.format("The type of String ''{0}'' on the element {1} is unknown! Some data might be lost: ''{2}''.", "UncertML", parentSBMLElement.getElementName(), characters));
                }
                return;
            }
            xmlNode = parentSBMLElement.getUncertML();
            xmlNode.addChild(textNode);
        } else {
            if (characters != null && characters.trim().length() > 0) {
                logger.warn((Object)MessageFormat.format("The type of String ''{0}'' on the element {1} is unknown! Some data might be lost: ''{2}''.", "UncertML", contextObject.getClass().getSimpleName(), characters));
            }
            return;
        }
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        logger.debug((Object)MessageFormat.format("processStartElement: element name = {0}", elementName));
        if (elementName.equalsIgnoreCase("UncertML") && contextObject instanceof DrawFromDistribution) {
            DrawFromDistribution sbase = (DrawFromDistribution)((Object)contextObject);
            XMLNode xmlNode = new XMLNode(new XMLTriple(elementName, uri, prefix), new XMLAttributes(), new XMLNamespaces());
            sbase.setUncertML(xmlNode);
            return xmlNode;
        }
        if (elementName.equalsIgnoreCase("UncertML") && contextObject instanceof Uncertainty) {
            Uncertainty sbase = (Uncertainty)((Object)contextObject);
            XMLNode xmlNode = new XMLNode(new XMLTriple(elementName, uri, prefix), new XMLAttributes(), new XMLNamespaces());
            sbase.setUncertML(xmlNode);
            return xmlNode;
        }
        XMLNode xmlNode = new XMLNode(new XMLTriple(elementName, uri, prefix), new XMLAttributes(), new XMLNamespaces());
        if (contextObject instanceof XMLNode) {
            XMLNode parentNode = (XMLNode)contextObject;
            parentNode.addChild(xmlNode);
        } else if (contextObject instanceof Constraint) {
            ((SBase)contextObject).putUserObject((Object)SBMLReader.UNKNOWN_XML_NODE, (Object)xmlNode);
        } else if (contextObject != null) {
            logger.warn((Object)("XMLNode might be lost !!! elementName = '" + elementName + "' contextObject = " + contextObject.getClass().getSimpleName()));
        }
        return xmlNode;
    }

    public List<String> getNamespaces() {
        return namespaces;
    }

    static {
        namespaces.add("http://www.uncertml.org/3.0");
    }
}

