/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.FunctionDefinition;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBMLWriter;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.distrib.DistribConstants;
import org.sbml.jsbml.ext.distrib.DistribFunctionDefinitionPlugin;
import org.sbml.jsbml.ext.distrib.DistribInput;
import org.sbml.jsbml.ext.distrib.DistribSBasePlugin;
import org.sbml.jsbml.ext.distrib.DrawFromDistribution;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class DistribParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(DistribParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/distrib/version1";
    }

    public String getShortLabel() {
        return "distrib";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + sbase.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (sbase instanceof SBase && ((SBase)sbase).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)sbase).getExtension(this.getNamespaceURI());
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
            logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(sbase);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listOfElementsToWrite.size() not null = " + (listOfElementsToWrite != null ? listOfElementsToWrite.size() : 0)));
        }
        return listOfElementsToWrite;
    }

    public boolean processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processAttribute -> " + prefix + ":" + attributeName + " = " + value + " (" + contextObject.getClass().getName() + ")"));
        }
        if (contextObject instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)contextObject;
            DistribFunctionDefinitionPlugin fbcFD = null;
            if (fd.getExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1") != null) {
                fbcFD = (DistribFunctionDefinitionPlugin)fd.getExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            } else {
                fbcFD = new DistribFunctionDefinitionPlugin(fd);
                fd.addExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1", (SBasePlugin)fbcFD);
            }
            contextObject = fbcFD;
        }
        return super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof FunctionDefinition) {
            FunctionDefinition fd = (FunctionDefinition)contextObject;
            DistribFunctionDefinitionPlugin distribFD = null;
            if (fd.getExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1") != null) {
                distribFD = (DistribFunctionDefinitionPlugin)fd.getExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            } else {
                distribFD = new DistribFunctionDefinitionPlugin(fd);
                fd.addExtension("http://www.sbml.org/sbml/level3/version1/distrib/version1", (SBasePlugin)distribFD);
            }
            if (elementName.equals("drawFromDistribution")) {
                DrawFromDistribution dfd = distribFD.createDrawFromDistribution();
                return dfd;
            }
        } else if (contextObject instanceof DrawFromDistribution) {
            DrawFromDistribution dfd = (DrawFromDistribution)((Object)contextObject);
            if (elementName.equals("listOfDistribInputs")) {
                ListOf<DistribInput> listOfDistribInputs = dfd.getListOfDistribInputs();
                return listOfDistribInputs;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            if (elementName.equals("distribInput")) {
                DrawFromDistribution dfd = (DrawFromDistribution)listOf.getParentSBMLObject();
                DistribInput input = dfd.createDistribInput();
                return input;
            }
        }
        if (contextObject instanceof SBase) {
            SBase sbase = (SBase)contextObject;
            DistribSBasePlugin distribSBase = null;
            if (sbase.getExtension("distrib") != null) {
                distribSBase = (DistribSBasePlugin)sbase.getExtension("distrib");
            } else {
                distribSBase = new DistribSBasePlugin(sbase);
                sbase.addExtension("distrib", (SBasePlugin)distribSBase);
            }
            if (elementName.equals("uncertainty")) {
                return distribSBase.createUncertainty();
            }
        }
        return contextObject;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        if (sbmlElementToWrite instanceof SBase) {
            SBase sbase = (SBase)sbmlElementToWrite;
            if (!xmlObject.isSetName()) {
                if (sbase instanceof ListOf) {
                    ListOf listOf = (ListOf)sbase;
                    if (listOf.size() > 0 && listOf.get(0) instanceof DistribInput) {
                        xmlObject.setName("listOfDistribInputs");
                    }
                } else {
                    xmlObject.setName(sbase.getElementName());
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("writeElement " + xmlObject.getName()));
        }
    }

    public static void main(String[] args) throws SBMLException {
        if (args.length < 1) {
            System.out.println("Usage: java org.sbml.jsbml.xml.stax.SBMLWriter sbmlFileName");
            System.exit(0);
        }
        File argsAsFile = new File(args[0]);
        File[] files = null;
        files = argsAsFile.isDirectory() ? argsAsFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().contains("-jsbml")) {
                    return false;
                }
                return pathname.getName().endsWith(".xml");
            }
        }) : new File[]{argsAsFile};
        for (File file : files) {
            long init = Calendar.getInstance().getTimeInMillis();
            System.out.println(Calendar.getInstance().getTime());
            String fileName = file.getAbsolutePath();
            String jsbmlWriteFileName = fileName.replaceFirst(".xml", "-jsbml.xml");
            System.out.printf("Reading %s and writing %s\n", fileName, jsbmlWriteFileName);
            long afterRead = 0L;
            try {
                SBMLDocument testDocument = new SBMLReader().readSBMLFromFile(fileName);
                System.out.printf("Reading done\n", new Object[0]);
                System.out.println(Calendar.getInstance().getTime());
                afterRead = Calendar.getInstance().getTimeInMillis();
                System.out.printf("Starting writing\n", new Object[0]);
                new SBMLWriter().write(testDocument.clone(), jsbmlWriteFileName);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(Calendar.getInstance().getTime());
            long end = Calendar.getInstance().getTimeInMillis();
            long nbSecondes = (end - init) / 1000L;
            long nbSecondesRead = (afterRead - init) / 1000L;
            long nbSecondesWrite = (end - afterRead) / 1000L;
            if (nbSecondes > 120L) {
                System.out.println("It took " + nbSecondes / 60L + " minutes.");
            } else {
                System.out.println("It took " + nbSecondes + " secondes.");
            }
            System.out.println("Reading: " + nbSecondesRead + " secondes.");
            System.out.println("Writing: " + nbSecondesWrite + " secondes.");
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        return "http://www.sbml.org/sbml/level3/version1/distrib/version1";
    }

    public List<String> getNamespaces() {
        return DistribConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "distrib";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof FunctionDefinition) {
                return new DistribFunctionDefinitionPlugin((FunctionDefinition)sbase);
            }
            return new DistribSBasePlugin(sbase);
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

