/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.distrib;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AbstractMathContainer;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.MathContainer;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Unit;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.distrib.AbstractDistribSBase;
import org.sbml.jsbml.text.parser.ParseException;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.util.converters.ExpandFunctionDefinitionConverter;

public class UncertParameter
extends AbstractDistribSBase
implements MathContainer {
    private static final transient Logger logger = Logger.getLogger(AbstractMathContainer.class);
    private Type type;
    private Double value;
    private String var;
    private String units;
    private String definitionURL;
    private ASTNode math;
    private ListOf<UncertParameter> listOfUncertParameters;

    public UncertParameter() {
        this.initDefaults();
    }

    public UncertParameter(String id) {
        super(id);
        this.initDefaults();
    }

    public UncertParameter(int level, int version) {
        this(null, null, level, version);
    }

    public UncertParameter(String id, int level, int version) {
        this(id, null, level, version);
    }

    public UncertParameter(String id, String name, int level, int version) {
        super(id, name, level, version);
        this.initDefaults();
    }

    public UncertParameter(UncertParameter obj) {
        super(obj);
        if (obj.isSetType()) {
            this.setType(obj.getType());
        }
        if (obj.isSetValue()) {
            this.setValue(obj.getValue());
        }
        if (obj.isSetVar()) {
            this.setVar(obj.getVar());
        }
        if (obj.isSetValue()) {
            this.setValue(obj.getValue());
        }
        if (obj.isSetUnits()) {
            this.setUnits(obj.getUnits());
        }
        if (obj.isSetDefinitionURL()) {
            this.setDefinitionURL(obj.getDefinitionURL());
        }
        if (obj.isSetMath()) {
            this.setMath(obj.getMath().clone());
        }
        if (obj.isSetListOfUncertParameters()) {
            this.setListOfUncertParameters((ListOf<UncertParameter>)obj.getListOfUncertParameters().clone());
        }
    }

    public UncertParameter clone() {
        return new UncertParameter(this);
    }

    public void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/distrib/version1");
        this.packageName = "distrib";
        this.setPackageVersion(-1);
    }

    public Type getType() {
        if (this.isSetType()) {
            return this.type;
        }
        throw new PropertyUndefinedError("type", (SBase)this);
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.firePropertyChange("type", (Object)oldType, (Object)this.type);
    }

    public boolean unsetType() {
        if (this.isSetType()) {
            Type oldType = this.type;
            this.type = null;
            this.firePropertyChange("type", (Object)oldType, (Object)this.type);
            return true;
        }
        return false;
    }

    public double getValue() {
        if (this.isSetValue()) {
            return this.value;
        }
        throw new PropertyUndefinedError("value", (SBase)this);
    }

    public boolean isSetValue() {
        return this.value != null;
    }

    public void setValue(double value) {
        Double oldValue = this.value;
        this.value = value;
        this.firePropertyChange("value", oldValue, this.value);
    }

    public boolean unsetValue() {
        if (this.isSetValue()) {
            Double oldValue = this.value;
            this.value = null;
            this.firePropertyChange("value", oldValue, this.value);
            return true;
        }
        return false;
    }

    public String getVar() {
        if (this.isSetVar()) {
            return this.var;
        }
        throw new PropertyUndefinedError("var", (SBase)this);
    }

    public boolean isSetVar() {
        return this.var != null;
    }

    public void setVar(String var) {
        String oldVar = this.var;
        this.var = var;
        this.firePropertyChange("var", oldVar, this.var);
    }

    public boolean unsetVar() {
        if (this.isSetVar()) {
            String oldVar = this.var;
            this.var = null;
            this.firePropertyChange("var", oldVar, this.var);
            return true;
        }
        return false;
    }

    public String getUnits() {
        if (this.isSetUnits()) {
            return this.units;
        }
        return null;
    }

    public boolean isSetUnits() {
        return this.units != null;
    }

    public void setUnits(String units) {
        String oldUnits = this.units;
        this.units = units;
        this.firePropertyChange("units", oldUnits, this.units);
    }

    public boolean unsetUnits() {
        if (this.isSetUnits()) {
            String oldUnits = this.units;
            this.units = null;
            this.firePropertyChange("units", oldUnits, this.units);
            return true;
        }
        return false;
    }

    public String getDefinitionURL() {
        if (this.isSetDefinitionURL()) {
            return this.definitionURL;
        }
        return null;
    }

    public boolean isSetDefinitionURL() {
        return this.definitionURL != null;
    }

    public void setDefinitionURL(String definitionURL) {
        String oldDefinitionURL = this.definitionURL;
        this.definitionURL = definitionURL;
        this.firePropertyChange("definitionURL", oldDefinitionURL, this.definitionURL);
    }

    public boolean unsetDefinitionURL() {
        if (this.isSetDefinitionURL()) {
            String oldDefinitionURL = this.definitionURL;
            this.definitionURL = null;
            this.firePropertyChange("definitionURL", oldDefinitionURL, this.definitionURL);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 907;
        int result = super.hashCode();
        result = 907 * result + (this.definitionURL == null ? 0 : this.definitionURL.hashCode());
        result = 907 * result + (this.listOfUncertParameters == null ? 0 : this.listOfUncertParameters.hashCode());
        result = 907 * result + (this.math == null ? 0 : this.math.hashCode());
        result = 907 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 907 * result + (this.units == null ? 0 : this.units.hashCode());
        result = 907 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 907 * result + (this.var == null ? 0 : this.var.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UncertParameter other = (UncertParameter)((Object)obj);
        if (this.definitionURL == null ? other.definitionURL != null : !this.definitionURL.equals(other.definitionURL)) {
            return false;
        }
        if (this.listOfUncertParameters == null ? other.listOfUncertParameters != null : !this.listOfUncertParameters.equals(other.listOfUncertParameters)) {
            return false;
        }
        if (this.math == null ? other.math != null : !this.math.equals((Object)other.math)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.units == null ? other.units != null : !this.units.equals(other.units)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals(other.var));
    }

    public boolean containsUndeclaredUnits() {
        return this.isSetMath() ? this.math.containsUndeclaredUnits() : false;
    }

    public UnitDefinition getDerivedUnitDefinition() {
        Model m;
        UnitDefinition ud = null;
        if (this.isSetMath()) {
            m = this.getModel();
            ASTNode expandedMath = this.math;
            if (m != null && m.getFunctionDefinitionCount() > 0) {
                expandedMath = ExpandFunctionDefinitionConverter.expandFunctionDefinition((Model)m, (ASTNode)this.math);
            }
            try {
                ud = expandedMath.deriveUnit();
            }
            catch (Throwable exc) {
                String name;
                if (this instanceof NamedSBase) {
                    name = this.toString();
                } else {
                    name = this.getElementName();
                    SBase parent = this.getParentSBMLObject();
                    if (parent != null && parent instanceof NamedSBase) {
                        name = MessageFormat.format(resourceBundle.getString("AbstractMathContainer.inclusion"), name, parent.toString());
                    }
                }
                logger.warn((Object)MessageFormat.format(resourceBundle.getString("AbstractMathContainer.getDerivedUnitDefinition"), name, exc.getLocalizedMessage()));
                logger.debug((Object)exc.getLocalizedMessage(), exc);
            }
        }
        if (ud != null) {
            m = this.getModel();
            if (m != null) {
                UnitDefinition u = m.isSetListOfUnitDefinitions() ? m.findIdentical(ud) : null;
                return u != null ? u : ud;
            }
        } else {
            ud = new UnitDefinition(this.getLevel(), this.getVersion());
            ud.createInvalidUnit();
        }
        return ud;
    }

    public String getDerivedUnits() {
        Unit u;
        UnitDefinition ud = this.getDerivedUnitDefinition();
        Model m = this.getModel();
        if (m != null && m.getUnitDefinition(ud.getId()) != null) {
            return ud.getId();
        }
        if (ud.getUnitCount() == 1 && (u = ud.getUnit(0)).getOffset() == 0.0 && u.getMultiplier() == 1.0 && u.getScale() == 0 && u.getExponent() == 1.0) {
            return u.getKind().toString().toLowerCase();
        }
        return null;
    }

    @Deprecated
    public String getFormula() {
        try {
            return this.isSetMath() ? this.getMath().toFormula() : "";
        }
        catch (Throwable exc) {
            logger.warn((Object)resourceBundle.getString("AbstractMathContainer.toFormula"), exc);
            return "invalid";
        }
    }

    public ASTNode getMath() {
        return this.math;
    }

    public String getMathMLString() {
        if (this.isSetMath()) {
            return this.math.toMathML();
        }
        return "";
    }

    public boolean isSetMath() {
        return this.math != null;
    }

    @Deprecated
    public void setFormula(String formula) throws ParseException {
        this.setMath(ASTNode.parseFormula((String)formula));
    }

    public void setMath(ASTNode math) {
        ASTNode oldMath = this.math;
        this.math = math;
        if (oldMath != null) {
            oldMath.fireNodeRemovedEvent();
        }
        if (this.math != null) {
            ASTNode.setParentSBMLObject((ASTNode)math, (MathContainer)this);
            this.firePropertyChange("math", oldMath, this.math);
        }
    }

    @Deprecated
    public void unsetFormula() {
        this.unsetMath();
    }

    public void unsetMath() {
        this.setMath(null);
    }

    public boolean isSetListOfUncertParameters() {
        return this.listOfUncertParameters != null;
    }

    public ListOf<UncertParameter> getListOfUncertParameters() {
        if (this.listOfUncertParameters == null) {
            this.listOfUncertParameters = new ListOf();
            this.listOfUncertParameters.setNamespace("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            this.listOfUncertParameters.setPackageVersion(-1);
            this.listOfUncertParameters.setPackageName(null);
            this.listOfUncertParameters.setPackageName("distrib");
            this.listOfUncertParameters.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfUncertParameters);
        }
        return this.listOfUncertParameters;
    }

    public void setListOfUncertParameters(ListOf<UncertParameter> listOfUncertParameters) {
        this.unsetListOfUncertParameters();
        this.listOfUncertParameters = listOfUncertParameters;
        if (listOfUncertParameters != null) {
            listOfUncertParameters.unsetNamespace();
            listOfUncertParameters.setNamespace("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            listOfUncertParameters.setPackageVersion(-1);
            listOfUncertParameters.setPackageName(null);
            listOfUncertParameters.setPackageName("distrib");
            this.listOfUncertParameters.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)listOfUncertParameters);
        }
    }

    public boolean unsetListOfUncertParameters() {
        if (this.isSetListOfUncertParameters()) {
            ListOf<UncertParameter> oldUncertParameters = this.listOfUncertParameters;
            this.listOfUncertParameters = null;
            oldUncertParameters.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addUncertParameter(UncertParameter uncertParameter) {
        return this.getListOfUncertParameters().add((SBase)uncertParameter);
    }

    public boolean removeUncertParameter(UncertParameter uncertParameter) {
        if (this.isSetListOfUncertParameters()) {
            return this.getListOfUncertParameters().remove((SBase)uncertParameter);
        }
        return false;
    }

    public UncertParameter removeUncertParameter(String uncertParameterId) {
        if (this.isSetListOfUncertParameters()) {
            return (UncertParameter)this.getListOfUncertParameters().remove(uncertParameterId);
        }
        return null;
    }

    public UncertParameter removeUncertParameter(int i) {
        if (!this.isSetListOfUncertParameters()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (UncertParameter)this.getListOfUncertParameters().remove(i);
    }

    public UncertParameter createUncertParameter() {
        return this.createUncertParameter(null);
    }

    public UncertParameter createUncertParameter(String id) {
        UncertParameter uncertParameter = new UncertParameter(id);
        this.addUncertParameter(uncertParameter);
        return uncertParameter;
    }

    public UncertParameter getUncertParameter(int i) {
        if (!this.isSetListOfUncertParameters()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (UncertParameter)this.getListOfUncertParameters().get(i);
    }

    public UncertParameter getUncertParameter(String uncertParameterId) {
        if (this.isSetListOfUncertParameters()) {
            return (UncertParameter)this.getListOfUncertParameters().get(uncertParameterId);
        }
        return null;
    }

    public int getUncertParameterCount() {
        return this.isSetListOfUncertParameters() ? this.getListOfUncertParameters().size() : 0;
    }

    public int getNumUncertParameters() {
        return this.getUncertParameterCount();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetMath()) {
            if (index == pos) {
                return this.getMath();
            }
            ++pos;
        }
        if (this.isSetListOfUncertParameters()) {
            if (index == pos) {
                return this.getListOfUncertParameters();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetMath()) {
            ++count;
        }
        if (this.isSetListOfUncertParameters()) {
            ++count;
        }
        return count;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetValue()) {
            attributes.put("distrib:value", this.value.toString());
        }
        if (this.isSetVar()) {
            attributes.put("distrib:var", this.getVar());
        }
        if (this.isSetUnits()) {
            attributes.put("distrib:units", this.getUnits());
        }
        if (this.isSetDefinitionURL()) {
            attributes.put("distrib:definitionURL", this.getDefinitionURL());
        }
        if (this.isSetType()) {
            attributes.put("distrib:type", this.getType().toString());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("value")) {
                this.setValue(StringTools.parseSBMLDouble((String)value));
            } else if (attributeName.equals("var")) {
                this.setVar(value);
            } else if (attributeName.equals("units")) {
                this.setUnits(value);
            } else if (attributeName.equals("definitionURL")) {
                this.setDefinitionURL(value);
            } else if (attributeName.equals("type")) {
                this.setType(Type.valueOf(value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public static enum Type {
        coefficientOfVariation,
        kurtosis,
        mean,
        median,
        mode,
        sampleSize,
        skewness,
        standardDeviation,
        standardError,
        variance,
        confidenceInterval,
        credibleInterval,
        interquartileRange,
        range,
        distribution,
        externalParameter;

    }
}

