/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.distrib;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.distrib.AbstractDistribSBase;
import org.sbml.jsbml.ext.distrib.UncertParameter;
import org.sbml.jsbml.ext.distrib.UncertSpan;

public class Uncertainty
extends AbstractDistribSBase {
    private static final long serialVersionUID = -904719821379100471L;
    private ListOf<UncertParameter> listOfUncertParameters;

    public Uncertainty() {
        this.initDefaults();
    }

    public Uncertainty(String id) {
        super(id);
        this.initDefaults();
    }

    public Uncertainty(int level, int version) {
        this(null, null, level, version);
    }

    public Uncertainty(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Uncertainty(String id, String name, int level, int version) {
        super(id, name, level, version);
        this.initDefaults();
    }

    public Uncertainty(Uncertainty obj) {
        super(obj);
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "distrib";
    }

    public boolean isIdMandatory() {
        return false;
    }

    public Uncertainty clone() {
        return new Uncertainty(this);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.getUncertParameterCount() > 0) {
            count += this.getUncertParameterCount();
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.getUncertParameterCount() > 0) {
            for (UncertParameter uncertParam : this.listOfUncertParameters) {
                if (index == pos) {
                    return uncertParam;
                }
                ++pos;
            }
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public boolean isSetListOfUncertParameters() {
        return this.listOfUncertParameters != null;
    }

    public ListOf<UncertParameter> getListOfUncertParameters() {
        if (this.listOfUncertParameters == null) {
            this.listOfUncertParameters = new ListOf();
            this.listOfUncertParameters.setNamespace("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            this.listOfUncertParameters.setPackageVersion(-1);
            this.listOfUncertParameters.setPackageName(null);
            this.listOfUncertParameters.setPackageName("distrib");
            this.listOfUncertParameters.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfUncertParameters);
        }
        return this.listOfUncertParameters;
    }

    public void setListOfUncertParameters(ListOf<UncertParameter> listOfUncertParameters) {
        this.unsetListOfUncertParameters();
        this.listOfUncertParameters = listOfUncertParameters;
        if (listOfUncertParameters != null) {
            listOfUncertParameters.unsetNamespace();
            listOfUncertParameters.setNamespace("http://www.sbml.org/sbml/level3/version1/distrib/version1");
            listOfUncertParameters.setPackageVersion(-1);
            listOfUncertParameters.setPackageName(null);
            listOfUncertParameters.setPackageName("distrib");
            this.listOfUncertParameters.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)listOfUncertParameters);
        }
    }

    public boolean unsetListOfUncertParameters() {
        if (this.isSetListOfUncertParameters()) {
            ListOf<UncertParameter> oldUncertParameters = this.listOfUncertParameters;
            this.listOfUncertParameters = null;
            oldUncertParameters.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addUncertParameter(UncertParameter uncertParameter) {
        return this.getListOfUncertParameters().add((SBase)uncertParameter);
    }

    public boolean removeUncertParameter(UncertParameter uncertParameter) {
        if (this.isSetListOfUncertParameters()) {
            return this.getListOfUncertParameters().remove((SBase)uncertParameter);
        }
        return false;
    }

    public UncertParameter removeUncertParameter(String uncertParameterId) {
        if (this.isSetListOfUncertParameters()) {
            return (UncertParameter)this.getListOfUncertParameters().remove(uncertParameterId);
        }
        return null;
    }

    public UncertParameter removeUncertParameter(int i) {
        if (!this.isSetListOfUncertParameters()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (UncertParameter)this.getListOfUncertParameters().remove(i);
    }

    public UncertParameter createUncertParameter() {
        return this.createUncertParameter(null);
    }

    public UncertParameter createUncertParameter(String id) {
        UncertParameter uncertParameter = new UncertParameter(id);
        this.addUncertParameter(uncertParameter);
        return uncertParameter;
    }

    public UncertSpan createUncertSpan() {
        return this.createUncertSpan(null);
    }

    public UncertSpan createUncertSpan(String id) {
        UncertSpan uncertParameter = new UncertSpan(id);
        this.addUncertParameter(uncertParameter);
        return uncertParameter;
    }

    public UncertParameter getUncertParameter(int i) {
        if (!this.isSetListOfUncertParameters()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (UncertParameter)this.getListOfUncertParameters().get(i);
    }

    public UncertParameter getUncertParameter(String uncertParameterId) {
        if (this.isSetListOfUncertParameters()) {
            return (UncertParameter)this.getListOfUncertParameters().get(uncertParameterId);
        }
        return null;
    }

    public int getUncertParameterCount() {
        return this.isSetListOfUncertParameters() ? this.getListOfUncertParameters().size() : 0;
    }

    public int getNumUncertParameters() {
        return this.getUncertParameterCount();
    }
}

