/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.distrib.DistribConstants;
import org.sbml.jsbml.ext.distrib.DistribSBasePlugin;
import org.sbml.jsbml.ext.distrib.UncertParameter;
import org.sbml.jsbml.ext.distrib.UncertSpan;
import org.sbml.jsbml.ext.distrib.Uncertainty;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class DistribParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient Logger logger = Logger.getLogger(DistribParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/distrib/version1";
    }

    public String getShortLabel() {
        return "distrib";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + sbase.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (sbase instanceof SBase && ((SBase)sbase).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)sbase).getExtension(this.getNamespaceURI());
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
            logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(sbase);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listOfElementsToWrite.size() not null = " + (listOfElementsToWrite != null ? listOfElementsToWrite.size() : 0)));
        }
        return listOfElementsToWrite;
    }

    public boolean processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processAttribute -> " + prefix + ":" + attributeName + " = " + value + " (" + contextObject.getClass().getName() + ")"));
        }
        return super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            Object newElement = this.createListOfChild(listOf, elementName);
            if (newElement != null) {
                return newElement;
            }
        } else if (contextObject instanceof Uncertainty) {
            Uncertainty uncert = (Uncertainty)((Object)contextObject);
            if (elementName.equals("uncertParameter")) {
                UncertParameter uncertParam = uncert.createUncertParameter();
                return uncertParam;
            }
            if (elementName.equals("uncertSpan")) {
                UncertSpan uncertSpan = uncert.createUncertSpan();
                return uncertSpan;
            }
        } else if (contextObject instanceof UncertParameter && elementName.equals("listOfUncertParameters")) {
            return ((UncertParameter)((Object)contextObject)).getListOfUncertParameters();
        }
        if (contextObject instanceof SBase) {
            SBase sbase = (SBase)contextObject;
            DistribSBasePlugin distribSBase = null;
            if (sbase.getExtension("distrib") != null) {
                distribSBase = (DistribSBasePlugin)sbase.getExtension("distrib");
            } else {
                distribSBase = new DistribSBasePlugin(sbase);
                sbase.addExtension("distrib", (SBasePlugin)distribSBase);
            }
            if (elementName.equals("uncertainty")) {
                return distribSBase.createUncertainty();
            }
        }
        return contextObject;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        if (sbmlElementToWrite instanceof SBase) {
            SBase sbase = (SBase)sbmlElementToWrite;
            if (!xmlObject.isSetName()) {
                xmlObject.setName(sbase.getElementName());
            }
            if (xmlObject.getName().equals("listOfUncertaintys")) {
                xmlObject.setName("listOfUncertainties");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("writeElement " + xmlObject.getName()));
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        return "http://www.sbml.org/sbml/level3/version1/distrib/version1";
    }

    public List<String> getNamespaces() {
        return DistribConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "distrib";
    }

    public boolean isRequired() {
        return true;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            return new DistribSBasePlugin(sbase);
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }
}

