/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.dyn;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.biojava3.ontology.Ontology;
import org.biojava3.ontology.Term;
import org.biojava3.ontology.io.OboParser;
import org.sbml.jsbml.ontology.Triple;
import org.sbml.jsbml.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBO {
    private static final String prefix = "http://cbo.biocomplexity.indiana.edu/svn/cbo/trunk/CBO_1_0.owl#";
    private static Ontology cbo;
    private static Set<org.sbml.jsbml.ontology.Term> terms;

    public static boolean checkTerm(String cboTerm) {
        return cboTerm.startsWith(prefix);
    }

    public static Ontology getOntology() {
        return cbo;
    }

    public static org.sbml.jsbml.ontology.Term getTerm(String cboTerm) {
        return new org.sbml.jsbml.ontology.Term(cbo.getTerm(cboTerm));
    }

    public static Set<org.sbml.jsbml.ontology.Term> getTerms() {
        if (terms.size() < cbo.getTerms().size()) {
            for (Term term : cbo.getTerms()) {
                if (!(term instanceof Term)) continue;
                terms.add(new org.sbml.jsbml.ontology.Term(term));
            }
        }
        return terms;
    }

    public static Set<Triple> getTriples(org.sbml.jsbml.ontology.Term subject, org.sbml.jsbml.ontology.Term predicate, org.sbml.jsbml.ontology.Term object) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (org.biojava3.ontology.Triple triple : cbo.getTriples(subject != null ? subject.getTerm() : null, object != null ? object.getTerm() : null, predicate != null ? predicate.getTerm() : null)) {
            triples.add(new Triple(triple));
        }
        return triples;
    }

    public static void main(String[] args) {
        int i = 0;
        for (org.sbml.jsbml.ontology.Term term : CBO.getTerms()) {
            System.out.println(org.sbml.jsbml.ontology.Term.printTerm((org.sbml.jsbml.ontology.Term)term));
            ++i;
        }
        System.out.println("\nThere is " + i + " terms in the CBO ontology.");
        System.out.println("Get CellDeath by name = " + org.sbml.jsbml.ontology.Term.printTerm((org.sbml.jsbml.ontology.Term)CBO.getTerm("CellDeath")));
        System.out.println("Get CellDeath by id (url) = " + org.sbml.jsbml.ontology.Term.printTerm((org.sbml.jsbml.ontology.Term)CBO.getTerm("http://cbo.biocomplexity.indiana.edu/svn/cbo/trunk/CBO_1_0.owl#CellDeath")));
    }

    static {
        OboParser parser = new OboParser();
        try {
            String path = "org/sbml/jsbml/ext/dyn/";
            InputStream is = Resource.getInstance().getStreamFromResourceLocation(path + "CBO_OBO.obo");
            cbo = parser.parseOBO(new BufferedReader(new InputStreamReader(is)), "CBO", "Cell Behavior Ontology");
            terms = new HashSet<org.sbml.jsbml.ontology.Term>();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

