/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.Event;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.dyn.DynCompartmentPlugin;
import org.sbml.jsbml.ext.dyn.DynConstants;
import org.sbml.jsbml.ext.dyn.DynElement;
import org.sbml.jsbml.ext.dyn.DynEventPlugin;
import org.sbml.jsbml.ext.dyn.DynSBasePlugin;
import org.sbml.jsbml.ext.dyn.SpatialComponent;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynParser
extends AbstractReaderWriter
implements PackageParser {
    private Logger logger = Logger.getLogger(DynParser.class);

    public List<String> getNamespaces() {
        return DynConstants.namespaces;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Event) {
                return new DynEventPlugin((Event)sbase);
            }
            if (sbase instanceof Compartment) {
                return new DynCompartmentPlugin((Compartment)sbase);
            }
            return new DynSBasePlugin(sbase);
        }
        return null;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/dyn/version1";
        }
        return null;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "dyn";
    }

    public boolean isRequired() {
        return false;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        ListOf listOf;
        Object newElement;
        if (contextObject instanceof Compartment) {
            Compartment compartment = (Compartment)contextObject;
            DynCompartmentPlugin dynCompartment = null;
            if (compartment.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1") != null) {
                dynCompartment = (DynCompartmentPlugin)compartment.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1");
            } else {
                dynCompartment = new DynCompartmentPlugin(compartment);
                compartment.addExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1", (SBasePlugin)dynCompartment);
            }
            if (elementName.equals("listOfSpatialComponents")) {
                ListOf<SpatialComponent> componentList = dynCompartment.getListOfSpatialComponents();
                return componentList;
            }
        } else if (contextObject instanceof Event) {
            Event event = (Event)contextObject;
            DynEventPlugin dynEvent = null;
            if (event.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1") != null) {
                dynEvent = (DynEventPlugin)event.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1");
            } else {
                dynEvent = new DynEventPlugin(event);
                event.addExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1", (SBasePlugin)dynEvent);
            }
            if (elementName.equals("listOfDynElements")) {
                ListOf<DynElement> listOfDynElements = dynEvent.getListOfDynElements();
                return listOfDynElements;
            }
        } else if (contextObject instanceof ListOf && (newElement = this.createListOfChild(listOf = (ListOf)contextObject, elementName)) != null) {
            return newElement;
        }
        return contextObject;
    }

    public void processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        if (contextObject instanceof Event) {
            Event event = (Event)contextObject;
            DynEventPlugin dynEvent = null;
            if (event.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1") != null) {
                dynEvent = (DynEventPlugin)event.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1");
            } else {
                dynEvent = new DynEventPlugin(event);
                event.addExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1", (SBasePlugin)dynEvent);
            }
            contextObject = dynEvent;
            elementName = ((Object)((Object)dynEvent)).getClass().getSimpleName();
        }
        super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public String getShortLabel() {
        return "dyn";
    }

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/dyn/version1";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object treeNode) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getListOfSBMLElementsToWrite: " + treeNode.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (treeNode instanceof SBase && ((SBase)treeNode).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)treeNode).getExtension(this.getNamespaceURI());
            if (sbasePlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
                this.logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(treeNode);
        }
        return listOfElementsToWrite;
    }

    protected Object createListOfChild(ListOf<?> listOf, String elementName) {
        block13: {
            SBase parentSBase = listOf.getParent();
            if (parentSBase == null) {
                return null;
            }
            if (parentSBase instanceof Compartment || parentSBase instanceof Event) {
                parentSBase = parentSBase.getExtension("http://www.sbml.org/sbml/level3/version1/dyn/version1");
            }
            String createMethodName = "create" + elementName.substring(0, 1).toUpperCase() + elementName.substring(1);
            Method createMethod = null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Method '" + createMethodName + "' will be used"));
            }
            try {
                createMethod = parentSBase.getClass().getMethod(createMethodName, null);
                return createMethod.invoke((Object)parentSBase, (Object[])null);
            }
            catch (SecurityException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' is not accessible on " + parentSBase.getClass().getSimpleName()));
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Method '" + createMethodName + "' does not exist on " + parentSBase.getClass().getSimpleName()));
                }
            }
            catch (IllegalArgumentException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (IllegalAccessException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                    this.logger.debug((Object)e.getMessage());
                }
            }
            catch (InvocationTargetException e) {
                if (!this.logger.isDebugEnabled()) break block13;
                this.logger.debug((Object)("Problem invoking the method '" + createMethodName + "' on " + parentSBase.getClass().getSimpleName()));
                this.logger.debug((Object)e.getMessage());
            }
        }
        return null;
    }
}

