/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.ext.fbc.ListOfObjectives;
import org.sbml.jsbml.ext.fbc.Objective;
import org.sbml.jsbml.xml.XMLNode;

public class FBCModelPlugin
extends AbstractSBasePlugin {
    private static final long serialVersionUID = -7451190347195219863L;
    private ListOf<FluxBound> listOfFluxBounds;
    private ListOfObjectives listOfObjectives;

    public String getElementNamespace() {
        return FBCConstants.getNamespaceURI(this.getLevel(), this.getVersion());
    }

    public String getPackageName() {
        return "Flux Balance Constraints";
    }

    public String getPrefix() {
        return "fbc";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    public Model getParent() {
        if (this.isSetExtendedSBase()) {
            return (Model)this.getExtendedSBase();
        }
        return null;
    }

    public Model getParentSBMLObject() {
        return this.getParent();
    }

    public FBCModelPlugin(FBCModelPlugin obj) {
        super((AbstractSBasePlugin)obj);
        if (obj.isSetListOfFluxBounds()) {
            this.setListOfFluxBounds((ListOf<FluxBound>)obj.getListOfFluxBounds().clone());
        }
        if (obj.isSetListOfObjectives()) {
            this.setListOfObjectives((ListOfObjectives)obj.getListOfObjectives().clone());
        }
    }

    public FBCModelPlugin(Model model) {
        super((SBase)model);
    }

    public boolean addFluxBound(FluxBound fluxBound) {
        return this.getListOfFluxBounds().add((SBase)fluxBound);
    }

    public boolean addObjective(Objective objective) {
        return this.getListOfObjectives().add((SBase)objective);
    }

    public FBCModelPlugin clone() {
        return new FBCModelPlugin(this);
    }

    public FluxBound createFluxBound() {
        return this.createFluxBound(null);
    }

    public FluxBound createFluxBound(String id) {
        FluxBound fluxBound = new FluxBound(id);
        this.addFluxBound(fluxBound);
        return fluxBound;
    }

    public Objective createObjective() {
        return this.createObjective(null);
    }

    public Objective createObjective(String id) {
        Objective objective = new Objective(id);
        this.addObjective(objective);
        return objective;
    }

    public String getActiveObjective() {
        return this.isSetListOfObjectives() ? this.listOfObjectives.getActiveObjective() : "";
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int pos = 0;
        if (this.isSetListOfFluxBounds()) {
            if (pos == index) {
                return this.getListOfFluxBounds();
            }
            ++pos;
        }
        if (this.isSetListOfObjectives()) {
            if (pos == index) {
                return this.getListOfObjectives();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfFluxBounds()) {
            ++count;
        }
        if (this.isSetListOfObjectives()) {
            ++count;
        }
        return count;
    }

    public FluxBound getFluxBound(int i) {
        return (FluxBound)this.getListOfFluxBounds().get(i);
    }

    public int getFluxBoundCount() {
        if (this.isSetListOfFluxBounds()) {
            return this.listOfFluxBounds.size();
        }
        return 0;
    }

    public ListOf<FluxBound> getListOfFluxBounds() {
        if (!this.isSetListOfFluxBounds()) {
            this.listOfFluxBounds = new ListOf();
            this.listOfFluxBounds.setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version1");
            this.listOfFluxBounds.setSBaseListType(ListOf.Type.other);
            if (this.isSetExtendedSBase()) {
                this.extendedSBase.registerChild(this.listOfFluxBounds);
            }
        }
        return this.listOfFluxBounds;
    }

    public ListOfObjectives getListOfObjectives() {
        if (!this.isSetListOfObjectives()) {
            this.listOfObjectives = new ListOfObjectives();
            this.listOfObjectives.setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version1");
            this.listOfObjectives.setSBaseListType(ListOf.Type.other);
            if (this.isSetExtendedSBase()) {
                this.extendedSBase.registerChild((SBase)this.listOfObjectives);
            }
        }
        return this.listOfObjectives;
    }

    public Objective getObjective(int i) {
        return (Objective)this.getListOfObjectives().get(i);
    }

    public int getObjectiveCount() {
        if (this.isSetListOfObjectives()) {
            return this.listOfObjectives.size();
        }
        return 0;
    }

    public int getNumFluxBound() {
        return this.getFluxBoundCount();
    }

    public int getNumObjective() {
        return this.getObjectiveCount();
    }

    public boolean isSetListOfFluxBounds() {
        return this.listOfFluxBounds != null && !this.listOfFluxBounds.isEmpty();
    }

    public boolean isSetListOfObjectives() {
        return this.listOfObjectives != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public boolean removeFluxBound(FluxBound fluxBound) {
        if (this.isSetListOfFluxBounds()) {
            return this.getListOfFluxBounds().remove((NamedSBase)fluxBound);
        }
        return false;
    }

    public void removeFluxBound(int i) {
        if (!this.isSetListOfFluxBounds()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfFluxBounds().remove(i);
    }

    public void removeObjective(int i) {
        if (!this.isSetListOfObjectives()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfObjectives().remove(i);
    }

    public boolean removeObjective(Objective objective) {
        if (this.isSetListOfObjectives()) {
            return this.getListOfObjectives().remove((NamedSBase)objective);
        }
        return false;
    }

    public void setActiveObjective(String activeObjective) {
        this.getListOfObjectives().setActiveObjective(activeObjective);
    }

    public void setActiveObjective(Objective objective) {
        this.setActiveObjective(objective.getId());
    }

    public void setListOfFluxBounds(ListOf<FluxBound> listOfFluxBounds) {
        this.unsetListOfFluxBounds();
        this.listOfFluxBounds = listOfFluxBounds;
        if (this.isSetExtendedSBase()) {
            this.extendedSBase.registerChild(this.listOfFluxBounds);
        }
    }

    public void setListOfObjectives(ListOfObjectives listOfObjectives) {
        this.unsetListOfObjectives();
        this.listOfObjectives = listOfObjectives;
        if (this.isSetExtendedSBase()) {
            this.extendedSBase.registerChild((SBase)this.listOfObjectives);
        }
    }

    public void setListOfObjectives(ListOf<Objective> listOfObjectives) {
        if (listOfObjectives instanceof ListOfObjectives) {
            this.setListOfObjectives((ListOfObjectives)listOfObjectives);
        } else {
            this.setListOfObjectives(new ListOfObjectives(listOfObjectives));
        }
    }

    public boolean unsetListOfFluxBounds() {
        if (this.isSetListOfFluxBounds()) {
            ListOf<FluxBound> oldFluxBounds = this.listOfFluxBounds;
            this.listOfFluxBounds = null;
            oldFluxBounds.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfObjectives() {
        if (this.isSetListOfObjectives()) {
            ListOfObjectives oldObjectives = this.listOfObjectives;
            this.listOfObjectives = null;
            oldObjectives.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        return null;
    }

    public void setNotesKeyToUserObject(String key) {
        Model model = this.getParent();
        ListOf rxns = model.getListOfReactions();
        for (Reaction r : rxns) {
            String val = this.recurseAndFind(r.getNotes(), key);
            if (val == null) continue;
            r.putUserObject((Object)key, (Object)val);
        }
    }

    private String recurseAndFind(XMLNode xmlNode, String key) {
        if (xmlNode.getChildCount() == 0) {
            if (xmlNode.getCharacters().startsWith(key)) {
                return xmlNode.getCharacters().replace(key, "").trim();
            }
        } else {
            for (int i = 0; i < xmlNode.getChildCount(); ++i) {
                String potential = this.recurseAndFind(xmlNode.getChildAt(i), key);
                if (potential == null) continue;
                return potential;
            }
        }
        return null;
    }
}

