/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.util.StringTools;

public class FBCSpeciesPlugin
extends AbstractSBasePlugin {
    private static final long serialVersionUID = 923773407400143272L;
    private int charge;
    private String chemicalFormula;
    private boolean isSetCharge;

    public String getElementNamespace() {
        return FBCConstants.getNamespaceURI(this.getLevel(), this.getVersion());
    }

    public String getPackageName() {
        return "Flux Balance Constraints";
    }

    public String getPrefix() {
        return "fbc";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    public ListOf<Species> getParent() {
        if (this.isSetExtendedSBase()) {
            return (ListOf)this.getExtendedSBase().getParent();
        }
        return null;
    }

    public ListOf<Species> getParentSBMLObject() {
        return this.getParent();
    }

    public FBCSpeciesPlugin(FBCSpeciesPlugin obj) {
        super((AbstractSBasePlugin)obj);
        if (obj.isSetChemicalFormula()) {
            this.setChemicalFormula(new String(obj.getChemicalFormula()));
        }
        if (obj.isSetCharge()) {
            this.setCharge(obj.getCharge());
        }
    }

    public FBCSpeciesPlugin(Species species) {
        super((SBase)species);
        if (species == null) {
            throw new IllegalArgumentException("The value of the species argument must not be null.");
        }
        this.initDefaults();
    }

    public FBCSpeciesPlugin clone() {
        return new FBCSpeciesPlugin(this);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getCharge() {
        if (this.isSetCharge()) {
            return this.charge;
        }
        throw new PropertyUndefinedError("charge", (SBasePlugin)this);
    }

    public String getChemicalFormula() {
        if (this.isSetChemicalFormula()) {
            return this.chemicalFormula;
        }
        return null;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        return 0;
    }

    public void initDefaults() {
    }

    public boolean isSetCharge() {
        return this.isSetCharge;
    }

    public boolean isSetChemicalFormula() {
        return this.chemicalFormula != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        if (attributeName.equals("charge")) {
            this.setCharge(StringTools.parseSBMLInt((String)value));
            return true;
        }
        if (attributeName.equals("chemicalFormula")) {
            this.setChemicalFormula(value);
            return true;
        }
        return false;
    }

    public void setCharge(int charge) {
        int oldCharge = this.charge;
        this.charge = charge;
        this.isSetCharge = true;
        this.firePropertyChange("charge", oldCharge, this.charge);
    }

    public void setChemicalFormula(String chemicalFormula) {
        String oldChemicalFormula = this.chemicalFormula;
        this.chemicalFormula = chemicalFormula;
        this.firePropertyChange("chemicalFormula", oldChemicalFormula, this.chemicalFormula);
    }

    public boolean unsetCharge() {
        if (this.isSetCharge()) {
            int oldCharge = this.charge;
            this.charge = 0;
            this.isSetCharge = false;
            this.firePropertyChange("charge", oldCharge, this.charge);
            return true;
        }
        return false;
    }

    public boolean unsetChemicalFormula() {
        if (this.isSetChemicalFormula()) {
            String oldChemicalFormula = this.chemicalFormula;
            this.chemicalFormula = null;
            this.firePropertyChange("chemicalFormula", oldChemicalFormula, this.chemicalFormula);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this.isSetCharge) {
            attributes.put("fbc:charge", Integer.toString(this.getCharge()));
        }
        if (this.isSetChemicalFormula()) {
            attributes.put("fbc:chemicalFormula", this.getChemicalFormula());
        }
        return attributes;
    }
}

