/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBMLWriter;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCList;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCSpeciesPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.ext.fbc.FluxObjective;
import org.sbml.jsbml.ext.fbc.ListOfObjectives;
import org.sbml.jsbml.ext.fbc.Objective;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class FBCParser
extends AbstractReaderWriter
implements PackageParser {
    private FBCList groupList = FBCList.none;
    private Logger logger = Logger.getLogger(FBCParser.class);

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/fbc/version1";
    }

    public String getShortLabel() {
        return "fbc";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getListOfSBMLElementsToWrite: " + sbase.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (sbase instanceof SBase && ((SBase)sbase).getExtension(this.getNamespaceURI()) != null) {
            SBasePlugin sbasePlugin = ((SBase)sbase).getExtension(this.getNamespaceURI());
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)sbasePlugin);
            this.logger.debug((Object)("getListOfSBMLElementsToWrite: nb children = " + sbasePlugin.getChildCount()));
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(sbase);
        }
        return listOfElementsToWrite;
    }

    public void processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        this.logger.debug((Object)("processAttribute -> " + prefix + ":" + attributeName + " = " + value + " (" + contextObject.getClass().getName() + ")"));
        if (contextObject instanceof Species) {
            Species species = (Species)contextObject;
            FBCSpeciesPlugin fbcSpecies = null;
            if (species.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1") != null) {
                fbcSpecies = (FBCSpeciesPlugin)species.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1");
            } else {
                fbcSpecies = new FBCSpeciesPlugin(species);
                species.addExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1", (SBasePlugin)fbcSpecies);
            }
            contextObject = fbcSpecies;
        }
        super.processAttribute(elementName, attributeName, value, uri, prefix, isLastAttribute, contextObject);
    }

    public boolean processEndElement(String elementName, String prefix, boolean isNested, Object contextObject) {
        if (elementName.equals(FBCList.listOfFluxBounds.name()) || elementName.equals(FBCList.listOfObjectives.name())) {
            this.groupList = FBCList.none;
        } else if (elementName.equals(FBCList.listOfFluxObjectives.name())) {
            this.groupList = FBCList.listOfObjectives;
        }
        return true;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            FBCModelPlugin fbcModel = null;
            if (model.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1") != null) {
                fbcModel = (FBCModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1");
            } else {
                fbcModel = new FBCModelPlugin(model);
                model.addExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1", (SBasePlugin)fbcModel);
            }
            if (elementName.equals(FBCList.listOfFluxBounds.name())) {
                ListOf<FluxBound> listOfFluxBounds = fbcModel.getListOfFluxBounds();
                this.groupList = FBCList.listOfFluxBounds;
                return listOfFluxBounds;
            }
            if (elementName.equals(FBCList.listOfObjectives.name())) {
                ListOfObjectives listOfObjectives = fbcModel.getListOfObjectives();
                this.groupList = FBCList.listOfObjectives;
                return listOfObjectives;
            }
        } else if (contextObject instanceof Objective) {
            Objective objective = (Objective)((Object)contextObject);
            if (elementName.equals("listOfFluxObjectives") || elementName.equals("listOfFluxes")) {
                ListOf<FluxObjective> listOfFluxObjectives = objective.getListOfFluxObjectives();
                this.groupList = FBCList.listOfFluxObjectives;
                return listOfFluxObjectives;
            }
        } else if (contextObject instanceof ListOf) {
            ListOf listOf = (ListOf)contextObject;
            if (elementName.equals("fluxBound") && this.groupList.equals((Object)FBCList.listOfFluxBounds)) {
                Model model = (Model)listOf.getParentSBMLObject();
                FBCModelPlugin extendeModel = (FBCModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1");
                FluxBound fluxBound = new FluxBound();
                extendeModel.addFluxBound(fluxBound);
                return fluxBound;
            }
            if (elementName.equals("objective") && this.groupList.equals((Object)FBCList.listOfObjectives)) {
                Model model = (Model)listOf.getParentSBMLObject();
                FBCModelPlugin extendeModel = (FBCModelPlugin)model.getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1");
                Objective objective = new Objective();
                extendeModel.addObjective(objective);
                return objective;
            }
            if (elementName.equals("fluxObjective") && this.groupList.equals((Object)FBCList.listOfFluxObjectives)) {
                Objective objective = (Objective)listOf.getParentSBMLObject();
                FluxObjective fluxObjective = new FluxObjective();
                objective.addFluxObjective(fluxObjective);
                return fluxObjective;
            }
        }
        return contextObject;
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        this.logger.debug((Object)"FBCParser: writeElement");
        if (sbmlElementToWrite instanceof SBase) {
            SBase sbase = (SBase)sbmlElementToWrite;
            if (!xmlObject.isSetName()) {
                if (sbase instanceof ListOf) {
                    ListOf listOf = (ListOf)sbase;
                    if (listOf.size() > 0) {
                        if (listOf.get(0) instanceof FluxBound) {
                            xmlObject.setName(FBCList.listOfFluxBounds.toString());
                        } else if (listOf.get(0) instanceof Objective) {
                            xmlObject.setName(FBCList.listOfObjectives.toString());
                        } else if (listOf.get(0) instanceof FluxObjective) {
                            xmlObject.setName(FBCList.listOfFluxObjectives.toString());
                        }
                    }
                } else {
                    xmlObject.setName(sbase.getElementName());
                }
            }
        }
    }

    public static void main(String[] args) throws SBMLException {
        if (args.length < 1) {
            System.out.println("Usage: java org.sbml.jsbml.xml.stax.SBMLWriter sbmlFileName");
            System.exit(0);
        }
        File argsAsFile = new File(args[0]);
        File[] files = null;
        files = argsAsFile.isDirectory() ? argsAsFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().contains("-jsbml")) {
                    return false;
                }
                return pathname.getName().endsWith(".xml");
            }
        }) : new File[]{argsAsFile};
        for (File file : files) {
            long init = Calendar.getInstance().getTimeInMillis();
            System.out.println(Calendar.getInstance().getTime());
            String fileName = file.getAbsolutePath();
            String jsbmlWriteFileName = fileName.replaceFirst(".xml", "-jsbml.xml");
            System.out.printf("Reading %s and writing %s\n", fileName, jsbmlWriteFileName);
            long afterRead = 0L;
            try {
                SBMLDocument testDocument = new SBMLReader().readSBMLFromFile(fileName);
                System.out.printf("Reading done\n", new Object[0]);
                System.out.println(Calendar.getInstance().getTime());
                afterRead = Calendar.getInstance().getTimeInMillis();
                FBCModelPlugin fbcModel = (FBCModelPlugin)testDocument.getModel().getExtension("http://www.sbml.org/sbml/level3/version1/fbc/version1");
                if (fbcModel != null) {
                    System.out.println("nb fluxBounds found: " + fbcModel.getListOfFluxBounds().size());
                    System.out.println("nb objectives found: " + fbcModel.getListOfObjectives().size());
                    System.out.println("nb fluxObjectives found: " + fbcModel.getObjective(0).getListOfFluxObjectives().size());
                    System.out.println("Active objective: " + fbcModel.getActiveObjective());
                    System.out.println("Active objective: " + fbcModel.getListOfObjectives().getActiveObjective());
                } else {
                    System.out.println("!!!!!!!!!! not FBC model plugin defined !!!!!!!!!!!!");
                }
                System.out.printf("Starting writing\n", new Object[0]);
                new SBMLWriter().write(testDocument.clone(), jsbmlWriteFileName);
            }
            catch (XMLStreamException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println(Calendar.getInstance().getTime());
            long end = Calendar.getInstance().getTimeInMillis();
            long nbSecondes = (end - init) / 1000L;
            long nbSecondesRead = (afterRead - init) / 1000L;
            long nbSecondesWrite = (end - afterRead) / 1000L;
            if (nbSecondes > 120L) {
                System.out.println("It took " + nbSecondes / 60L + " minutes.");
            } else {
                System.out.println("It took " + nbSecondes + " secondes.");
            }
            System.out.println("Reading: " + nbSecondesRead + " secondes.");
            System.out.println("Writing: " + nbSecondesWrite + " secondes.");
        }
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/fbc/version1";
        }
        return null;
    }

    public List<String> getNamespaces() {
        return FBCConstants.namespaces;
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "fbc";
    }

    public boolean isRequired() {
        return false;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null) {
            if (sbase instanceof Model) {
                return new FBCModelPlugin((Model)sbase);
            }
            if (sbase instanceof Species) {
                return new FBCSpeciesPlugin((Species)sbase);
            }
        }
        return null;
    }
}

