/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.util.Locale;
import java.util.Map;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FluxObjective
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = 246449689493121713L;
    private double coefficient;
    private boolean isSetCoefficient = false;
    private String reaction;

    public FluxObjective() {
        this.initDefaults();
    }

    public FluxObjective(int level, int version) {
        this(null, null, level, version);
    }

    public FluxObjective(String id) {
        super(id);
        this.initDefaults();
    }

    public FluxObjective(String id, int level, int version) {
        this(id, null, level, version);
    }

    public FluxObjective(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public FluxObjective(FluxObjective obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetReaction()) {
            this.setReaction(obj.getReaction());
        }
        if (obj.isSetCoefficient()) {
            this.setCoefficient(obj.getCoefficient());
        }
    }

    public FluxObjective clone() {
        return new FluxObjective(this);
    }

    public int hashCode() {
        int prime = 2203;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.coefficient);
        result = 2203 * result + (int)(temp ^ temp >>> 32);
        result = 2203 * result + (this.reaction == null ? 0 : this.reaction.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FluxObjective other = (FluxObjective)((Object)obj);
        if (Double.doubleToLongBits(this.coefficient) != Double.doubleToLongBits(other.coefficient)) {
            return false;
        }
        return !(this.reaction == null ? other.reaction != null : !this.reaction.equals(other.reaction));
    }

    public double getCoefficient() {
        if (this.isSetCoefficient()) {
            return this.coefficient;
        }
        throw new PropertyUndefinedError("coefficient", (SBase)this);
    }

    public String getReaction() {
        return this.reaction;
    }

    public boolean isSetReaction() {
        return this.reaction != null;
    }

    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "fbc";
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isSetCoefficient() {
        return this.isSetCoefficient;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("reaction")) {
                this.setReaction(value);
            } else if (attributeName.equals("coefficient")) {
                this.setCoefficient(StringTools.parseSBMLDouble((String)value));
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public void setCoefficient(double coefficient) {
        double oldCoefficient = this.coefficient;
        this.coefficient = coefficient;
        this.isSetCoefficient = true;
        this.firePropertyChange("coefficient", oldCoefficient, this.coefficient);
    }

    public void setReaction(Reaction reaction) {
        this.setReaction(reaction.getId());
    }

    public void setReaction(String reaction) {
        this.reaction = reaction;
    }

    public boolean unsetCoefficient() {
        if (this.isSetCoefficient()) {
            double oldCoefficient = this.coefficient;
            this.coefficient = Double.NaN;
            this.isSetCoefficient = false;
            this.firePropertyChange("coefficient", oldCoefficient, this.coefficient);
            return true;
        }
        return false;
    }

    public boolean unsetReaction() {
        if (this.isSetReaction()) {
            String oldReaction = this.reaction;
            this.reaction = null;
            this.firePropertyChange("reaction", oldReaction, this.reaction);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetReaction()) {
            attributes.put("fbc:reaction", this.getReaction());
        }
        if (this.isSetCoefficient()) {
            attributes.put("fbc:coefficient", StringTools.toString((Locale)Locale.ENGLISH, (double)this.getCoefficient()));
        }
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("fbc:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("fbc:name", this.getName());
        }
        return attributes;
    }
}

