/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.fbc.And;
import org.sbml.jsbml.ext.fbc.Association;
import org.sbml.jsbml.ext.fbc.GeneProductRef;
import org.sbml.jsbml.ext.fbc.Or;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LogicalOperator
extends AbstractSBase
implements Association {
    private static final long serialVersionUID = 7724258767809732147L;
    private List<Association> listOfAssociations;

    public LogicalOperator() {
        this.initDefaults();
    }

    public LogicalOperator(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public LogicalOperator(LogicalOperator association) {
        super((SBase)association);
        if (association.isSetListOfAssociations()) {
            for (Association childAssociation : association.getListOfAssociations()) {
                this.addAssociation((Association)childAssociation.clone());
            }
        }
    }

    public void addAllAssociations(List<Association> listOfAssociations) {
        for (Association association : listOfAssociations) {
            this.addAssociation(association);
        }
    }

    public boolean addAssociation(Association association) {
        this.registerChild(association);
        return this.getListOfAssociations().add(association);
    }

    public void addChild(Association child) {
        this.addAssociation(child);
    }

    public abstract LogicalOperator clone();

    public And createAnd() {
        And association = new And(this.getLevel(), this.getVersion());
        this.addAssociation(association);
        return association;
    }

    public GeneProductRef createGeneProductRef() {
        return this.createGeneProductRef(null);
    }

    public GeneProductRef createGeneProductRef(String id) {
        GeneProductRef association = new GeneProductRef(id, this.getLevel(), this.getVersion());
        this.addAssociation(association);
        return association;
    }

    public Or createOr() {
        Or association = new Or(this.getLevel(), this.getVersion());
        this.addAssociation(association);
        return association;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public Association getAssociation(int i) {
        if (!this.isSetListOfAssociations()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return this.getListOfAssociations().get(i);
    }

    public int getAssociationCount() {
        return this.isSetListOfAssociations() ? this.getListOfAssociations().size() : 0;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfAssociations()) {
            return (TreeNode)((Object)this.getListOfAssociations().get(index));
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfAssociations()) {
            count += this.listOfAssociations.size();
        }
        return count;
    }

    public List<Association> getListOfAssociations() {
        if (this.listOfAssociations == null) {
            this.listOfAssociations = new ArrayList<Association>();
        }
        return this.listOfAssociations;
    }

    public int getNumAssociations() {
        return this.getAssociationCount();
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "fbc";
    }

    public boolean isSetListOfAssociations() {
        return this.listOfAssociations != null && !this.listOfAssociations.isEmpty();
    }

    public boolean removeAllAssociations() {
        if (this.isSetListOfAssociations()) {
            for (int i = this.listOfAssociations.size() - 1; i >= 0; --i) {
                this.removeAssociation(i);
            }
            return true;
        }
        return false;
    }

    public boolean removeAssociation(Association association) {
        if (this.isSetListOfAssociations()) {
            return this.getListOfAssociations().remove(association);
        }
        return false;
    }

    public Association removeAssociation(int i) {
        if (!this.isSetListOfAssociations()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        Association element = this.getListOfAssociations().remove(i);
        element.fireNodeRemovedEvent();
        return element;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [");
        if (this.isSetMetaId()) {
            builder.append("metaid=");
            builder.append(this.getMetaId());
        }
        builder.append("]");
        return builder.toString();
    }
}

