/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.LevelVersionError;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.fbc.FluxObjective;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Objective
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -3466570440778373634L;
    private ListOf<FluxObjective> listOfFluxObjectives;
    private Type type;

    public Objective() {
        this.initDefaults();
    }

    public Objective(int level, int version) {
        this(null, null, level, version);
    }

    public Objective(Objective obj) {
        super((AbstractNamedSBase)obj);
        if (obj.isSetListOfFluxObjectives()) {
            this.setListOfFluxObjectives((ListOf<FluxObjective>)obj.getListOfFluxObjectives().clone());
        }
        if (obj.isSetType()) {
            this.setType(obj.getType());
        }
    }

    public Objective(String id) {
        super(id);
        this.initDefaults();
    }

    public Objective(String id, int level, int version) {
        this(id, null, level, version);
    }

    public Objective(String id, String name, int level, int version) {
        super(id, name, level, version);
        if (this.getLevelAndVersion().compareTo((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(1)) < 0) {
            throw new LevelVersionError(this.getElementName(), level, version);
        }
        this.initDefaults();
    }

    public boolean addFluxObjective(FluxObjective fluxObjective) {
        return this.getListOfFluxObjectives().add((SBase)fluxObjective);
    }

    public Objective clone() {
        return new Objective(this);
    }

    public FluxObjective createFluxObjective() {
        return this.createFluxObjective(null);
    }

    public FluxObjective createFluxObjective(String id) {
        return this.createFluxObjective(id, null);
    }

    public FluxObjective createFluxObjective(String id, String name) {
        FluxObjective fluxObjective = new FluxObjective(id, name, this.getLevel(), this.getVersion());
        this.getListOfFluxObjectives().add((SBase)fluxObjective);
        return fluxObjective;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Objective other = (Objective)((Object)obj);
        if (this.listOfFluxObjectives == null ? other.listOfFluxObjectives != null : !this.listOfFluxObjectives.equals(other.listOfFluxObjectives)) {
            return false;
        }
        return this.type == other.type;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfFluxObjectives()) {
            if (pos == index) {
                return this.listOfFluxObjectives;
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        return this.isSetListOfFluxObjectives() ? 1 : 0;
    }

    public int getFluxObjectiveCount() {
        return this.listOfFluxObjectives == null ? 0 : this.listOfFluxObjectives.size();
    }

    public ListOf<FluxObjective> getListOfFluxObjectives() {
        if (!this.isSetListOfFluxObjectives()) {
            this.listOfFluxObjectives = new ListOf(this.getLevel(), this.getVersion());
            this.listOfFluxObjectives.setPackageVersion(-1);
            this.listOfFluxObjectives.setPackageName(null);
            this.listOfFluxObjectives.setPackageName("fbc");
            this.listOfFluxObjectives.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfFluxObjectives);
        }
        return this.listOfFluxObjectives;
    }

    @Deprecated
    public int getNumFluxObjectives() {
        return this.getFluxObjectiveCount();
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 2383;
        int result = super.hashCode();
        result = 2383 * result + (this.listOfFluxObjectives == null ? 0 : this.listOfFluxObjectives.hashCode());
        result = 2383 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "fbc";
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isSetListOfFluxObjectives() {
        return this.listOfFluxObjectives != null && this.listOfFluxObjectives.size() > 0;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("type")) {
                this.setType(value);
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }

    public boolean removeFluxObjective(FluxObjective fluxObjective) {
        if (this.isSetListOfFluxObjectives()) {
            return this.getListOfFluxObjectives().remove((NamedSBase)fluxObjective);
        }
        return false;
    }

    public void removeFluxObjective(int i) {
        if (!this.isSetListOfFluxObjectives()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfFluxObjectives().remove(i);
    }

    public void removeFluxObjective(String id) {
        this.getListOfFluxObjectives().removeFirst((Filter)new NameFilter(id));
    }

    public void setListOfFluxObjectives(ListOf<FluxObjective> listOfFluxObjectives) {
        this.unsetListOfFluxObjectives();
        this.listOfFluxObjectives = listOfFluxObjectives;
        if (listOfFluxObjectives != null) {
            listOfFluxObjectives.setPackageVersion(-1);
            listOfFluxObjectives.setPackageName(null);
            listOfFluxObjectives.setPackageName("fbc");
            this.registerChild((SBase)this.listOfFluxObjectives);
        }
    }

    public void setType(String type) {
        try {
            this.setType(Type.fromString(type));
        }
        catch (Exception e) {
            throw new SBMLException("Could not recognized the value '" + type + "' for the attribute " + "type" + " on the 'objective' element.");
        }
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.firePropertyChange("type", (Object)oldType, (Object)this.type);
    }

    public boolean unsetListOfFluxObjectives() {
        if (this.isSetListOfFluxObjectives()) {
            ListOf<FluxObjective> oldFluxObjectives = this.listOfFluxObjectives;
            this.listOfFluxObjectives = null;
            oldFluxObjectives.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetType() {
        if (this.isSetType()) {
            Type oldType = this.type;
            this.type = null;
            this.firePropertyChange("type", (Object)oldType, (Object)this.type);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.type != null) {
            attributes.put("fbc:type", this.getType().toString());
        }
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("fbc:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("fbc:name", this.getName());
        }
        return attributes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        MAXIMIZE("maximize"),
        MINIMIZE("minimize");

        private String sbmlName;

        public static Type fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            for (Type v : Type.values()) {
                if (!value.equalsIgnoreCase(v.sbmlName)) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }

        private Type(String name) {
            this.sbmlName = name;
        }

        public String toString() {
            return this.sbmlName;
        }
    }
}

