/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc;

import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.fbc.AbstractFBCSBasePlugin;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;

public class FBCSpeciesPlugin
extends AbstractFBCSBasePlugin {
    private static final transient Logger logger = Logger.getLogger(FBCSpeciesPlugin.class);
    private static final long serialVersionUID = 923773407400143272L;
    private int charge;
    private String chemicalFormula;
    private boolean isSetCharge;

    public ListOf<Species> getParent() {
        if (this.isSetExtendedSBase()) {
            return (ListOf)this.getExtendedSBase().getParent();
        }
        return null;
    }

    public ListOf<Species> getParentSBMLObject() {
        return this.getParent();
    }

    public FBCSpeciesPlugin(FBCSpeciesPlugin obj) {
        super(obj);
        if (obj.isSetChemicalFormula()) {
            this.setChemicalFormula(new String(obj.getChemicalFormula()));
        }
        if (obj.isSetCharge()) {
            this.setCharge(obj.getCharge());
        }
    }

    public FBCSpeciesPlugin(Species species) {
        super((SBase)species);
        if (species == null) {
            throw new IllegalArgumentException("The value of the species argument must not be null.");
        }
        this.initDefaults();
    }

    public FBCSpeciesPlugin clone() {
        return new FBCSpeciesPlugin(this);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public int getCharge() {
        if (this.isSetCharge()) {
            return this.charge;
        }
        throw new PropertyUndefinedError("charge", (SBasePlugin)this);
    }

    public String getChemicalFormula() {
        if (this.isSetChemicalFormula()) {
            return this.chemicalFormula;
        }
        return null;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int pos = 0;
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        return 0;
    }

    public void initDefaults() {
    }

    public boolean isSetCharge() {
        return this.isSetCharge;
    }

    public boolean isSetChemicalFormula() {
        return this.chemicalFormula != null && this.chemicalFormula.length() > 0;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        if (attributeName.equals("charge")) {
            this.setCharge(StringTools.parseSBMLInt((String)value));
            return true;
        }
        if (attributeName.equals("chemicalFormula")) {
            try {
                this.setChemicalFormula(value);
            }
            catch (IllegalArgumentException exc) {
                logger.error((Object)("Skipped invalid chemical formula: " + value));
                AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)((Object)this));
            }
            return true;
        }
        return false;
    }

    public void setCharge(int charge) {
        int oldCharge = this.charge;
        this.charge = charge;
        this.isSetCharge = true;
        this.firePropertyChange("charge", oldCharge, this.charge);
    }

    public void setChemicalFormula(String chemicalFormula) {
        if (chemicalFormula != null && !this.isReadingInProgress() && !SyntaxChecker.isValidChemicalFormula((String)chemicalFormula)) {
            throw new IllegalArgumentException(chemicalFormula);
        }
        String oldChemicalFormula = this.chemicalFormula;
        this.chemicalFormula = chemicalFormula;
        this.firePropertyChange("chemicalFormula", oldChemicalFormula, this.chemicalFormula);
    }

    public boolean unsetCharge() {
        if (this.isSetCharge()) {
            int oldCharge = this.charge;
            this.charge = 0;
            this.isSetCharge = false;
            this.firePropertyChange("charge", oldCharge, this.charge);
            return true;
        }
        return false;
    }

    public boolean unsetChemicalFormula() {
        if (this.isSetChemicalFormula()) {
            String oldChemicalFormula = this.chemicalFormula;
            this.chemicalFormula = null;
            this.firePropertyChange("chemicalFormula", oldChemicalFormula, this.chemicalFormula);
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        TreeMap<String, String> attributes = new TreeMap<String, String>();
        if (this.isSetCharge) {
            attributes.put("fbc:charge", Integer.toString(this.getCharge()));
        }
        if (this.isSetChemicalFormula()) {
            attributes.put("fbc:chemicalFormula", this.getChemicalFormula());
        }
        return attributes;
    }
}

