/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBMLReader;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.TidySBMLWriter;
import org.sbml.jsbml.Unit;
import org.sbml.jsbml.UnitDefinition;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCSpeciesPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.util.CobraUtil;
import org.sbml.jsbml.util.SBMLtools;
import org.sbml.jsbml.util.converters.SBMLConverter;

public class CobraToFbcV1Converter
implements SBMLConverter {
    public SBMLDocument convert(SBMLDocument sbmlDocument) throws SBMLException {
        Properties pElementsNote = new Properties();
        Model model = sbmlDocument.getModel();
        if (sbmlDocument.getLevel() < 3) {
            SBMLtools.setLevelAndVersion((SBase)sbmlDocument, (int)3, (int)1);
            FBCConstants fbcConstants = new FBCConstants();
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 1));
            if (!model.isSetSubstanceUnits()) {
                model.setSubstanceUnits("substance");
            }
            if (!model.isSetTimeUnits()) {
                model.setTimeUnits("second");
            }
            if (!model.isSetVolumeUnits()) {
                model.setVolumeUnits("volume");
            }
            if (!model.isSetAreaUnits()) {
                model.setAreaUnits("area");
            }
            if (!model.isSetLengthUnits()) {
                model.setLengthUnits("metre");
            }
            if (!model.isSetExtentUnits()) {
                model.setExtentUnits("substance");
            }
            if (model.getUnitDefinitionById("substance") == null) {
                UnitDefinition unitDefinitionSub = new UnitDefinition("substance");
                model.addUnitDefinition(unitDefinitionSub);
                unitDefinitionSub.createUnit(Unit.Kind.MOLE);
            }
            if (model.getUnitDefinitionById("volume") == null) {
                UnitDefinition unitDefinitionVol = new UnitDefinition("volume");
                model.addUnitDefinition(unitDefinitionVol);
                unitDefinitionVol.createUnit(Unit.Kind.LITRE);
            }
            if (model.getUnitDefinitionById("area") == null) {
                Iterator unitDefinitionAre = new UnitDefinition("area");
                model.addUnitDefinition((UnitDefinition)unitDefinitionAre);
                unitDefinitionAre.createUnit(Unit.Kind.METRE);
                unitDefinitionAre.getUnit(0).setExponent(2);
            }
            for (Species species : model.getListOfSpecies()) {
                if (!species.isSetHasOnlySubstanceUnits()) {
                    species.setHasOnlySubstanceUnits(false);
                }
                if (!species.isSetBoundaryCondition()) {
                    species.setBoundaryCondition(false);
                }
                if (!species.isSetConstant()) {
                    species.setConstant(false);
                }
                if (!species.isSetSubstanceUnits()) {
                    species.setSubstanceUnits("substance");
                }
                pElementsNote = CobraUtil.parseCobraNotes((SBase)species);
                FBCSpeciesPlugin fbcSpeciesPlugin = (FBCSpeciesPlugin)species.getPlugin("fbc");
                if (pElementsNote.getProperty("FORMULA") != null) {
                    fbcSpeciesPlugin.setChemicalFormula(pElementsNote.getProperty("FORMULA"));
                }
                if (species.isSetCharge()) {
                    fbcSpeciesPlugin.setCharge(species.getCharge());
                    species.unsetCharge();
                    continue;
                }
                if (pElementsNote.getProperty("CHARGE") == null) continue;
                fbcSpeciesPlugin.setCharge(Integer.parseInt(pElementsNote.getProperty("CHARGE")));
            }
            FBCModelPlugin fbcModelPlugin = (FBCModelPlugin)model.getPlugin("fbc");
            for (Reaction reaction : model.getListOfReactions()) {
                if (!reaction.isSetReversible()) {
                    reaction.setReversible(true);
                }
                if (!reaction.isSetFast()) {
                    reaction.setFast(false);
                }
                if (reaction.getKineticLaw().getParameter("LOWER_BOUND").isSetValue()) {
                    FluxBound fluxBoundLo = new FluxBound();
                    fluxBoundLo.setReaction(reaction.getId());
                    fluxBoundLo.setOperation(FluxBound.Operation.GREATER_EQUAL);
                    fluxBoundLo.setValue(reaction.getKineticLaw().getParameter("LOWER_BOUND").getValue());
                    fbcModelPlugin.addFluxBound(fluxBoundLo);
                }
                if (reaction.getKineticLaw().getParameter("UPPER_BOUND").isSetValue()) {
                    FluxBound fluxBoundUp = new FluxBound();
                    fluxBoundUp.setReaction(reaction.getId());
                    fluxBoundUp.setOperation(FluxBound.Operation.LESS_EQUAL);
                    fluxBoundUp.setValue(reaction.getKineticLaw().getParameter("UPPER_BOUND").getValue());
                    fbcModelPlugin.addFluxBound(fluxBoundUp);
                }
                if (reaction.isSetKineticLaw()) {
                    reaction.unsetKineticLaw();
                }
                for (SpeciesReference speciesReference : reaction.getListOfProducts()) {
                    speciesReference.setConstant(true);
                }
                for (SpeciesReference speciesReference : reaction.getListOfReactants()) {
                    speciesReference.setConstant(true);
                }
            }
        }
        return sbmlDocument;
    }

    public static void main(String[] args) throws XMLStreamException, IOException {
        SBMLReader sbmlReader = new SBMLReader();
        SBMLDocument doc = sbmlReader.readSBMLFromFile(args[0]);
        CobraToFbcV1Converter cobraToFbcV1Converter = new CobraToFbcV1Converter();
        TidySBMLWriter tidySBMLWriter = new TidySBMLWriter();
        tidySBMLWriter.writeSBMLToFile(cobraToFbcV1Converter.convert(doc), args[1]);
    }
}

