/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.util.HashSet;
import java.util.Properties;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCSpeciesPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.util.CobraUtil;
import org.sbml.jsbml.util.SBMLtools;
import org.sbml.jsbml.util.converters.SBMLConverter;

public class FbcV1ToCobraConverter
implements SBMLConverter {
    public SBMLDocument convert(SBMLDocument sbmlDocument) throws SBMLException {
        if (sbmlDocument.isPackageEnabled(FBCConstants.getNamespaceURI(3, 1, 1))) {
            Model model = sbmlDocument.getModel();
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 1), false);
            SBMLtools.setLevelAndVersion((SBase)sbmlDocument, (int)2, (int)5);
            for (Species species : model.getListOfSpecies()) {
                Properties pElementsSpeciesNotes;
                if (!species.isSetPlugin("fbc")) continue;
                FBCSpeciesPlugin fbcSpeciesPlugin = (FBCSpeciesPlugin)species.getPlugin("fbc");
                if (fbcSpeciesPlugin.isSetChemicalFormula()) {
                    String chemicalFormula = fbcSpeciesPlugin.getChemicalFormula();
                    pElementsSpeciesNotes = new Properties();
                    pElementsSpeciesNotes = CobraUtil.parseCobraNotes((SBase)species);
                    if (pElementsSpeciesNotes.getProperty("FORMULA") != null) {
                        pElementsSpeciesNotes.remove("FORMULA");
                    }
                    pElementsSpeciesNotes.setProperty("FORMULA", chemicalFormula);
                    CobraUtil.writeCobraNotes((SBase)species, (Properties)pElementsSpeciesNotes);
                }
                if (fbcSpeciesPlugin.isSetCharge()) {
                    int charge = fbcSpeciesPlugin.getCharge();
                    pElementsSpeciesNotes = new Properties();
                    pElementsSpeciesNotes = CobraUtil.parseCobraNotes((SBase)species);
                    if (pElementsSpeciesNotes.getProperty("CHARGE") != null) {
                        pElementsSpeciesNotes.remove("CHARGE");
                    }
                    pElementsSpeciesNotes.setProperty("CHARGE", Integer.toString(charge));
                    CobraUtil.writeCobraNotes((SBase)species, (Properties)pElementsSpeciesNotes);
                }
                species.unsetPlugin("fbc");
            }
            FBCModelPlugin fbcModelPlugin = (FBCModelPlugin)model.getPlugin("fbc");
            HashSet<String> listOFBReactionIds = new HashSet<String>();
            for (FluxBound fluxBound : fbcModelPlugin.getListOfFluxBounds()) {
                listOFBReactionIds.add(fluxBound.getReaction());
            }
            for (Reaction reaction : model.getListOfReactions()) {
                if (listOFBReactionIds.contains(reaction.getId())) {
                    KineticLaw kineticLaw = new KineticLaw(reaction);
                    ASTNode astNode = new ASTNode("FLUX_VALUE");
                    kineticLaw.setMath(astNode);
                    for (FluxBound fluxBound : fbcModelPlugin.getListOfFluxBounds()) {
                        if (!fluxBound.getReaction().equals(reaction.getId())) continue;
                        if (fluxBound.getOperation().equals((Object)FluxBound.Operation.LESS_EQUAL)) {
                            reaction.getKineticLaw().createLocalParameter("UPPER_BOUND");
                            reaction.getKineticLaw().getLocalParameter("UPPER_BOUND").setValue(fluxBound.getValue());
                            reaction.getKineticLaw().getLocalParameter("UPPER_BOUND").setExplicitlyConstant(true);
                            reaction.getKineticLaw().getLocalParameter("UPPER_BOUND").setUnits("mmol_per_gDW_per_hr");
                        }
                        if (!fluxBound.getOperation().equals((Object)FluxBound.Operation.GREATER_EQUAL)) continue;
                        reaction.getKineticLaw().createLocalParameter("LOWER_BOUND");
                        reaction.getKineticLaw().getLocalParameter("LOWER_BOUND").setValue(fluxBound.getValue());
                        reaction.getKineticLaw().getLocalParameter("LOWER_BOUND").setExplicitlyConstant(true);
                        reaction.getKineticLaw().getLocalParameter("LOWER_BOUND").setUnits("mmol_per_gDW_per_hr");
                    }
                }
                for (SpeciesReference speciesReference : reaction.getListOfProducts()) {
                    speciesReference.unsetConstant();
                }
                for (SpeciesReference speciesReference : reaction.getListOfReactants()) {
                    speciesReference.unsetConstant();
                }
            }
            fbcModelPlugin.unsetListOfFluxBounds();
        }
        return sbmlDocument;
    }

    public void setOption(String name, String value) {
    }
}

