/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.fbc.And;
import org.sbml.jsbml.ext.fbc.Association;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCReactionPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.ext.fbc.GeneProduct;
import org.sbml.jsbml.ext.fbc.GeneProductRef;
import org.sbml.jsbml.ext.fbc.LogicalOperator;
import org.sbml.jsbml.ext.fbc.Or;
import org.sbml.jsbml.util.CobraUtil;
import org.sbml.jsbml.util.compilers.ConfigurableLogicalFormulaCompiler;
import org.sbml.jsbml.util.compilers.FormulaCompiler;
import org.sbml.jsbml.util.converters.SBMLConverter;
import org.sbml.jsbml.util.filters.Filter;

public class FbcV2ToFbcV1Converter
implements SBMLConverter {
    String userKey = null;

    public SBMLDocument convert(SBMLDocument sbmlDocument) throws SBMLException {
        Model model = sbmlDocument.getModel();
        FBCModelPlugin fbcModelPlugin = (FBCModelPlugin)model.getPlugin("fbc");
        if (sbmlDocument.isPackageEnabled(FBCConstants.getNamespaceURI(3, 1, 2)) && fbcModelPlugin.isSetStrict()) {
            FBCReactionPlugin fbcReactionPlugin;
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 2), false);
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 1));
            sbmlDocument.filter(new Filter(){

                public boolean accepts(Object o) {
                    SBasePlugin sBasePlugin;
                    SBase sBase;
                    if (o instanceof SBase && (sBase = (SBase)o).getNumPlugins() > 0 && (sBasePlugin = sBase.getPlugin("fbc")) != null) {
                        if (sBasePlugin.getPackageName().equals("fbc")) {
                            sBasePlugin.setPackageVersion(1);
                        }
                        if (!sBasePlugin.getElementNamespace().equals("http://www.sbml.org/sbml/level3/version1/fbc/version1")) {
                            ((AbstractSBasePlugin)sBasePlugin).setNamespace(null);
                            ((AbstractSBasePlugin)sBasePlugin).setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version1");
                        }
                    }
                    return false;
                }
            });
            sbmlDocument.filter(new Filter(){

                public boolean accepts(Object o) {
                    SBase sBase;
                    if (o instanceof SBase && (sBase = (SBase)o).getPackageName().equals("fbc")) {
                        if (sBase.getPackageVersion() != 1) {
                            sBase.setPackageVersion(1);
                        }
                        if (!sBase.getNamespace().equals("http://www.sbml.org/sbml/level3/version1/fbc/version1")) {
                            ((AbstractSBase)sBase).setNamespace(null);
                            ((AbstractSBase)sBase).setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version1");
                        }
                    }
                    return false;
                }
            });
            fbcModelPlugin.unsetStrict();
            for (Reaction reaction : model.getListOfReactions()) {
                fbcReactionPlugin = (FBCReactionPlugin)reaction.getPlugin("fbc");
                String lowerFluxBound = fbcReactionPlugin.getLowerFluxBound();
                String upperFluxBound = fbcReactionPlugin.getUpperFluxBound();
                HashSet<String> parametersToDelete = new HashSet<String>();
                for (Parameter parameter : model.getListOfParameters()) {
                    if (parameter.getId().equals(lowerFluxBound)) {
                        FluxBound fluxBoundLo = new FluxBound();
                        fluxBoundLo.setReaction(reaction.getId());
                        fluxBoundLo.setOperation(FluxBound.Operation.GREATER_EQUAL);
                        fluxBoundLo.setValue(parameter.getValue());
                        fbcModelPlugin.addFluxBound(fluxBoundLo);
                        parametersToDelete.add(parameter.getId());
                    }
                    if (!parameter.getId().equals(upperFluxBound)) continue;
                    FluxBound fluxBoundUp = new FluxBound();
                    fluxBoundUp.setReaction(reaction.getId());
                    fluxBoundUp.setOperation(FluxBound.Operation.LESS_EQUAL);
                    fluxBoundUp.setValue(parameter.getValue());
                    fbcModelPlugin.addFluxBound(fluxBoundUp);
                    parametersToDelete.add(parameter.getId());
                }
                for (String parameterToDelete : parametersToDelete) {
                    model.removeParameter(parameterToDelete);
                }
                fbcReactionPlugin.unsetLowerFluxBound();
                fbcReactionPlugin.unsetUpperFluxBound();
            }
            for (Reaction reaction : model.getListOfReactions()) {
                fbcReactionPlugin = (FBCReactionPlugin)reaction.getPlugin("fbc");
                Properties pElementsReactionNotes = new Properties();
                Pattern p = this.userKey != null ? Pattern.compile(this.userKey) : Pattern.compile("(?i)gene[\\-_ ]*association");
                pElementsReactionNotes = CobraUtil.parseCobraNotes((SBase)reaction);
                Enumeration<?> keys = pElementsReactionNotes.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Matcher m = p.matcher(key);
                    if (!m.matches()) continue;
                    pElementsReactionNotes.remove(key);
                }
                if (fbcReactionPlugin.isSetGeneProductAssociation()) {
                    FbcV2ToFbcV1Converter fbcV2ToFbcV1Converter = new FbcV2ToFbcV1Converter();
                    ASTNode geneAssociationString = fbcV2ToFbcV1Converter.processAssociation(fbcReactionPlugin.getGeneProductAssociation().getAssociation(), fbcModelPlugin);
                    String gAString = geneAssociationString.toFormula((FormulaCompiler)new ConfigurableLogicalFormulaCompiler());
                    pElementsReactionNotes.setProperty("GENE_ASSOCIATION", gAString);
                    CobraUtil.writeCobraNotes((SBase)reaction, (Properties)pElementsReactionNotes);
                    fbcReactionPlugin.unsetGeneProductAssociation();
                    continue;
                }
                pElementsReactionNotes.setProperty("GENE_ASSOCIATION", "");
                CobraUtil.writeCobraNotes((SBase)reaction, (Properties)pElementsReactionNotes);
            }
            fbcModelPlugin.unsetListOfGeneProducts();
        }
        return sbmlDocument;
    }

    public void setOption(String name, String value) {
        this.userKey = value;
    }

    private ASTNode processAssociation(Association association, FBCModelPlugin fbcModelPlugin) {
        ASTNode geneAssociationNode = new ASTNode();
        if (association instanceof LogicalOperator) {
            if (association instanceof Or) {
                geneAssociationNode.setType(ASTNode.Type.LOGICAL_OR);
            } else if (association instanceof And) {
                geneAssociationNode.setType(ASTNode.Type.LOGICAL_AND);
            }
            for (int j = 0; j < association.getChildCount(); ++j) {
                ASTNode newChild = this.processAssociation((Association)((Object)association.getChildAt(j)), fbcModelPlugin);
                geneAssociationNode.addChild(newChild);
            }
        } else if (association instanceof GeneProductRef) {
            GeneProductRef geneProductRef = (GeneProductRef)association;
            GeneProduct geneProduct = (GeneProduct)association.getModel().getSBaseById(geneProductRef.getGeneProduct());
            if (geneProduct != null) {
                geneAssociationNode = new ASTNode(geneProduct.getLabel());
            }
        }
        return geneAssociationNode;
    }
}

