/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Parameter;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCReactionPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.ext.fbc.converters.GPRParser;
import org.sbml.jsbml.util.CobraUtil;
import org.sbml.jsbml.util.converters.SBMLConverter;
import org.sbml.jsbml.util.filters.Filter;

public class FcbV1ToFbcV2Converter
implements SBMLConverter {
    String userKey = null;

    public SBMLDocument convert(SBMLDocument sbmlDocument) throws SBMLException {
        if (sbmlDocument.isPackageEnabled(FBCConstants.getNamespaceURI(3, 1, 1))) {
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 1), false);
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 2));
            sbmlDocument.filter(new Filter(){

                public boolean accepts(Object o) {
                    SBasePlugin sBasePlugin;
                    SBase sBase;
                    if (o instanceof SBase && (sBase = (SBase)o).getNumPlugins() > 0 && (sBasePlugin = sBase.getPlugin("fbc")) != null) {
                        if (sBasePlugin.getPackageName().equals("fbc")) {
                            sBasePlugin.setPackageVersion(2);
                        }
                        if (!sBasePlugin.getElementNamespace().equals("http://www.sbml.org/sbml/level3/version1/fbc/version2")) {
                            ((AbstractSBasePlugin)sBasePlugin).setNamespace(null);
                            ((AbstractSBasePlugin)sBasePlugin).setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version2");
                        }
                    }
                    return false;
                }
            });
            sbmlDocument.filter(new Filter(){

                public boolean accepts(Object o) {
                    SBase sBase;
                    if (o instanceof SBase && (sBase = (SBase)o).getPackageName().equals("fbc")) {
                        if (sBase.getPackageVersion() != 2) {
                            sBase.setPackageVersion(2);
                        }
                        if (!sBase.getNamespace().equals("http://www.sbml.org/sbml/level3/version1/fbc/version2")) {
                            ((AbstractSBase)sBase).setNamespace(null);
                            ((AbstractSBase)sBase).setNamespace("http://www.sbml.org/sbml/level3/version1/fbc/version2");
                        }
                    }
                    return false;
                }
            });
            Model model = sbmlDocument.getModel();
            FBCModelPlugin fbcModelPlugin = (FBCModelPlugin)model.getPlugin("fbc");
            if (!fbcModelPlugin.isSetStrict()) {
                fbcModelPlugin.setStrict(true);
            }
            for (Reaction reaction : model.getListOfReactions()) {
                FBCReactionPlugin fbcReactionPlugin = (FBCReactionPlugin)reaction.getPlugin("fbc");
                ArrayList<FluxBound> fluxBList = new ArrayList<FluxBound>();
                for (FluxBound fluxBound : fbcModelPlugin.getListOfFluxBounds()) {
                    Parameter parameter;
                    if (!fluxBound.getReaction().equals(reaction.getId())) continue;
                    if (fluxBound.getOperation() == FluxBound.Operation.GREATER_EQUAL) {
                        fbcReactionPlugin.setLowerFluxBound("fb_" + fluxBound.getReaction() + "_" + (Object)((Object)fluxBound.getOperation()));
                        parameter = new Parameter(3, 1);
                        parameter.setValue(fluxBound.getValue());
                        parameter.setId("fb_" + fluxBound.getReaction() + "_" + (Object)((Object)fluxBound.getOperation()));
                        parameter.setSBOTerm("SBO:0000625");
                        parameter.setConstant(true);
                        model.addParameter(parameter);
                    } else {
                        fbcReactionPlugin.setUpperFluxBound("fb_" + fluxBound.getReaction() + "_" + (Object)((Object)fluxBound.getOperation()));
                        parameter = new Parameter(3, 1);
                        parameter.setValue(fluxBound.getValue());
                        parameter.setId("fb_" + fluxBound.getReaction() + "_" + (Object)((Object)fluxBound.getOperation()));
                        parameter.setSBOTerm("SBO:0000625");
                        parameter.setConstant(true);
                        model.addParameter(parameter);
                    }
                    fluxBList.add(fluxBound);
                }
                for (FluxBound fluxBound : fluxBList) {
                    fbcModelPlugin.removeFluxBound(fluxBound);
                }
            }
            Properties pElementsNote = new Properties();
            Pattern p = this.userKey != null ? Pattern.compile(this.userKey) : Pattern.compile("(?i)gene[\\-_ ]*association");
            for (Reaction reaction : model.getListOfReactions()) {
                pElementsNote = CobraUtil.parseCobraNotes((SBase)reaction);
                String geneAssociation = null;
                Enumeration<?> keys = pElementsNote.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Matcher m = p.matcher(key);
                    if (!m.matches() || pElementsNote.getProperty(key) == null) continue;
                    geneAssociation = pElementsNote.getProperty(key);
                }
                if (geneAssociation == null || geneAssociation.trim().length() <= 0) continue;
                GPRParser.parseGPR(reaction, geneAssociation, false, false);
            }
        }
        return sbmlDocument;
    }

    public void setOption(String name, String value) {
        this.userKey = value;
    }
}

