/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.util.Properties;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.KineticLaw;
import org.sbml.jsbml.LocalParameter;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.ext.fbc.FBCConstants;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCSpeciesPlugin;
import org.sbml.jsbml.ext.fbc.FluxBound;
import org.sbml.jsbml.ext.fbc.FluxObjective;
import org.sbml.jsbml.ext.fbc.Objective;
import org.sbml.jsbml.util.CobraUtil;
import org.sbml.jsbml.util.PackageDisabler;
import org.sbml.jsbml.util.SBMLtools;
import org.sbml.jsbml.util.converters.SBMLConverter;

public class FbcV1ToCobraConverter
implements SBMLConverter {
    Double defaultLowerBound = null;
    Double defaultUpperBound = null;
    PackageDisabler packageDisabler;

    private void createKineticLawForReaction(Reaction reaction) {
        LocalParameter objectiveCoefficientParameter;
        LocalParameter lowerBoundParameter;
        LocalParameter upperBoundParameter;
        if (reaction == null) {
            return;
        }
        reaction.unsetKineticLaw();
        KineticLaw kineticLaw = reaction.getKineticLaw();
        if (kineticLaw == null) {
            kineticLaw = new KineticLaw(reaction);
            LocalParameter fluxValueParameter = reaction.getKineticLaw().createLocalParameter("FLUX_VALUE");
            fluxValueParameter.setValue(0.0);
            fluxValueParameter.setUnits("mmol_per_gDW_per_hr");
            ASTNode astNode = new ASTNode("FLUX_VALUE");
            kineticLaw.setMath(astNode);
        }
        if ((upperBoundParameter = kineticLaw.getLocalParameter("UPPER_BOUND")) == null) {
            upperBoundParameter = reaction.getKineticLaw().createLocalParameter("UPPER_BOUND");
            if (this.defaultUpperBound != null) {
                upperBoundParameter.setValue(this.defaultUpperBound.doubleValue());
            } else {
                upperBoundParameter.setValue(Double.POSITIVE_INFINITY);
            }
            upperBoundParameter.setExplicitlyConstant(true);
            upperBoundParameter.setUnits("mmol_per_gDW_per_hr");
        }
        if ((lowerBoundParameter = kineticLaw.getLocalParameter("LOWER_BOUND")) == null) {
            lowerBoundParameter = kineticLaw.createLocalParameter("LOWER_BOUND");
            if (this.defaultLowerBound != null) {
                lowerBoundParameter.setValue(this.defaultLowerBound.doubleValue());
            } else {
                lowerBoundParameter.setValue(Double.NEGATIVE_INFINITY);
            }
            lowerBoundParameter.setExplicitlyConstant(true);
            lowerBoundParameter.setUnits("mmol_per_gDW_per_hr");
        }
        if ((objectiveCoefficientParameter = kineticLaw.getLocalParameter("OBJECTIVE_COEFFICIENT")) == null) {
            objectiveCoefficientParameter = kineticLaw.createLocalParameter("OBJECTIVE_COEFFICIENT");
            objectiveCoefficientParameter.setUnits("mmol_per_gDW_per_hr");
            objectiveCoefficientParameter.setValue(0.0);
        }
    }

    private void unsetConstantForSpeciesReferencesOfReaction(Reaction reaction) {
        for (SpeciesReference speciesReference : reaction.getListOfProducts()) {
            speciesReference.unsetConstant();
        }
        for (SpeciesReference speciesReference : reaction.getListOfReactants()) {
            speciesReference.unsetConstant();
        }
    }

    private void updateKineticLawFromBound(Reaction reaction, FluxBound bound) {
        if (reaction == null || bound == null) {
            return;
        }
        FluxBound.Operation operation = bound.getOperation();
        KineticLaw kineticLaw = reaction.getKineticLaw();
        LocalParameter lowerBoundParameter = kineticLaw.getLocalParameter("LOWER_BOUND");
        LocalParameter upperBoundParameter = kineticLaw.getLocalParameter("UPPER_BOUND");
        if (operation.equals((Object)FluxBound.Operation.LESS) || operation.equals((Object)FluxBound.Operation.LESS_EQUAL) || operation.equals((Object)FluxBound.Operation.EQUAL)) {
            upperBoundParameter.setValue(bound.getValue());
        }
        if (operation.equals((Object)FluxBound.Operation.GREATER) || operation.equals((Object)FluxBound.Operation.GREATER_EQUAL) || operation.equals((Object)FluxBound.Operation.EQUAL)) {
            lowerBoundParameter.setValue(bound.getValue());
        }
    }

    private void setObjectiveCoefficient(FBCModelPlugin plugin, Model model) {
        if (plugin == null || model == null) {
            return;
        }
        Objective obj = plugin.getActiveObjectiveInstance();
        if (obj == null) {
            return;
        }
        for (FluxObjective fluxObj : obj.getListOfFluxObjectives()) {
            KineticLaw law;
            Reaction reaction;
            if (fluxObj == null || (reaction = model.getReaction(fluxObj.getReaction())) == null || (law = reaction.getKineticLaw()) == null) continue;
            LocalParameter param = law.getLocalParameter("OBJECTIVE_COEFFICIENT");
            param.setValue(fluxObj.getCoefficient());
        }
    }

    public SBMLDocument convert(SBMLDocument sbmlDocument) throws SBMLException {
        this.packageDisabler = new PackageDisabler(sbmlDocument);
        if (sbmlDocument.isPackageEnabled(FBCConstants.getNamespaceURI(3, 1, 1))) {
            Model model = sbmlDocument.getModel();
            sbmlDocument.enablePackage(FBCConstants.getNamespaceURI(3, 1, 1), false);
            SBMLtools.setLevelAndVersion((SBase)sbmlDocument, (int)2, (int)5);
            for (Species species : model.getListOfSpecies()) {
                Properties pElementsSpeciesNotes;
                if (!species.isSetPlugin("fbc")) continue;
                FBCSpeciesPlugin fbcSpeciesPlugin = (FBCSpeciesPlugin)species.getPlugin("fbc");
                if (fbcSpeciesPlugin.isSetChemicalFormula()) {
                    String chemicalFormula = fbcSpeciesPlugin.getChemicalFormula();
                    pElementsSpeciesNotes = new Properties();
                    pElementsSpeciesNotes = CobraUtil.parseCobraNotes((SBase)species);
                    if (pElementsSpeciesNotes.getProperty("FORMULA") != null) {
                        pElementsSpeciesNotes.remove("FORMULA");
                    }
                    pElementsSpeciesNotes.setProperty("FORMULA", chemicalFormula);
                    CobraUtil.writeCobraNotes((SBase)species, (Properties)pElementsSpeciesNotes);
                }
                if (fbcSpeciesPlugin.isSetCharge()) {
                    int charge = fbcSpeciesPlugin.getCharge();
                    pElementsSpeciesNotes = new Properties();
                    pElementsSpeciesNotes = CobraUtil.parseCobraNotes((SBase)species);
                    if (pElementsSpeciesNotes.getProperty("CHARGE") != null) {
                        pElementsSpeciesNotes.remove("CHARGE");
                    }
                    pElementsSpeciesNotes.setProperty("CHARGE", Integer.toString(charge));
                    CobraUtil.writeCobraNotes((SBase)species, (Properties)pElementsSpeciesNotes);
                }
                species.unsetPlugin("fbc");
            }
            FBCModelPlugin fbcModelPlugin = (FBCModelPlugin)model.getPlugin("fbc");
            for (Reaction reaction : model.getListOfReactions()) {
                this.createKineticLawForReaction(reaction);
                this.unsetConstantForSpeciesReferencesOfReaction(reaction);
            }
            for (FluxBound fluxBound : fbcModelPlugin.getListOfFluxBounds()) {
                this.updateKineticLawFromBound(model.getReaction(fluxBound.getReaction()), fluxBound);
            }
            this.setObjectiveCoefficient(fbcModelPlugin, model);
        }
        this.packageDisabler.removePackage("fbc");
        sbmlDocument.getSBMLDocumentAttributes().remove("fbc:required");
        return sbmlDocument;
    }

    public void setOption(String name, String value) {
        if (value == null) {
            return;
        }
        if (name.equals("DEFAULT_LOWER_BOUND")) {
            try {
                this.defaultLowerBound = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.defaultLowerBound = null;
            }
        }
        if (name.equals("DEFAULT_UPPER_BOUND")) {
            try {
                this.defaultUpperBound = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                this.defaultUpperBound = null;
            }
        }
    }
}

