/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.ext.fbc.And;
import org.sbml.jsbml.ext.fbc.Association;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.FBCReactionPlugin;
import org.sbml.jsbml.ext.fbc.GeneProduct;
import org.sbml.jsbml.ext.fbc.GeneProductAssociation;
import org.sbml.jsbml.ext.fbc.GeneProductRef;
import org.sbml.jsbml.ext.fbc.LogicalOperator;
import org.sbml.jsbml.ext.fbc.Or;
import org.sbml.jsbml.text.parser.CobraFormulaParser;
import org.sbml.jsbml.text.parser.IFormulaParser;
import org.sbml.jsbml.util.StringTools;

public class GPRParser {
    private static final transient Logger logger = Logger.getLogger(GPRParser.class);

    private static Association convertToAssociation(ASTNode ast, String reactionId, Model model, boolean omitGenericTerms, boolean displayWarning) {
        int level = model.getLevel();
        int version = model.getVersion();
        if (ast.isLogical()) {
            LogicalOperator operator;
            if (ast.getType() == ASTNode.Type.LOGICAL_AND) {
                operator = new And(level, version);
                if (!omitGenericTerms) {
                    operator.setSBOTerm(173);
                }
            } else {
                operator = new Or(level, version);
                if (!omitGenericTerms) {
                    operator.setSBOTerm(174);
                }
            }
            for (ASTNode child : ast.getListOfNodes()) {
                Association tmp = GPRParser.convertToAssociation(child, reactionId, model, omitGenericTerms, displayWarning);
                if (tmp.getClass().equals(operator.getClass())) {
                    LogicalOperator lo = (LogicalOperator)tmp;
                    for (int i = lo.getAssociationCount() - 1; i >= 0; --i) {
                        operator.addAssociation(lo.removeAssociation(i));
                    }
                    continue;
                }
                operator.addAssociation(tmp);
            }
            return operator;
        }
        return GPRParser.createGPR(ast.toString(), reactionId, model, displayWarning);
    }

    private static GeneProductRef createGPR(String identifier, String reactionId, Model model, boolean displayWarning) {
        int level = model.getLevel();
        int version = model.getVersion();
        GeneProductRef gpr = new GeneProductRef(level, version);
        String id = GPRParser.updateGeneId(identifier);
        if (!model.containsUniqueNamedSBase(id)) {
            GeneProduct gp = (GeneProduct)model.findUniqueNamedSBase(identifier);
            GeneProduct gp2 = (GeneProduct)model.findUniqueNamedSBase(id);
            if (gp == null && gp2 == null) {
                if (displayWarning) {
                    logger.warn((Object)MessageFormat.format("Creating missing gene product with id ''{0}'' because reaction ''{1}'' uses this id in its gene-product association.", id, reactionId));
                }
                FBCModelPlugin fbcPlug = (FBCModelPlugin)model.getPlugin("fbc");
                gp = fbcPlug.createGeneProduct(id);
                gp.setLabel(id);
            } else if (gp != null) {
                logger.info((Object)MessageFormat.format("Updating the id of gene product ''{0}'' to ''{1}''.", gp.getId(), id));
                gp.setId(id);
            }
        }
        gpr.setGeneProduct(id);
        return gpr;
    }

    public static GeneProductAssociation parseGPR(Reaction r, String geneReactionRule, boolean omitGenericTerms) {
        return GPRParser.parseGPR(r, geneReactionRule, omitGenericTerms, true);
    }

    public static GeneProductAssociation parseGPR(Reaction r, String geneReactionRule, boolean omitGenericTerms, boolean displayWarning) {
        FBCReactionPlugin plugin = (FBCReactionPlugin)r.getPlugin("fbc");
        if (geneReactionRule != null && geneReactionRule.length() > 0) {
            try {
                ASTNode ast = ASTNode.parseFormula((String)geneReactionRule, (IFormulaParser)new CobraFormulaParser((Reader)new StringReader("")));
                Association association = GPRParser.convertToAssociation(ast, r.getId(), r.getModel(), omitGenericTerms, displayWarning);
                if (!plugin.isSetGeneProductAssociation() || !association.equals(plugin.getGeneProductAssociation().getAssociation())) {
                    GeneProductAssociation gpa = plugin.createGeneProductAssociation();
                    gpa.setAssociation(association);
                    return gpa;
                }
            }
            catch (Throwable exc) {
                logger.error((Object)MessageFormat.format("Could not parse ''{0}'' because of {1}", geneReactionRule, StringTools.getMessage((Throwable)exc)));
            }
        }
        return null;
    }

    private static String updateGeneId(String id) {
        id = id.replace("-", "_");
        if (!(id = id.replace(".", "_")).startsWith("G_")) {
            id = "G_" + id;
        }
        return id;
    }
}

