/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.fbc.converters;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.sbml.jsbml.Annotation;
import org.sbml.jsbml.CVTerm;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.util.CobraUtil;

public class NotesToAnnotation {
    public SBMLDocument transfer(SBMLDocument sbmlDocument, String[] keys) throws IOException {
        Annotation annotation;
        CVTerm cvTerm;
        Properties pElementsNote;
        Properties namespaces = new Properties();
        Path path = Paths.get(".\\extensions\\fbc\\src\\org\\sbml\\jsbml\\ext\\fbc\\converters\\identifiersOrgNamespace.txt", new String[0]);
        BufferedReader identifiersReader = Files.newBufferedReader(path);
        namespaces.load(identifiersReader);
        Model model = sbmlDocument.getModel();
        for (String key : keys) {
            for (Species species : model.getListOfSpecies()) {
                pElementsNote = new Properties();
                pElementsNote = CobraUtil.parseCobraNotes((SBase)species);
                if (pElementsNote.getProperty(key) == null) continue;
                cvTerm = new CVTerm(CVTerm.Qualifier.BQB_IS, new String[]{"http://identifiers.org/" + namespaces.getProperty(key) + "/" + pElementsNote.getProperty(key)});
                annotation = new Annotation();
                annotation = species.getAnnotation();
                annotation.addCVTerm(cvTerm);
                species.setAnnotation(annotation);
            }
        }
        for (String key : keys) {
            for (Reaction reaction : model.getListOfReactions()) {
                pElementsNote = new Properties();
                pElementsNote = CobraUtil.parseCobraNotes((SBase)reaction);
                if (pElementsNote.getProperty(key) == null) continue;
                cvTerm = new CVTerm(CVTerm.Qualifier.BQB_IS, new String[]{"http://identifiers.org/" + namespaces.getProperty(key) + "/" + pElementsNote.getProperty(key)});
                annotation = new Annotation();
                annotation = reaction.getAnnotation();
                annotation.addCVTerm(cvTerm);
                reaction.setAnnotation(annotation);
            }
        }
        return sbmlDocument;
    }
}

