/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.fbc.FBCReactionPlugin;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class FBCReactionPluginConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        Integer packageVersionToCheck = context.getPackageVersion("fbc");
        if (packageVersionToCheck == null || packageVersionToCheck == -1) {
            return;
        }
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (packageVersionToCheck < 2) break;
                this.addRangeToSet(set, 2020701, 2020716);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 2020701: {
                func = new DuplicatedElementValidationFunction("geneProductAssociation");
                break;
            }
            case 2020702: {
                func = new UnknownPackageAttributeValidationFunction("fbc");
                break;
            }
            case 2020703: {
                func = new ValidationFunction<FBCReactionPlugin>(){

                    public boolean check(ValidationContext ctx, FBCReactionPlugin rp) {
                        if (rp.isSetLowerFluxBound()) {
                            return SyntaxChecker.isValidId((String)rp.getLowerFluxBound(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 2020704: {
                func = new ValidationFunction<FBCReactionPlugin>(){

                    public boolean check(ValidationContext ctx, FBCReactionPlugin rp) {
                        if (rp.isSetUpperFluxBound()) {
                            return SyntaxChecker.isValidId((String)rp.getUpperFluxBound(), (int)ctx.getLevel(), (int)ctx.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 2020705: {
                func = new ValidationFunction<FBCReactionPlugin>(){

                    public boolean check(ValidationContext ctx, FBCReactionPlugin rp) {
                        if (rp.isSetLowerFluxBound()) {
                            return rp.getLowerFluxBoundInstance() != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 2020706: {
                func = new ValidationFunction<FBCReactionPlugin>(){

                    public boolean check(ValidationContext ctx, FBCReactionPlugin rp) {
                        if (rp.isSetUpperFluxBound()) {
                            return rp.getUpperFluxBoundInstance() != null;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

