/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.fbc.Objective;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedOrMissingElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class ObjectiveConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        Integer packageVersionToCheck = context.getPackageVersion("fbc");
        if (packageVersionToCheck == null || packageVersionToCheck == -1) {
            return;
        }
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 2020501, 2020509);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 2020501: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 2020502: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 2020503: {
                func = new UnknownPackageAttributeValidationFunction<Objective>("fbc"){

                    public boolean check(ValidationContext ctx, Objective o) {
                        if (!o.isSetId() || !o.isSetType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)o);
                    }
                };
                break;
            }
            case 2020505: {
                func = new InvalidAttributeValidationFunction("type");
                break;
            }
            case 2020506: {
                func = new DuplicatedOrMissingElementValidationFunction("listOfFluxObjectives");
                break;
            }
            case 2020507: {
                func = new ValidationFunction<Objective>(){

                    public boolean check(ValidationContext ctx, Objective o) {
                        if (o.isSetListOfFluxObjectives()) {
                            return o.getListOfFluxObjectives().size() > 0;
                        }
                        return true;
                    }
                };
                break;
            }
            case 2020508: {
                func = new ValidationFunction<Objective>(){

                    public boolean check(ValidationContext ctx, Objective o) {
                        if (o.isSetListOfFluxObjectives()) {
                            return new UnknownElementValidationFunction().check(ctx, o.getListOfFluxObjectives());
                        }
                        return true;
                    }
                };
                break;
            }
            case 2020509: {
                func = new ValidationFunction<Objective>(){

                    public boolean check(ValidationContext ctx, Objective o) {
                        if (o.isSetListOfFluxObjectives()) {
                            return new UnknownAttributeValidationFunction().check(ctx, o.getListOfFluxObjectives());
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

