/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.HashSet;
import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.fbc.FBCModelPlugin;
import org.sbml.jsbml.ext.fbc.GeneProduct;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class GeneProductConstraints
extends AbstractConstraintDeclaration {
    public static final String JSBML_DUPLICATED_GENE_PRODUCT_SET = "jsbml.validator.fbc.duplicated.geneProduct";

    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                set.add(6020315);
                this.addRangeToSet(set, 2021201, 2021207);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 2021201: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 2021202: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 2021203: {
                func = new UnknownPackageAttributeValidationFunction<GeneProduct>("fbc"){

                    public boolean check(ValidationContext ctx, GeneProduct g) {
                        if (!g.isSetId() || !g.isSetLabel()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)g);
                    }
                };
                break;
            }
            case 2021204: {
                func = new ValidationFunction<GeneProduct>(){

                    public boolean check(ValidationContext ctx, GeneProduct g) {
                        return true;
                    }
                };
                break;
            }
            case 2021205: {
                func = new ValidationFunction<GeneProduct>(){

                    public boolean check(ValidationContext ctx, GeneProduct g) {
                        Model m = g.getModel();
                        if (m != null && m.isSetPlugin("fbc")) {
                            FBCModelPlugin fbcModel = (FBCModelPlugin)m.getPlugin("fbc");
                            Set<String> fbcDuplicatedGeneProductLabelSet = null;
                            if (fbcModel.getUserObject(GeneProductConstraints.JSBML_DUPLICATED_GENE_PRODUCT_SET) == null) {
                                fbcDuplicatedGeneProductLabelSet = new HashSet();
                                fbcModel.putUserObject(GeneProductConstraints.JSBML_DUPLICATED_GENE_PRODUCT_SET, fbcDuplicatedGeneProductLabelSet);
                                GeneProductConstraints.this.checkFbcLabelGeneProductUnique(fbcModel, fbcDuplicatedGeneProductLabelSet);
                            } else {
                                fbcDuplicatedGeneProductLabelSet = (Set)fbcModel.getUserObject(GeneProductConstraints.JSBML_DUPLICATED_GENE_PRODUCT_SET);
                            }
                            boolean isUnique = fbcDuplicatedGeneProductLabelSet.contains(g.getLabel());
                            return !isUnique;
                        }
                        return true;
                    }
                };
                break;
            }
            case 2021206: {
                func = new ValidationFunction<GeneProduct>(){

                    public boolean check(ValidationContext ctx, GeneProduct g) {
                        return true;
                    }
                };
                break;
            }
            case 2021207: {
                func = new ValidationFunction<GeneProduct>(){

                    public boolean check(ValidationContext ctx, GeneProduct g) {
                        if (g.isSetAssociatedSpecies()) {
                            String speciesId = g.getAssociatedSpecies();
                            Model m = g.getModel();
                            Species species = m.getSpecies(speciesId);
                            if (species == null) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }

    public void checkFbcLabelGeneProductUnique(FBCModelPlugin fbcModel, Set<String> fbcDuplicatedGeneProductLabelSet) {
        HashSet<String> fbcLabelsGeneProductSet = new HashSet<String>();
        if (fbcModel != null && fbcModel.getGeneProductCount() > 0) {
            for (GeneProduct g : fbcModel.getListOfGeneProducts()) {
                boolean isUnique = fbcLabelsGeneProductSet.add(g.getLabel());
                if (isUnique) continue;
                fbcDuplicatedGeneProductLabelSet.add(g.getLabel());
            }
        }
    }
}

