/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.groups;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.groups.GroupKind;
import org.sbml.jsbml.ext.groups.ListOfMemberConstraint;
import org.sbml.jsbml.ext.groups.Member;
import org.sbml.jsbml.ext.groups.MemberConstraint;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class Group
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = 2361503116934849753L;
    private GroupKind kind = null;
    protected ListOf<Member> listOfMembers = null;
    private ListOfMemberConstraint listOfMemberConstraints = null;

    public Group() {
        this.initDefaults();
    }

    public Group(Group group) {
        super((AbstractNamedSBase)group);
        if (group.isSetListOfMembers()) {
            for (Member m : group.listOfMembers) {
                this.addMember(m.clone());
            }
        }
        if (group.isSetKind()) {
            this.setKind(group.getKind());
        }
        if (group.isSetListOfMemberConstraints()) {
            this.setListOfMemberConstraints((ListOfMemberConstraint)group.getListOfMemberConstraints().clone());
        }
    }

    public Group(int level, int version) {
        super(level, version);
    }

    public boolean addMember(Member member) {
        return this.getListOfMembers().add((SBase)member);
    }

    public Group clone() {
        return new Group(this);
    }

    public Member createMember(String id) {
        Member m = new Member();
        m.setId(id);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithIdRef(String idRef) {
        Member m = new Member();
        m.setIdRef(idRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithMetaIdRef(String metaIdRef) {
        Member m = new Member();
        m.setMetaIdRef(metaIdRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithIdRef(String id, String idRef) {
        Member m = new Member();
        m.setId(id);
        m.setIdRef(idRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithMetaIdRef(String id, String metaIdRef) {
        Member m = new Member();
        m.setId(id);
        m.setMetaIdRef(metaIdRef);
        this.addMember(m);
        return m;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " < 0");
        }
        int count = super.getChildCount();
        int position = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfMembers()) {
            if (position == index) {
                return this.getListOfMembers();
            }
            ++position;
        }
        if (this.isSetListOfMemberConstraints()) {
            if (position == index) {
                return this.getListOfMemberConstraints();
            }
            ++position;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(position, 0)));
    }

    public int getChildCount() {
        int childCount = super.getChildCount();
        if (this.isSetListOfMembers()) {
            ++childCount;
        }
        if (this.isSetListOfMemberConstraints()) {
            ++childCount;
        }
        return childCount;
    }

    public GroupKind getKind() {
        return this.kind;
    }

    public ListOf<Member> getListOfMembers() {
        if (!this.isSetListOfMembers()) {
            this.listOfMembers = new ListOf();
            this.listOfMembers.setNamespace("http://www.sbml.org/sbml/level3/version1/groups/version1");
            this.registerChild((SBase)this.listOfMembers);
            this.listOfMembers.setSBaseListType(ListOf.Type.other);
        }
        return this.listOfMembers;
    }

    public Member getMember(int i) {
        if (i >= 0 && i < this.getListOfMembers().size()) {
            return (Member)this.getListOfMembers().get(i);
        }
        return null;
    }

    public int getMemberCount() {
        return this.isSetListOfMembers() ? this.getListOfMembers().size() : 0;
    }

    public int getMemberConstraintCount() {
        return this.isSetListOfMemberConstraints() ? this.getListOfMemberConstraints().size() : 0;
    }

    public int getNumMembers() {
        return this.getMemberCount();
    }

    public int getNumMemberConstraints() {
        return this.getMemberConstraintCount();
    }

    private void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/groups/version1");
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetKind() {
        return this.kind != null;
    }

    public boolean isSetListOfMembers() {
        return this.listOfMembers != null;
    }

    public boolean isSetListOfMemberConstraints() {
        return this.listOfMemberConstraints != null && !this.listOfMemberConstraints.isEmpty();
    }

    public ListOf<MemberConstraint> getListOfMemberConstraints() {
        if (!this.isSetListOfMemberConstraints()) {
            this.listOfMemberConstraints = new ListOfMemberConstraint(this.getLevel(), this.getVersion());
            this.listOfMemberConstraints.setNamespace("http://www.sbml.org/sbml/level3/version1/groups/version1");
            this.listOfMemberConstraints.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfMemberConstraints);
        }
        return this.listOfMemberConstraints;
    }

    public void setListOfMemberConstraints(ListOfMemberConstraint listOfMemberConstraints) {
        this.unsetListOfMemberConstraints();
        this.listOfMemberConstraints = listOfMemberConstraints;
        this.registerChild((SBase)this.listOfMemberConstraints);
    }

    public boolean unsetListOfMemberConstraints() {
        if (this.isSetListOfMemberConstraints()) {
            ListOfMemberConstraint oldMemberConstraints = this.listOfMemberConstraints;
            this.listOfMemberConstraints = null;
            oldMemberConstraints.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addMemberConstraint(MemberConstraint memberConstraint) {
        return this.getListOfMemberConstraints().add((SBase)memberConstraint);
    }

    public boolean removeMemberConstraint(MemberConstraint memberConstraint) {
        if (this.isSetListOfMemberConstraints()) {
            return this.getListOfMemberConstraints().remove((NamedSBase)memberConstraint);
        }
        return false;
    }

    public void removeMemberConstraint(int i) {
        if (!this.isSetListOfMemberConstraints()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        this.getListOfMemberConstraints().remove(i);
    }

    public void removeMemberConstraint(String id) {
        this.getListOfMemberConstraints().removeFirst((Filter)new NameFilter(id));
    }

    public MemberConstraint createMemberConstraint() {
        return this.createMemberConstraint(null);
    }

    public MemberConstraint createMemberConstraint(String id) {
        MemberConstraint MemberConstraint2 = new MemberConstraint(id, this.getLevel(), this.getVersion());
        this.addMemberConstraint(MemberConstraint2);
        return MemberConstraint2;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead && attributeName.equals("kind")) {
            try {
                this.setKind(GroupKind.valueOf(value));
                isAttributeRead = true;
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognized the value '" + value + "' for the attribute 'kind' on the 'group' element.");
            }
        }
        return isAttributeRead;
    }

    public void setKind(GroupKind kind) {
        this.kind = kind;
    }

    public String toString() {
        return "Group [id=" + this.getId() + ", name=" + this.getName() + (this.isSetKind() ? ", kind=" + (Object)((Object)this.getKind()) : "") + ", listOfMembers=" + this.listOfMembers + "]";
    }

    public boolean unsetListOfMembers() {
        if (this.isSetListOfMembers()) {
            ListOf<Member> oldListOfMembers = this.listOfMembers;
            this.listOfMembers = null;
            oldListOfMembers.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("groups:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("groups:name", this.getName());
        }
        if (this.isSetKind()) {
            attributes.remove("kind");
            attributes.put("groups:kind", this.getKind().toString());
        }
        return attributes;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.listOfMemberConstraints == null ? 0 : this.listOfMemberConstraints.hashCode());
        result = 31 * result + (this.listOfMembers == null ? 0 : this.listOfMembers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)((Object)obj);
        if (this.kind != other.kind) {
            return false;
        }
        if (this.listOfMemberConstraints == null ? other.listOfMemberConstraints != null : !this.listOfMemberConstraints.equals((Object)other.listOfMemberConstraints)) {
            return false;
        }
        return !(this.listOfMembers == null ? other.listOfMembers != null : !this.listOfMembers.equals(other.listOfMembers));
    }
}

