/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.groups;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.groups.ListOfMembers;
import org.sbml.jsbml.ext.groups.Member;

public class Group
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = 2361503116934849753L;
    private Kind kind = null;
    protected ListOfMembers listOfMembers = null;

    public Group() {
        this.initDefaults();
    }

    public Group(Group group) {
        super((AbstractNamedSBase)group);
        if (group.isSetListOfMembers()) {
            this.setListOfMembers(group.getListOfMembers().clone());
        }
        if (group.isSetKind()) {
            this.setKind(group.getKind());
        }
    }

    public Group(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Group clone() {
        return new Group(this);
    }

    public Member createMemberWithIdRef(String idRef) {
        Member m = new Member();
        m.setIdRef(idRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithMetaIdRef(String metaIdRef) {
        Member m = new Member();
        m.setMetaIdRef(metaIdRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithIdRef(String id, String idRef) {
        Member m = new Member();
        if (id != null) {
            m.setId(id);
        }
        m.setIdRef(idRef);
        this.addMember(m);
        return m;
    }

    public Member createMemberWithMetaIdRef(String id, String metaIdRef) {
        Member m = new Member();
        if (id != null) {
            m.setId(id);
        }
        m.setMetaIdRef(metaIdRef);
        this.addMember(m);
        return m;
    }

    public Member creteMember(SBase sbase) {
        return this.createMember(null, sbase);
    }

    public Member createMember(String id, SBase sbase) {
        NamedSBase nsb;
        if (sbase instanceof NamedSBase && (nsb = (NamedSBase)sbase).isSetId()) {
            return this.createMemberWithIdRef(id, nsb.getId());
        }
        if (sbase.isSetMetaId()) {
            return this.createMemberWithMetaIdRef(id, sbase.getMetaId());
        }
        return null;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int position = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfMembers()) {
            if (position == index) {
                return this.getListOfMembers();
            }
            ++position;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(position, 0)));
    }

    public int getChildCount() {
        int childCount = super.getChildCount();
        if (this.isSetListOfMembers()) {
            ++childCount;
        }
        return childCount;
    }

    public Kind getKind() {
        return this.kind;
    }

    public ListOfMembers getListOfMembers() {
        if (!this.isSetListOfMembers()) {
            this.listOfMembers = new ListOfMembers();
            this.listOfMembers.setPackageVersion(-1);
            this.listOfMembers.setPackageName(null);
            this.listOfMembers.setPackageName("groups");
            this.listOfMembers.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfMembers);
        }
        return this.listOfMembers;
    }

    public boolean isSetListOfMembers() {
        return this.listOfMembers != null;
    }

    public void setListOfMembers(ListOfMembers listOfMembers) {
        this.unsetListOfMembers();
        this.listOfMembers = listOfMembers;
        if (listOfMembers != null) {
            listOfMembers.setPackageVersion(-1);
            listOfMembers.setPackageName(null);
            listOfMembers.setPackageName("groups");
            listOfMembers.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfMembers);
        }
    }

    public boolean unsetListOfMembers() {
        if (this.isSetListOfMembers()) {
            ListOfMembers oldMembers = this.listOfMembers;
            this.listOfMembers = null;
            oldMembers.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean addMember(Member member) {
        return this.getListOfMembers().add((SBase)member);
    }

    public boolean removeMember(Member member) {
        if (this.isSetListOfMembers()) {
            return this.getListOfMembers().remove((NamedSBase)member);
        }
        return false;
    }

    public Member removeMember(String id) {
        if (this.isSetListOfMembers()) {
            return (Member)this.getListOfMembers().remove(id);
        }
        return null;
    }

    public Member removeMember(int i) {
        if (!this.isSetListOfMembers()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Member)this.getListOfMembers().remove(i);
    }

    public Member createMember() {
        return this.createMember(null);
    }

    public Member createMember(String id) {
        Member member = new Member();
        member.setId(id);
        this.addMember(member);
        return member;
    }

    public Member getMember(int i) {
        if (!this.isSetListOfMembers()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Member)this.getListOfMembers().get(i);
    }

    public Member getMember(String id) {
        if (this.isSetListOfMembers()) {
            return (Member)this.getListOfMembers().get(id);
        }
        return null;
    }

    public int getMemberCount() {
        return this.isSetListOfMembers() ? this.getListOfMembers().size() : 0;
    }

    public int getNumMembers() {
        return this.getMemberCount();
    }

    private void initDefaults() {
        this.packageName = "groups";
        this.setPackageVersion(-1);
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetKind() {
        return this.kind != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead && attributeName.equals("kind")) {
            try {
                this.setKind(Kind.valueOf(value));
                isAttributeRead = true;
            }
            catch (Exception e) {
                throw new SBMLException("Could not recognized the value '" + value + "' for the attribute 'kind' on the 'group' element.");
            }
        }
        return isAttributeRead;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("groups:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("groups:name", this.getName());
        }
        if (this.isSetKind()) {
            attributes.remove("kind");
            attributes.put("groups:kind", this.getKind().toString());
        }
        return attributes;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.listOfMembers == null ? 0 : this.listOfMembers.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)((Object)obj);
        if (this.kind != other.kind) {
            return false;
        }
        return !(this.listOfMembers == null ? other.listOfMembers != null : !this.listOfMembers.equals((Object)other.listOfMembers));
    }

    public static enum Kind {
        classification,
        partonomy,
        collection;

    }
}

