/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.groups;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.groups.Group;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class GroupsModelPlugin
extends AbstractSBasePlugin {
    private static final long serialVersionUID = 3334444867660252255L;
    protected ListOf<Group> listOfGroups;

    public GroupsModelPlugin(GroupsModelPlugin groupModelPlugin) {
        super((SBasePlugin)groupModelPlugin);
        if (groupModelPlugin.listOfGroups != null) {
            this.setListOfGroups((ListOf<Group>)groupModelPlugin.getListOfGroups().clone());
        }
    }

    public GroupsModelPlugin(Model model) {
        super((SBase)model);
        this.initDefaults();
    }

    public boolean addGroup(Group group) {
        return this.getListOfGroups().add((SBase)group);
    }

    public GroupsModelPlugin clone() {
        return new GroupsModelPlugin(this);
    }

    public Group createGroup() {
        return this.createGroup(null);
    }

    public Group createGroup(String id) {
        Group g = new Group(this.getLevel(), this.getVersion());
        if (id != null) {
            g.setId(id);
        }
        this.addGroup(g);
        return g;
    }

    public Group createGroup(String id, String ... memberIds) {
        Group g = this.createGroup(id);
        if (memberIds != null) {
            for (String memberId : memberIds) {
                g.createMember(memberId);
            }
        }
        return g;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int childIndex) {
        if (childIndex < 0 || childIndex >= 1) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), childIndex, Math.min(this.getChildCount(), 0)));
        }
        return this.listOfGroups;
    }

    public int getChildCount() {
        if (this.isSetListOfGroups()) {
            return 1;
        }
        return 0;
    }

    public Group getGroup(int i) {
        if (!this.isSetListOfGroups()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (Group)this.listOfGroups.get(i);
    }

    public SBase getGroup(String sbmlID) {
        if (this.isSetListOfGroups()) {
            return this.listOfGroups.firstHit((Filter)new NameFilter(sbmlID));
        }
        return null;
    }

    public int getGroupCount() {
        return this.isSetListOfGroups() ? this.listOfGroups.size() : 0;
    }

    public ListOf<Group> getListOfGroups() {
        if (!this.isSetListOfGroups()) {
            this.listOfGroups = new ListOf();
            this.listOfGroups.setPackageVersion(-1);
            this.listOfGroups.setPackageName(null);
            this.listOfGroups.setPackageName("groups");
            this.listOfGroups.setSBaseListType(ListOf.Type.other);
            if (this.extendedSBase != null) {
                this.extendedSBase.registerChild(this.listOfGroups);
            }
        }
        return this.listOfGroups;
    }

    public int getNumGroups() {
        return this.getGroupCount();
    }

    public String getPackageName() {
        return "groups";
    }

    public SBMLDocument getParent() {
        if (this.isSetExtendedSBase()) {
            return (SBMLDocument)this.getExtendedSBase().getParent();
        }
        return null;
    }

    public SBMLDocument getParentSBMLObject() {
        return this.getParent();
    }

    public String getPrefix() {
        return "groups";
    }

    public String getURI() {
        return this.getElementNamespace();
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
    }

    public boolean isSetListOfGroups() {
        return this.listOfGroups != null;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public void setListOfGroups(ListOf<Group> listOfGroups) {
        this.unsetListOfGroups();
        this.listOfGroups = listOfGroups;
        if (listOfGroups != null) {
            listOfGroups.setPackageVersion(-1);
            listOfGroups.setPackageName(null);
            listOfGroups.setPackageName("groups");
            listOfGroups.setSBaseListType(ListOf.Type.other);
            if (this.isSetExtendedSBase()) {
                this.extendedSBase.registerChild(listOfGroups);
            }
        }
    }

    public boolean unsetListOfGroups() {
        if (this.listOfGroups != null) {
            ListOf<Group> oldListOfGroups = this.listOfGroups;
            this.listOfGroups = null;
            oldListOfGroups.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        return null;
    }
}

