/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.util.Locale;
import java.util.Map;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.util.StringTools;

public class CompartmentGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = -831178362695634919L;
    private Double order;

    public CompartmentGlyph() {
    }

    public CompartmentGlyph(CompartmentGlyph compartmentGlyph) {
        super(compartmentGlyph);
    }

    public CompartmentGlyph(int level, int version) {
        super(level, version);
    }

    public CompartmentGlyph(String id) {
        super(id);
    }

    public CompartmentGlyph(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public CompartmentGlyph clone() {
        return new CompartmentGlyph(this);
    }

    public String getCompartment() {
        return this.getReference();
    }

    public NamedSBase getCompartmentInstance() {
        return this.getNamedSBaseInstance();
    }

    public double getOrder() {
        if (this.isSetOrder()) {
            return this.order;
        }
        throw new PropertyUndefinedError("order", (SBase)this);
    }

    public boolean isSetCompartment() {
        return this.isSetReference();
    }

    public boolean isSetOrder() {
        return this.order != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("compartment")) {
                this.setCompartment(value);
            } else if (attributeName.equals("order")) {
                this.setOrder(StringTools.parseSBMLDouble((String)value));
            } else {
                return false;
            }
            return true;
        }
        return isAttributeRead;
    }

    public void setCompartment(Compartment compartment) {
        this.setCompartment(compartment.getId());
    }

    public void setCompartment(String compartment) {
        this.setReference(compartment, "compartment");
    }

    public void setOrder(double order) {
        double oldOrder = this.order;
        this.order = order;
        this.firePropertyChange("order", oldOrder, this.order);
    }

    public void unsetCompartment() {
        this.unsetReference();
    }

    public boolean unsetOrder() {
        if (this.isSetOrder()) {
            double oldOrder = this.order;
            this.order = null;
            this.firePropertyChange("order", oldOrder, this.order);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetCompartment()) {
            attributes.put("layout:compartment", this.getCompartment());
        }
        if (this.isSetOrder()) {
            attributes.put("layout:order", StringTools.toString((Locale)Locale.ENGLISH, (double)this.order));
        }
        return attributes;
    }
}

