/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.LineSegment;

public class Curve
extends AbstractNamedSBase {
    private static final long serialVersionUID = -5435135643993920570L;
    ListOf<CurveSegment> listOfCurveSegments = new ListOf();

    public Curve() {
        this.initDefaults();
    }

    public Curve(Curve curve) {
        super((AbstractNamedSBase)curve);
        if (curve.isSetListOfCurveSegments()) {
            this.setListOfCurveSegments((ListOf<CurveSegment>)curve.getListOfCurveSegments().clone());
        }
    }

    public Curve(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public boolean addCurveSegment(CurveSegment curveSegment) {
        return this.getListOfCurveSegments().add((SBase)curveSegment);
    }

    public void addCurveSegment(int index, CurveSegment element) {
        this.getListOfCurveSegments().add(index, (SBase)element);
    }

    public Curve clone() {
        return new Curve(this);
    }

    public LineSegment createLineSegment() {
        LineSegment cs = new LineSegment(this.getLevel(), this.getVersion());
        this.addCurveSegment(cs);
        return cs;
    }

    public CubicBezier createCubicBezier() {
        CubicBezier cs = new CubicBezier(this.getLevel(), this.getVersion());
        this.addCurveSegment(cs);
        return cs;
    }

    public boolean equals(Object object) {
        Curve curve;
        boolean equals = super.equals(object);
        if (equals && (equals &= (curve = (Curve)((Object)object)).isSetListOfCurveSegments() == this.isSetListOfCurveSegments()) && this.isSetListOfCurveSegments()) {
            equals &= curve.getListOfCurveSegments().equals(this.getListOfCurveSegments());
        }
        return equals;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetListOfCurveSegments()) {
            if (pos == index) {
                return this.getListOfCurveSegments();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetListOfCurveSegments()) {
            ++count;
        }
        return count;
    }

    public CurveSegment getCurveSegment(int n) {
        return (CurveSegment)this.getListOfCurveSegments().get(n);
    }

    public int getCurveSegmentCount() {
        return this.isSetListOfCurveSegments() ? this.getListOfCurveSegments().size() : 0;
    }

    public ListOf<CurveSegment> getListOfCurveSegments() {
        return this.listOfCurveSegments;
    }

    public int hashCode() {
        int prime = 929;
        int hashCode = super.hashCode();
        if (this.isSetListOfCurveSegments()) {
            hashCode += 929 * this.getListOfCurveSegments().hashCode();
        }
        return hashCode;
    }

    private void initDefaults() {
        this.setNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1");
        this.listOfCurveSegments.setNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1");
        this.listOfCurveSegments.setSBaseListType(ListOf.Type.other);
        this.registerChild((SBase)this.listOfCurveSegments);
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetListOfCurveSegments() {
        return this.listOfCurveSegments != null && this.listOfCurveSegments.size() > 0;
    }

    public boolean removeCurveSegment(CurveSegment cs) {
        return this.getListOfCurveSegments().remove((Object)cs);
    }

    public void setListOfCurveSegments(ListOf<CurveSegment> listOfCurveSegments) {
        this.unsetListOfCurveSegments();
        this.listOfCurveSegments = listOfCurveSegments;
        if (this.listOfCurveSegments != null && this.listOfCurveSegments.getSBaseListType() != ListOf.Type.other) {
            this.listOfCurveSegments.setSBaseListType(ListOf.Type.other);
        }
        this.registerChild((SBase)this.listOfCurveSegments);
    }

    public boolean unsetListOfCurveSegments() {
        if (this.listOfCurveSegments != null) {
            ListOf<CurveSegment> oldListOfCurveSegments = this.listOfCurveSegments;
            this.listOfCurveSegments = null;
            oldListOfCurveSegments.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }
}

