/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.NamedSBaseReferenceFilter;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.util.filters.Filter;

public class ReactionGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = 8770691813350594995L;
    private Curve curve;
    private ListOf<SpeciesReferenceGlyph> listOfSpeciesReferencesGlyphs;

    public ReactionGlyph() {
    }

    public ReactionGlyph(int level, int version) {
        super(level, version);
    }

    public ReactionGlyph(ReactionGlyph reactionGlyph) {
        super(reactionGlyph);
        if (reactionGlyph.isSetCurve()) {
            this.setCurve(reactionGlyph.getCurve().clone());
        }
        if (reactionGlyph.isSetListOfSpeciesReferencesGlyphs()) {
            this.setListOfSpeciesReferencesGlyph((ListOf<SpeciesReferenceGlyph>)reactionGlyph.getListOfSpeciesReferenceGlyphs().clone());
        }
    }

    public ReactionGlyph(String id) {
        super(id);
    }

    public ReactionGlyph(String id, int level, int version) {
        super(id, level, version);
    }

    public boolean addSpeciesReferenceGlyph(SpeciesReferenceGlyph glyph) {
        return this.getListOfSpeciesReferenceGlyphs().add((SBase)glyph);
    }

    @Override
    public ReactionGlyph clone() {
        return new ReactionGlyph(this);
    }

    public SpeciesReferenceGlyph createSpeciesReferenceGlyph(String id) {
        SpeciesReferenceGlyph glyph = new SpeciesReferenceGlyph(id, this.getLevel(), this.getVersion());
        this.addSpeciesReferenceGlyph(glyph);
        return glyph;
    }

    public SpeciesReferenceGlyph createSpeciesReferenceGlyph(String id, String speciesGlyph) {
        SpeciesReferenceGlyph glyph = this.createSpeciesReferenceGlyph(id);
        glyph.setSpeciesGlyph(speciesGlyph);
        return glyph;
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            ReactionGlyph reactionGlyph = (ReactionGlyph)((Object)object);
            if ((equals &= reactionGlyph.isSetCurve() == this.isSetCurve()) && this.isSetCurve()) {
                equals &= reactionGlyph.getCurve().equals((Object)this.getCurve());
            }
            if ((equals &= reactionGlyph.isSetListOfSpeciesReferencesGlyphs() == this.isSetListOfSpeciesReferencesGlyphs()) && this.isSetListOfSpeciesReferencesGlyphs()) {
                equals &= reactionGlyph.getListOfSpeciesReferenceGlyphs().equals(this.getListOfSpeciesReferenceGlyphs());
            }
        }
        return equals;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetCurve()) {
            if (pos == index) {
                return this.getCurve();
            }
            ++pos;
        }
        if (this.isSetListOfSpeciesReferencesGlyphs()) {
            if (pos == index) {
                return this.getListOfSpeciesReferenceGlyphs();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetCurve()) {
            ++count;
        }
        if (this.isSetListOfSpeciesReferencesGlyphs()) {
            ++count;
        }
        return count;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public ListOf<SpeciesReferenceGlyph> getListOfSpeciesReferenceGlyphs() {
        if (!this.isSetListOfSpeciesReferencesGlyphs()) {
            this.listOfSpeciesReferencesGlyphs = new ListOf();
            this.listOfSpeciesReferencesGlyphs.setNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1");
            this.listOfSpeciesReferencesGlyphs.setSBaseListType(ListOf.Type.other);
            this.registerChild((SBase)this.listOfSpeciesReferencesGlyphs);
        }
        return this.listOfSpeciesReferencesGlyphs;
    }

    public String getReaction() {
        return this.getReference();
    }

    public NamedSBase getReactionInstance() {
        return this.getNamedSBaseInstance();
    }

    public SpeciesReferenceGlyph getSpeciesReferenceGlyph(int i) {
        return (SpeciesReferenceGlyph)this.getListOfSpeciesReferenceGlyphs().get(i);
    }

    public SpeciesReferenceGlyph getSpeciesReferenceGlyph(String srGlyphId) {
        return (SpeciesReferenceGlyph)this.getListOfSpeciesReferenceGlyphs().firstHit((Filter)new NamedSBaseReferenceFilter(srGlyphId));
    }

    @Override
    public int hashCode() {
        int prime = 953;
        int hashCode = super.hashCode();
        if (this.isSetCurve()) {
            hashCode += 953 * this.getCurve().hashCode();
        }
        if (this.isSetListOfSpeciesReferencesGlyphs()) {
            hashCode += 953 * this.getListOfSpeciesReferenceGlyphs().hashCode();
        }
        return hashCode;
    }

    public boolean isSetCurve() {
        return this.curve != null;
    }

    public boolean isSetListOfSpeciesReferencesGlyphs() {
        return this.listOfSpeciesReferencesGlyphs != null;
    }

    public boolean isSetReaction() {
        return this.isSetReference();
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("reaction")) {
                this.setReaction(value);
            } else {
                return false;
            }
        }
        return isAttributeRead;
    }

    public void setCurve(Curve curve) {
        if (this.curve != null) {
            Curve oldValue = this.curve;
            this.curve = null;
            oldValue.fireNodeRemovedEvent();
        }
        this.curve = curve;
        this.registerChild((SBase)this.curve);
    }

    public void setListOfSpeciesReferencesGlyph(ListOf<SpeciesReferenceGlyph> listOfSpeciesReferencesGlyph) {
        this.unsetListOfSpeciesReferencesGlyph();
        this.listOfSpeciesReferencesGlyphs = listOfSpeciesReferencesGlyph;
        this.registerChild((SBase)this.listOfSpeciesReferencesGlyphs);
    }

    public void setReaction(Reaction reaction) {
        this.setReaction(reaction.getId());
    }

    public void setReaction(String reaction) {
        this.setReference(reaction, "reaction");
    }

    public void unsetListOfSpeciesReferencesGlyph() {
        if (this.listOfSpeciesReferencesGlyphs != null) {
            ListOf<SpeciesReferenceGlyph> oldValue = this.listOfSpeciesReferencesGlyphs;
            this.listOfSpeciesReferencesGlyphs = null;
            oldValue.fireNodeRemovedEvent();
        }
    }

    public void unsetReaction() {
        this.unsetReference();
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetReaction()) {
            attributes.put("layout:reaction", this.getReaction());
        }
        return attributes;
    }
}

