/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SimpleSpeciesReference;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceRole;

public class SpeciesReferenceGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = -8810905237933499989L;
    private Curve curve;
    private SpeciesReferenceRole role;
    private String speciesGlyph;

    public SpeciesReferenceGlyph() {
    }

    public SpeciesReferenceGlyph(int level, int version) {
        super(level, version);
    }

    public SpeciesReferenceGlyph(SpeciesReferenceGlyph speciesReferenceGlyph) {
        super(speciesReferenceGlyph);
        if (speciesReferenceGlyph.isSetCurve()) {
            this.setCurve(speciesReferenceGlyph.getCurve().clone());
        }
        if (speciesReferenceGlyph.isSetSpeciesReferenceRole()) {
            this.setRole(SpeciesReferenceRole.valueOf(speciesReferenceGlyph.getSpeciesReferenceRole().toString()));
        }
        if (speciesReferenceGlyph.isSetSpeciesGlyph()) {
            this.setSpeciesGlyph(new String(speciesReferenceGlyph.getSpeciesGlyph()));
        }
    }

    public SpeciesReferenceGlyph(String id) {
        super(id);
    }

    public SpeciesReferenceGlyph(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public SpeciesReferenceGlyph clone() {
        return new SpeciesReferenceGlyph(this);
    }

    public Curve createCurve() {
        if (this.isSetCurve()) {
            this.unsetCurve();
        }
        this.setCurve(new Curve(this.getLevel(), this.getVersion()));
        return this.getCurve();
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            SpeciesReferenceGlyph s = (SpeciesReferenceGlyph)((Object)object);
            if ((equals &= s.isSetSpeciesReferenceRole() && this.isSetSpeciesReferenceRole()) && this.isSetSpeciesReferenceRole()) {
                equals &= s.getSpeciesReferenceRole().equals((Object)this.getSpeciesReferenceRole());
            }
            if ((equals &= s.isSetSpeciesGlyph() == this.isSetSpeciesGlyph()) && this.isSetSpeciesGlyph()) {
                equals &= s.getSpeciesGlyph().equals(this.getSpeciesGlyph());
            }
        }
        return equals;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetCurve()) {
            if (pos == index) {
                return this.getCurve();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format("Index {0,number,integer} >= {1,number,integer}", index, Math.min(pos, 0)));
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetCurve()) {
            ++count;
        }
        return count;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public String getSpeciesGlyph() {
        return this.speciesGlyph;
    }

    public SpeciesGlyph getSpeciesGlyphInstance() {
        if (!this.isSetSpeciesGlyph()) {
            return null;
        }
        Model model = this.getModel();
        return model != null ? (SpeciesGlyph)model.findNamedSBase(this.getSpeciesGlyph()) : null;
    }

    public String getSpeciesReference() {
        return this.getReference();
    }

    public NamedSBase getSpeciesReferenceInstance() {
        return this.getNamedSBaseInstance();
    }

    public SpeciesReferenceRole getSpeciesReferenceRole() {
        return this.role;
    }

    @Override
    public int hashCode() {
        int prime = 953;
        int hashCode = super.hashCode();
        if (this.isSetSpeciesReferenceRole()) {
            hashCode += 953 * this.getSpeciesReferenceRole().hashCode();
        }
        if (this.isSetSpeciesGlyph()) {
            hashCode += 953 * this.getSpeciesGlyph().hashCode();
        }
        return hashCode;
    }

    public boolean isSetCurve() {
        return this.curve != null;
    }

    public boolean isSetSpeciesGlyph() {
        return this.speciesGlyph != null;
    }

    public boolean isSetSpeciesReference() {
        return this.isSetReference();
    }

    public boolean isSetSpeciesReferenceRole() {
        return this.role != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("speciesReference")) {
                this.setSpeciesReference(value);
            } else if (attributeName.equals("speciesGlyph")) {
                this.setSpeciesGlyph(value);
            } else if (attributeName.equals("role")) {
                try {
                    this.setRole(SpeciesReferenceRole.valueOf(value.toUpperCase()));
                }
                catch (Exception e) {
                    throw new SBMLException("Could not recognized the value '" + value + "' for the attribute " + "role" + " on the 'SpeciesReferenceGlyph' element.");
                }
            } else {
                return false;
            }
        }
        return isAttributeRead;
    }

    public void setCurve(Curve curve) {
        Curve oldCurve = this.curve;
        this.curve = curve;
        this.firePropertyChange("curve", (Object)oldCurve, (Object)this.role);
        this.registerChild((SBase)this.curve);
    }

    public void setRole(SpeciesReferenceRole valueOf) {
        SpeciesReferenceRole oldRole = this.role;
        this.role = valueOf;
        this.firePropertyChange("role", (Object)oldRole, (Object)this.role);
    }

    public void setSpeciesGlyph(String speciesGlyph) {
        String oldValue = this.speciesGlyph;
        this.speciesGlyph = speciesGlyph;
        this.firePropertyChange("speciesGlyph", oldValue, this.speciesGlyph);
    }

    public void setSpeciesReference(SimpleSpeciesReference speciesReference) {
        this.setSpeciesReference(speciesReference.getId());
    }

    public void setSpeciesReference(String speciesReference) {
        this.setReference(speciesReference, "speciesReference");
    }

    public boolean unsetCurve() {
        if (this.isSetCurve()) {
            Curve oldCurve = this.getCurve();
            this.curve = null;
            oldCurve.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public void unsetSpeciesReference() {
        this.unsetReference();
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSpeciesGlyph()) {
            attributes.put("layout:speciesGlyph", this.speciesGlyph);
        }
        if (this.isSetSpeciesReference()) {
            attributes.put("layout:speciesReference", this.getSpeciesReference());
        }
        if (this.isSetSpeciesReferenceRole()) {
            attributes.put("layout:role", this.role.toString().toLowerCase());
        }
        return attributes;
    }
}

