/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractSBase;
import org.sbml.jsbml.Annotation;
import org.sbml.jsbml.JSBML;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutConstants;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.parsers.ReadingParser;
import org.sbml.jsbml.xml.parsers.WritingParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class LayoutParser
implements ReadingParser,
WritingParser,
PackageParser {
    private Logger logger = Logger.getLogger(LayoutParser.class);
    private static final String namespaceURI = "http://projects.eml.org/bcb/sbml/level2";
    private LayoutList groupList = LayoutList.none;
    private Logger log4jLogger = Logger.getLogger(LayoutParser.class);
    private HashMap<String, Class<? extends Object>> sbmlLayoutElements = new HashMap();

    public static String getNamespaceURI() {
        return namespaceURI;
    }

    public LayoutParser() {
        JSBML.loadClasses((String)"org/sbml/jsbml/resources/cfg/SBMLLayoutElements.xml", this.sbmlLayoutElements);
    }

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        this.log4jLogger.debug((Object)MessageFormat.format("{0}: getListOfSBMLElementsToWrite\n", this.getClass().getSimpleName()));
        LinkedList<Object> listOfElementsToWrite = new LinkedList<Object>();
        if (!(sbase instanceof SBMLDocument)) {
            if (sbase instanceof Model) {
                LayoutModelPlugin layoutModel = (LayoutModelPlugin)((Model)sbase).getExtension(namespaceURI);
                if (layoutModel != null && layoutModel.isSetListOfLayouts()) {
                    listOfElementsToWrite.add(layoutModel.getListOfLayouts());
                }
            } else if (sbase instanceof TreeNode) {
                Enumeration<? extends TreeNode> children = ((TreeNode)sbase).children();
                while (children.hasMoreElements()) {
                    listOfElementsToWrite.add(children.nextElement());
                }
            }
        }
        if (sbase instanceof SBase) {
            Point point;
            SBase parent;
            SBase elem = (SBase)sbase;
            this.log4jLogger.debug((Object)("add to write: " + elem.getElementName() + " namespace: " + elem.getNamespace().toString()));
            if (sbase instanceof ListOf) {
                this.log4jLogger.debug((Object)"process a ListOf instance");
                ListOf listOf = (ListOf)sbase;
                if (!listOf.isEmpty()) {
                    listOfElementsToWrite = new LinkedList();
                    for (int i = 0; i < listOf.size(); ++i) {
                        SBase element = listOf.get(i);
                        if (element == null) continue;
                        listOfElementsToWrite.add(element);
                    }
                }
            } else if (sbase instanceof Layout) {
                Layout layout = (Layout)((Object)sbase);
                if (layout.isSetListOfSpeciesGlyphs()) {
                    listOfElementsToWrite.add(layout.getListOfSpeciesGlyphs());
                    ListOf<SpeciesGlyph> listOfSpeciesGlyph = layout.getListOfSpeciesGlyphs();
                    this.log4jLogger.debug((Object)"found list of species glyph");
                    this.log4jLogger.debug((Object)("list of species glyph: " + listOfSpeciesGlyph.getElementName()));
                } else if (layout.isSetListOfCompartmentGlyphs()) {
                    listOfElementsToWrite.add(layout.getListOfCompartmentGlyphs());
                } else if (layout.isSetListOfReactionGlyphs()) {
                    listOfElementsToWrite.add(layout.getListOfReactionGlyphs());
                } else if (layout.isSetListOfTextGlyphs()) {
                    listOfElementsToWrite.add(layout.getListOfTextGlyphs());
                }
            } else if (sbase instanceof Point && (parent = (point = (Point)((Object)sbase)).getParentSBMLObject()) instanceof CurveSegment) {
                this.log4jLogger.debug((Object)(" curveSegment: point element name: " + point.getElementName()));
            }
        }
        if (listOfElementsToWrite.isEmpty()) {
            listOfElementsToWrite = null;
        }
        return listOfElementsToWrite;
    }

    public void writeAttributes(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        if (sbmlElementToWrite instanceof SBase) {
            SBase sbase = (SBase)sbmlElementToWrite;
            xmlObject.addAttributes(sbase.writeXMLAttributes());
        }
    }

    public void writeCharacters(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        if (sbmlElementToWrite instanceof SBase) {
            SBase sbase = (SBase)sbmlElementToWrite;
            if (this.log4jLogger.isDebugEnabled()) {
                this.log4jLogger.debug((Object)MessageFormat.format("{0} ", sbase.getElementName()));
            }
            if (!xmlObject.isSetName()) {
                xmlObject.setName(sbase.getElementName());
            }
            if (!xmlObject.isSetPrefix()) {
                xmlObject.setPrefix("layout");
            }
            xmlObject.setNamespace(namespaceURI);
            String name = xmlObject.getName();
            if (name.equals("lineSegment") || name.equals("cubicBezier")) {
                xmlObject.setName("curveSegment");
            }
            if (name.equals("listOfLineSegments") || name.equals("listOfCubicBeziers")) {
                xmlObject.setName("listOfCurveSegments");
            }
            if (xmlObject.getName().equals("listOfLayouts")) {
                xmlObject.getAttributes().put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
    }

    public void writeNamespaces(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
    }

    public void processAttribute(String elementName, String attributeName, String value, String uri, String prefix, boolean isLastAttribute, Object contextObject) {
        this.log4jLogger.debug((Object)"processAttribute\n");
        boolean isAttributeRead = false;
        if (contextObject instanceof SBase) {
            SBase sbase = (SBase)contextObject;
            this.log4jLogger.debug((Object)("processAttribute: level, version = " + sbase.getLevel() + ", " + sbase.getVersion()));
            try {
                isAttributeRead = sbase.readAttribute(attributeName, prefix, value);
            }
            catch (Throwable exc) {
                System.err.println(exc.getMessage());
            }
        } else if (contextObject instanceof Annotation) {
            Annotation annotation = (Annotation)contextObject;
            isAttributeRead = annotation.readAttribute(attributeName, prefix, value);
        } else if (contextObject instanceof SBasePlugin) {
            isAttributeRead = ((SBasePlugin)contextObject).readAttribute(attributeName, prefix, value);
        }
        if (!isAttributeRead) {
            this.log4jLogger.warn((Object)("processAttribute: The attribute " + attributeName + " on the element " + elementName + " is not part of the SBML specifications"));
        }
    }

    public void processCharactersOf(String elementName, String characters, Object contextObject) {
    }

    public void processEndDocument(SBMLDocument sbmlDocument) {
        if (sbmlDocument.isSetModel() && sbmlDocument.getModel().getExtension(namespaceURI) != null) {
            List curveElements = sbmlDocument.getModel().getExtension(namespaceURI).filter(new Filter(){

                public boolean accepts(Object o) {
                    return o instanceof Curve;
                }
            });
            for (TreeNode curveNode : curveElements) {
                Curve curve = (Curve)((Object)curveNode);
                int i = 0;
                for (CurveSegment curveSegment : curve.getListOfCurveSegments().clone()) {
                    if (!curveSegment.isSetType()) {
                        if (((CubicBezier)curveSegment).isSetBasePoint1() || ((CubicBezier)curveSegment).isSetBasePoint2()) {
                            curveSegment.readAttribute("type", "", CurveSegment.Type.CUBIC_BEZIER.toString());
                        } else {
                            curveSegment.readAttribute("type", "", CurveSegment.Type.LINE_SEGMENT.toString());
                        }
                    }
                    if (curveSegment.getType().equals((Object)CurveSegment.Type.LINE_SEGMENT)) {
                        LineSegment realCurveSegment = new LineSegment(curveSegment);
                        this.setNamespace((SBase)realCurveSegment, namespaceURI);
                        this.logger.debug((Object)("Transformed CubicBezier: " + (Object)((Object)curveSegment) + " into LineSegment."));
                        curve.getListOfCurveSegments().remove(i);
                        curve.getListOfCurveSegments().add(i, (SBase)realCurveSegment);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Transformed CurveSegment: realCurveSegment = " + curve.getListOfCurveSegments().get(i)));
                    }
                    ++i;
                }
            }
        }
    }

    public void processNamespace(String elementName, String URI, String prefix, String localName, boolean hasAttributes, boolean isLastNamespace, Object contextObject) {
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (elementName.equals("basePoint1")) {
            this.log4jLogger.debug((Object)"processing basePoint1");
        }
        if (this.sbmlLayoutElements.containsKey(elementName)) {
            try {
                BoundingBox boundingBox;
                Curve curve;
                Dimensions dimensions;
                Annotation annotation;
                Object newContextObject = this.sbmlLayoutElements.get(elementName).newInstance();
                if (contextObject instanceof Annotation) {
                    annotation = (Annotation)contextObject;
                    Model model = (Model)annotation.getParent();
                    LayoutModelPlugin layoutModel = null;
                    if (model.getExtension(namespaceURI) != null) {
                        layoutModel = (LayoutModelPlugin)model.getExtension(namespaceURI);
                    } else {
                        layoutModel = new LayoutModelPlugin(model);
                        model.addExtension(namespaceURI, (SBasePlugin)layoutModel);
                    }
                }
                if (contextObject instanceof SBase) {
                    this.setLevelAndVersionFor(newContextObject, (SBase)contextObject);
                }
                if (contextObject instanceof Annotation) {
                    annotation = (Annotation)contextObject;
                    if (elementName.equals("listOfLayouts")) {
                        ListOf listOfLayouts = (ListOf)newContextObject;
                        listOfLayouts.setSBaseListType(ListOf.Type.other);
                        this.setNamespace((SBase)listOfLayouts, namespaceURI);
                        this.groupList = LayoutList.listOfLayouts;
                        Model model = (Model)annotation.getParent();
                        LayoutModelPlugin layoutModel = (LayoutModelPlugin)model.getExtension(namespaceURI);
                        layoutModel.setListOfLayouts((ListOf<Layout>)listOfLayouts);
                        return listOfLayouts;
                    }
                    this.log4jLogger.warn((Object)MessageFormat.format("Element {0} not recognized!", elementName));
                } else if (contextObject instanceof ListOf) {
                    ListOf listOf = (ListOf)contextObject;
                    if (listOf.getParentSBMLObject() instanceof Model) {
                        if (elementName.equals("layout") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                            ListOf listOflayouts = listOf;
                            Layout layout = (Layout)((Object)newContextObject);
                            this.setNamespace((SBase)layout, namespaceURI);
                            listOflayouts.add((SBase)layout);
                            return layout;
                        }
                    } else if (listOf.getParentSBMLObject() instanceof Layout) {
                        if (elementName.equals("compartmentGlyph") && this.groupList.equals((Object)LayoutList.listOfCompartmentGlyphs)) {
                            ListOf listOfCompartmentGlyph = (ListOf)contextObject;
                            CompartmentGlyph compartmentGlyph = (CompartmentGlyph)((Object)newContextObject);
                            this.setNamespace((SBase)listOfCompartmentGlyph, namespaceURI);
                            this.setNamespace((SBase)compartmentGlyph, namespaceURI);
                            listOfCompartmentGlyph.add((SBase)compartmentGlyph);
                            this.groupList = LayoutList.listOfCompartmentGlyphs;
                            return compartmentGlyph;
                        }
                        if (elementName.equals("textGlyph") && this.groupList.equals((Object)LayoutList.listOfTextGlyphs)) {
                            ListOf listOfTextGlyph = (ListOf)contextObject;
                            TextGlyph textGlyph = (TextGlyph)((Object)newContextObject);
                            this.setNamespace((SBase)listOfTextGlyph, namespaceURI);
                            this.setNamespace((SBase)textGlyph, namespaceURI);
                            listOfTextGlyph.add((SBase)textGlyph);
                            this.groupList = LayoutList.listOfTextGlyphs;
                            return textGlyph;
                        }
                        if (elementName.equals("speciesGlyph") && this.groupList.equals((Object)LayoutList.listOfSpeciesGlyphs)) {
                            ListOf listOfSpeciesGlyph = (ListOf)contextObject;
                            SpeciesGlyph speciesGlyph = (SpeciesGlyph)((Object)newContextObject);
                            this.setNamespace((SBase)listOfSpeciesGlyph, namespaceURI);
                            this.setNamespace((SBase)speciesGlyph, namespaceURI);
                            listOfSpeciesGlyph.add((SBase)speciesGlyph);
                            this.groupList = LayoutList.listOfSpeciesGlyphs;
                            return speciesGlyph;
                        }
                        if (elementName.equals("reactionGlyph") && this.groupList.equals((Object)LayoutList.listOfReactionGlyphs)) {
                            ListOf listOfReactionGlyph = (ListOf)contextObject;
                            ReactionGlyph reactionGlyph = (ReactionGlyph)((Object)newContextObject);
                            this.setNamespace((SBase)listOfReactionGlyph, namespaceURI);
                            this.setNamespace((SBase)reactionGlyph, namespaceURI);
                            listOfReactionGlyph.add((SBase)reactionGlyph);
                            this.groupList = LayoutList.listOfReactionGlyphs;
                            return reactionGlyph;
                        }
                        if (elementName.equals("boundingBox") && this.groupList.equals((Object)LayoutList.listOfCompartmentGlyphs)) {
                            CompartmentGlyph compartmentGlyph = (CompartmentGlyph)((Object)contextObject);
                            BoundingBox boundingBox2 = (BoundingBox)((Object)newContextObject);
                            this.setNamespace((SBase)boundingBox2, namespaceURI);
                            compartmentGlyph.setBoundingBox(boundingBox2);
                            return boundingBox2;
                        }
                    } else if (listOf.getParentSBMLObject() instanceof ReactionGlyph) {
                        if (elementName.equals("speciesReferenceGlyph") && this.groupList.equals((Object)LayoutList.listOfSpeciesReferenceGlyphs)) {
                            SpeciesReferenceGlyph speciesReferenceGlyph = (SpeciesReferenceGlyph)((Object)newContextObject);
                            this.setNamespace((SBase)speciesReferenceGlyph, namespaceURI);
                            ListOf listOfSpeciesReferenceGlyph = (ListOf)contextObject;
                            listOfSpeciesReferenceGlyph.add((SBase)speciesReferenceGlyph);
                            return speciesReferenceGlyph;
                        }
                    } else {
                        CubicBezier lineSegment;
                        ListOf listOfLineSegment;
                        if (elementName.equals("curveSegment") && this.groupList.equals((Object)LayoutList.listOfCurveSegments)) {
                            listOfLineSegment = (ListOf)contextObject;
                            lineSegment = (CubicBezier)((Object)newContextObject);
                            this.setNamespace((SBase)lineSegment, namespaceURI);
                            listOfLineSegment.add((SBase)lineSegment);
                            this.groupList = LayoutList.listOfCurveSegments;
                            return lineSegment;
                        }
                        if (listOf.getParentSBMLObject() instanceof Curve && (elementName.equals("curveSegment") || elementName.equals("cubicBezier") || elementName.equals("lineSegment"))) {
                            listOfLineSegment = (ListOf)contextObject;
                            lineSegment = (CubicBezier)((Object)newContextObject);
                            this.setNamespace((SBase)lineSegment, namespaceURI);
                            listOfLineSegment.add((SBase)lineSegment);
                            return lineSegment;
                        }
                    }
                } else if (contextObject instanceof Layout) {
                    Layout layout = (Layout)((Object)contextObject);
                    this.groupList = LayoutList.listOfLayouts;
                    if (elementName.equals("dimensions") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                        dimensions = (Dimensions)((Object)newContextObject);
                        this.setNamespace((SBase)dimensions, namespaceURI);
                        layout.setDimensions(dimensions);
                        return dimensions;
                    }
                    if (elementName.equals("listOfCompartmentGlyphs") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                        ListOf listOfCompartmentGlyphs = (ListOf)newContextObject;
                        listOfCompartmentGlyphs.setSBaseListType(ListOf.Type.other);
                        layout.setListOfCompartmentGlyphs((ListOf<CompartmentGlyph>)listOfCompartmentGlyphs);
                        this.groupList = LayoutList.listOfCompartmentGlyphs;
                        return listOfCompartmentGlyphs;
                    }
                    if (elementName.equals("listOfSpeciesGlyphs") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                        ListOf listofSpeciesGlyph = (ListOf)newContextObject;
                        listofSpeciesGlyph.setSBaseListType(ListOf.Type.other);
                        layout.setListOfSpeciesGlyphs((ListOf<SpeciesGlyph>)listofSpeciesGlyph);
                        this.groupList = LayoutList.listOfSpeciesGlyphs;
                        return listofSpeciesGlyph;
                    }
                    if (elementName.equals("listOfReactionGlyphs") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                        ListOf listOfReactionGlyphs = (ListOf)newContextObject;
                        listOfReactionGlyphs.setSBaseListType(ListOf.Type.other);
                        layout.setListOfReactionGlyphs((ListOf<ReactionGlyph>)listOfReactionGlyphs);
                        this.groupList = LayoutList.listOfReactionGlyphs;
                        return listOfReactionGlyphs;
                    }
                    if (elementName.equals("listOfTextGlyphs") && this.groupList.equals((Object)LayoutList.listOfLayouts)) {
                        ListOf listOfTextGlyphs = (ListOf)newContextObject;
                        listOfTextGlyphs.setSBaseListType(ListOf.Type.other);
                        layout.setListOfTextGlyphs((ListOf<TextGlyph>)listOfTextGlyphs);
                        this.groupList = LayoutList.listOfTextGlyphs;
                        return listOfTextGlyphs;
                    }
                } else if (contextObject instanceof ReactionGlyph) {
                    ReactionGlyph reactionGlyph = (ReactionGlyph)((Object)contextObject);
                    if (elementName.equals("curve") && this.groupList.equals((Object)LayoutList.listOfReactionGlyphs)) {
                        curve = (Curve)((Object)newContextObject);
                        this.setNamespace((SBase)curve, namespaceURI);
                        reactionGlyph.setCurve(curve);
                        return curve;
                    }
                    if (elementName.equals("listOfSpeciesReferenceGlyphs") && this.groupList.equals((Object)LayoutList.listOfReactionGlyphs)) {
                        ListOf listOfSpeciesReferenceGlyphs = (ListOf)newContextObject;
                        listOfSpeciesReferenceGlyphs.setSBaseListType(ListOf.Type.other);
                        reactionGlyph.setListOfSpeciesReferencesGlyph((ListOf<SpeciesReferenceGlyph>)listOfSpeciesReferenceGlyphs);
                        this.groupList = LayoutList.listOfSpeciesReferenceGlyphs;
                        return listOfSpeciesReferenceGlyphs;
                    }
                    if (elementName.equals("boundingBox")) {
                        boundingBox = (BoundingBox)((Object)newContextObject);
                        this.setNamespace((SBase)boundingBox, namespaceURI);
                        reactionGlyph.setBoundingBox(boundingBox);
                        return boundingBox;
                    }
                } else if (contextObject instanceof SpeciesGlyph) {
                    SpeciesGlyph speciesGlyph = (SpeciesGlyph)((Object)contextObject);
                    if (elementName.equals("boundingBox")) {
                        boundingBox = (BoundingBox)((Object)newContextObject);
                        this.setNamespace((SBase)boundingBox, namespaceURI);
                        speciesGlyph.setBoundingBox(boundingBox);
                        return boundingBox;
                    }
                } else if (contextObject instanceof CompartmentGlyph) {
                    if (elementName.equals("boundingBox") && this.groupList.equals((Object)LayoutList.listOfCompartmentGlyphs)) {
                        CompartmentGlyph compartmentGlyph = (CompartmentGlyph)((Object)contextObject);
                        boundingBox = (BoundingBox)((Object)newContextObject);
                        this.setNamespace((SBase)boundingBox, namespaceURI);
                        compartmentGlyph.setBoundingBox(boundingBox);
                        return boundingBox;
                    }
                } else if (contextObject instanceof TextGlyph) {
                    if (elementName.equals("boundingBox") && this.groupList.equals((Object)LayoutList.listOfTextGlyphs)) {
                        TextGlyph textGlyph = (TextGlyph)((Object)contextObject);
                        boundingBox = (BoundingBox)((Object)newContextObject);
                        this.setNamespace((SBase)boundingBox, namespaceURI);
                        textGlyph.setBoundingBox(boundingBox);
                        return boundingBox;
                    }
                } else if (contextObject instanceof Curve) {
                    ListOf listOfCurveSegments;
                    Curve curve2;
                    if (elementName.equals("listOfCurveSegments") && this.groupList.equals((Object)LayoutList.listOfReactionGlyphs)) {
                        curve2 = (Curve)((Object)contextObject);
                        listOfCurveSegments = (ListOf)newContextObject;
                        listOfCurveSegments.setSBaseListType(ListOf.Type.other);
                        this.setNamespace((SBase)listOfCurveSegments, namespaceURI);
                        curve2.setListOfCurveSegments((ListOf<CurveSegment>)listOfCurveSegments);
                        this.groupList = LayoutList.listOfReactionGlyphs;
                        return listOfCurveSegments;
                    }
                    if (elementName.equals("listOfCurveSegments") && this.groupList.equals((Object)LayoutList.listOfSpeciesReferenceGlyphs)) {
                        curve2 = (Curve)((Object)contextObject);
                        listOfCurveSegments = (ListOf)newContextObject;
                        listOfCurveSegments.setSBaseListType(ListOf.Type.other);
                        this.setNamespace((SBase)listOfCurveSegments, namespaceURI);
                        curve2.setListOfCurveSegments((ListOf<CurveSegment>)listOfCurveSegments);
                        this.groupList = LayoutList.listOfSpeciesReferenceGlyphs;
                        return listOfCurveSegments;
                    }
                } else if (contextObject instanceof BoundingBox) {
                    BoundingBox boundingBox3 = (BoundingBox)((Object)contextObject);
                    if (elementName.equals("position")) {
                        Point point = (Point)((Object)newContextObject);
                        this.setNamespace((SBase)point, namespaceURI);
                        boundingBox3.setPosition(point);
                        return point;
                    }
                    if (elementName.equals("dimensions")) {
                        dimensions = (Dimensions)((Object)newContextObject);
                        this.setNamespace((SBase)dimensions, namespaceURI);
                        boundingBox3.setDimensions(dimensions);
                        return dimensions;
                    }
                } else if (contextObject instanceof CurveSegment) {
                    CurveSegment lineSegment;
                    if (elementName.equals("start")) {
                        lineSegment = (CurveSegment)((Object)contextObject);
                        Point start = (Point)((Object)newContextObject);
                        lineSegment.setStart(start);
                        this.setNamespace((SBase)start, namespaceURI);
                        return start;
                    }
                    if (elementName.equals("end")) {
                        lineSegment = (CurveSegment)((Object)contextObject);
                        Point end = (Point)((Object)newContextObject);
                        lineSegment.setEnd(end);
                        this.setNamespace((SBase)end, namespaceURI);
                        return end;
                    }
                    if (elementName.equals("basePoint1")) {
                        lineSegment = (CubicBezier)((Object)contextObject);
                        Point basePoint1 = (Point)((Object)newContextObject);
                        ((CubicBezier)lineSegment).setBasePoint1(basePoint1);
                        this.setNamespace((SBase)basePoint1, namespaceURI);
                        return basePoint1;
                    }
                    if (elementName.equals("basePoint2")) {
                        lineSegment = (CubicBezier)((Object)contextObject);
                        Point basePoint2 = (Point)((Object)newContextObject);
                        ((CubicBezier)lineSegment).setBasePoint2(basePoint2);
                        this.setNamespace((SBase)basePoint2, namespaceURI);
                        return basePoint2;
                    }
                } else if (contextObject instanceof SpeciesReferenceGlyph && this.groupList.equals((Object)LayoutList.listOfSpeciesReferenceGlyphs)) {
                    SpeciesReferenceGlyph speciesReferenceGlyph = (SpeciesReferenceGlyph)((Object)contextObject);
                    if (elementName.equals("curve")) {
                        curve = (Curve)((Object)newContextObject);
                        speciesReferenceGlyph.setCurve(curve);
                        this.setNamespace((SBase)curve, namespaceURI);
                        return curve;
                    }
                    if (elementName.equals("boundingBox")) {
                        boundingBox = (BoundingBox)((Object)newContextObject);
                        this.setNamespace((SBase)boundingBox, namespaceURI);
                        speciesReferenceGlyph.setBoundingBox(boundingBox);
                        return boundingBox;
                    }
                } else {
                    this.log4jLogger.info((Object)("Tag " + elementName + " could not be recognized."));
                    this.log4jLogger.info((Object)("contextObject: " + contextObject.toString()));
                    this.log4jLogger.info((Object)("newContextObject: " + newContextObject.toString()));
                }
            }
            catch (Exception e) {
                this.log4jLogger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return contextObject;
    }

    private void setNamespace(SBase sbase, String namespace) {
        ((AbstractSBase)sbase).setNamespace(namespace);
    }

    public boolean processEndElement(String elementName, String prefix, boolean isNested, Object contextObject) {
        if (this.log4jLogger.isDebugEnabled()) {
            this.log4jLogger.debug((Object)("contextObject: " + contextObject.getClass().getName()));
            this.log4jLogger.debug((Object)("elementName: " + elementName));
        }
        if (elementName.equals("listOfLayouts") || elementName.equals("listOfSpeciesGlyphs") || elementName.equals("listOfReactionGlyphs") || elementName.equals("listOfCompartmentGlyphs") || elementName.equals("listOfTextGlyphs")) {
            this.groupList = LayoutList.none;
            this.log4jLogger.debug((Object)"set listType to: none");
        } else if (elementName.equals("listOfSpeciesReferenceGlyphs")) {
            this.groupList = LayoutList.listOfReactionGlyphs;
            this.log4jLogger.debug((Object)"set listType to: listOfReactionGlyphs");
        }
        return true;
    }

    private void setLevelAndVersionFor(Object newContextObject, SBase parent) {
        if (newContextObject instanceof SBase) {
            SBase sb = (SBase)newContextObject;
            sb.setLevel(parent.getLevel());
            sb.setVersion(parent.getVersion());
        }
    }

    public List<String> getNamespaces() {
        return LayoutConstants.namespaces_L2;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null && sbase instanceof Model) {
            LayoutModelPlugin modelPlugin = new LayoutModelPlugin((Model)sbase);
            return modelPlugin;
        }
        return null;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level < 3) {
            return namespaceURI;
        }
        throw new IllegalArgumentException("");
    }

    public List<String> getPackageNamespaces() {
        return this.getNamespaces();
    }

    public String getPackageName() {
        return "layout_L2";
    }

    public boolean isRequired() {
        return false;
    }

    static enum LayoutList {
        listOfLayouts,
        listOfSpeciesGlyphs,
        listOfReactionGlyphs,
        listOfTextGlyphs,
        listOfCompartmentGlyphs,
        none,
        listOfCurveSegments,
        listOfSpeciesReferenceGlyphs;

    }
}

