/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.AbstractSBasePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutConstants;

public class LayoutModelPlugin
extends AbstractSBasePlugin {
    private static final long serialVersionUID = 4507170457817702658L;
    protected ListOf<Layout> listOfLayouts;

    public LayoutModelPlugin(LayoutModelPlugin elm) {
        super((SBasePlugin)elm);
        if (elm.isSetListOfLayouts()) {
            this.setListOfLayouts((ListOf<Layout>)elm.listOfLayouts.clone());
        }
    }

    public LayoutModelPlugin(Model model) {
        super((SBase)model);
        this.setPackageVersion(-1);
        this.createListOfLayout();
    }

    public void add(Layout layout) {
        this.addLayout(layout);
    }

    public void addLayout(Layout layout) {
        if (layout != null) {
            this.getListOfLayouts().add((SBase)layout);
        }
    }

    public Layout createLayout() {
        return this.createLayout(null);
    }

    public Layout createLayout(String id) {
        Layout layout = new Layout();
        layout.setId(id);
        this.addLayout(layout);
        return layout;
    }

    private ListOf<Layout> createListOfLayout() {
        this.listOfLayouts = new ListOf();
        this.listOfLayouts.setPackageVersion(-1);
        this.listOfLayouts.setPackageName(null);
        this.listOfLayouts.setPackageName("layout");
        this.listOfLayouts.setSBaseListType(ListOf.Type.other);
        if (this.isSetExtendedSBase()) {
            this.getExtendedSBase().registerChild(this.listOfLayouts);
        }
        return this.listOfLayouts;
    }

    public int hashCode() {
        int prime = 2887;
        int result = super.hashCode();
        result = 2887 * result + (this.listOfLayouts == null ? 0 : this.listOfLayouts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        LayoutModelPlugin other = (LayoutModelPlugin)((Object)obj);
        return !(this.listOfLayouts == null ? other.listOfLayouts != null : !this.listOfLayouts.equals(other.listOfLayouts));
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public SBase getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int pos = 0;
        if (this.isSetListOfLayouts()) {
            if (pos == index) {
                return this.getListOfLayouts();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, pos));
    }

    public int getChildCount() {
        int count = 0;
        if (this.isSetListOfLayouts()) {
            ++count;
        }
        return count;
    }

    public Layout getLayout(int i) {
        return (Layout)this.listOfLayouts.get(i);
    }

    public int getLayoutCount() {
        return this.isSetListOfLayouts() ? this.listOfLayouts.size() : 0;
    }

    public ListOf<Layout> getListOfLayouts() {
        if (this.listOfLayouts == null) {
            this.createListOfLayout();
        }
        return this.listOfLayouts;
    }

    public Model getModel() {
        if (this.isSetExtendedSBase()) {
            return (Model)this.extendedSBase;
        }
        return null;
    }

    public int getNumLayouts() {
        return this.getLayoutCount();
    }

    public SBMLDocument getParent() {
        if (this.isSetExtendedSBase()) {
            return (SBMLDocument)this.getExtendedSBase().getParent();
        }
        return null;
    }

    public SBMLDocument getParentSBMLObject() {
        return this.getParent();
    }

    public boolean isSetListOfLayouts() {
        return this.listOfLayouts != null && !this.listOfLayouts.isEmpty();
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        return false;
    }

    public void setListOfLayouts(ListOf<Layout> listOfLayouts) {
        this.unsetListOfLayouts();
        this.listOfLayouts = listOfLayouts;
        if (listOfLayouts != null) {
            listOfLayouts.setPackageVersion(-1);
            listOfLayouts.setPackageName(null);
            listOfLayouts.setPackageName("layout");
            listOfLayouts.setSBaseListType(ListOf.Type.other);
        }
        if (this.isSetExtendedSBase()) {
            this.getExtendedSBase().registerChild(listOfLayouts);
        }
    }

    public boolean unsetListOfLayouts() {
        if (this.listOfLayouts != null) {
            ListOf<Layout> oldListOfLayouts = this.listOfLayouts;
            this.listOfLayouts = null;
            oldListOfLayouts.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        return null;
    }

    public LayoutModelPlugin clone() {
        return new LayoutModelPlugin(this);
    }

    public String getElementNamespace() {
        return LayoutConstants.getNamespaceURI(this.getLevel(), this.getVersion());
    }

    public String getPackageName() {
        return "layout";
    }

    public String getPrefix() {
        return "layout";
    }

    public String getURI() {
        return this.getElementNamespace();
    }
}

