/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.util.Map;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;

public class TextGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = -2582985174711830815L;
    private String graphicalObject;
    private String text;

    public TextGlyph() {
        this.initDefaults();
    }

    public TextGlyph(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public TextGlyph(String id) {
        super(id);
        this.initDefaults();
    }

    public TextGlyph(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    public TextGlyph(TextGlyph textGlyph) {
        super(textGlyph);
        if (textGlyph.isSetGraphicalObject()) {
            this.setGraphicalObject(new String(textGlyph.getGraphicalObject()));
        }
        if (textGlyph.isSetText()) {
            this.setText(new String(textGlyph.getText()));
        }
    }

    @Override
    public TextGlyph clone() {
        return new TextGlyph(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            TextGlyph t = (TextGlyph)((Object)object);
            if ((equals &= t.isSetText() == this.isSetText()) && this.isSetText()) {
                equals &= t.getText().equals(this.getText());
            }
            if ((equals &= t.isSetGraphicalObject() == this.isSetGraphicalObject()) && this.isSetGraphicalObject()) {
                equals &= t.getGraphicalObject().equals(this.getGraphicalObject());
            }
        }
        return equals;
    }

    public String getGraphicalObject() {
        return this.graphicalObject;
    }

    public GraphicalObject getGraphicalObjectInstance() {
        Model model = this.getModel();
        return (GraphicalObject)(this.isSetGraphicalObject() && model != null ? model.findNamedSBase(this.getGraphicalObject()) : null);
    }

    public String getOriginOfText() {
        return this.getReference();
    }

    public NamedSBase getOriginOfTextInstance() {
        return this.getNamedSBaseInstance();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public int hashCode() {
        int prime = 967;
        int hashCode = super.hashCode();
        if (this.isSetText()) {
            hashCode += 967 * this.getText().hashCode();
        }
        if (this.isSetGraphicalObject()) {
            hashCode += 967 * this.getGraphicalObject().hashCode();
        }
        return hashCode;
    }

    public boolean isSetGraphicalObject() {
        return this.graphicalObject != null;
    }

    public boolean isSetGraphicalObjectInstance() {
        Model model = this.getModel();
        return this.isSetGraphicalObject() && model != null && model.findNamedSBase(this.getGraphicalObject()) != null;
    }

    public boolean isSetOriginOfText() {
        return this.isSetReference();
    }

    public boolean isSetText() {
        return this.text != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("graphicalObject")) {
                this.setGraphicalObject(value);
            } else if (attributeName.equals("text")) {
                this.setText(value);
            } else if (attributeName.equals("originOfText")) {
                this.setOriginOfText(value);
            } else {
                return false;
            }
            return true;
        }
        return isAttributeRead;
    }

    public void setGraphicalObject(GraphicalObject graphicalObject) {
        if (graphicalObject == null) {
            this.unsetGraphicalObject();
        } else {
            this.setGraphicalObject(graphicalObject.getId());
        }
    }

    public void unsetGraphicalObject() {
        this.setGraphicalObject((String)null);
    }

    public void setGraphicalObject(String graphicalObject) {
        String oldValue = this.graphicalObject;
        this.graphicalObject = graphicalObject;
        this.firePropertyChange("graphicalObject", oldValue, this.graphicalObject);
    }

    public void setOriginOfText(NamedSBase originOfText) {
        this.setNamedSBase(originOfText);
    }

    public void setOriginOfText(String originOfText) {
        this.setReference(originOfText);
    }

    public void setText(String text) {
        String oldText = this.text;
        this.text = text;
        this.firePropertyChange("text", oldText, this.text);
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetGraphicalObject()) {
            attributes.put("layout:graphicalObject", this.graphicalObject);
        }
        if (this.isSetText()) {
            attributes.put("layout:text", this.text);
        }
        if (this.isSetOriginOfText()) {
            attributes.put("layout:originOfText", this.getOriginOfText());
        }
        return attributes;
    }
}

