/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.util.ResourceManager;

public class BoundingBox
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -6371039558611201798L;
    private static final transient Logger logger = Logger.getLogger(BoundingBox.class);
    private Dimensions dimensions;
    private Point position;

    public BoundingBox() {
        this.init();
    }

    public BoundingBox(BoundingBox boundingBox) {
        super((AbstractNamedSBase)boundingBox);
        if (boundingBox.isSetDimensions()) {
            this.setDimensions(boundingBox.getDimensions().clone());
        }
        if (boundingBox.isSetPosition()) {
            this.setPosition(boundingBox.getPosition().clone());
        }
    }

    public BoundingBox(int level, int version) {
        super(level, version);
        this.init();
    }

    public BoundingBox(String id) {
        super(id);
        this.init();
    }

    public BoundingBox(String id, int level, int version) {
        super(id, level, version);
        this.init();
    }

    public BoundingBox clone() {
        return new BoundingBox(this);
    }

    public Dimensions createDimensions() {
        Dimensions d = new Dimensions(this.getLevel(), this.getVersion());
        this.setDimensions(d);
        return d;
    }

    public Dimensions createDimensions(double width, double height, double depth) {
        Dimensions d = new Dimensions(width, height, depth, this.getLevel(), this.getVersion());
        this.setDimensions(d);
        return d;
    }

    public Point createPosition() {
        Point p = new Point(this.getLevel(), this.getVersion());
        this.setPosition(p);
        return p;
    }

    public Point createPosition(double x, double y, double z) {
        Point p = new Point(x, y, z, this.getLevel(), this.getVersion());
        this.setPosition(p);
        return p;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            BoundingBox bb = (BoundingBox)((Object)object);
            if ((equals &= bb.isSetPosition() == this.isSetPosition()) && this.isSetPosition()) {
                equals &= bb.getPosition().equals((Object)this.getPosition());
            }
            if ((equals &= bb.isSetDimensions() == this.isSetDimensions()) && this.isSetDimensions()) {
                equals &= bb.getDimensions().equals((Object)this.getDimensions());
            }
        }
        return equals;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetPosition()) {
            if (pos == index) {
                return this.getPosition();
            }
            ++pos;
        }
        if (this.isSetDimensions()) {
            if (pos == index) {
                return this.getDimensions();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetPosition()) {
            ++count;
        }
        if (this.isSetDimensions()) {
            ++count;
        }
        return count;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public Point getPosition() {
        return this.position;
    }

    public int hashCode() {
        int prime = 7;
        int hashCode = super.hashCode();
        return hashCode += 7 * this.getId().hashCode();
    }

    private void init() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetDimensions() {
        return this.dimensions != null;
    }

    public boolean isSetPosition() {
        return this.position != null;
    }

    public void setDimensions(Dimensions dimensions) {
        if (this.dimensions != null) {
            Dimensions oldValue = this.dimensions;
            this.dimensions = null;
            oldValue.fireNodeRemovedEvent();
        }
        this.dimensions = dimensions;
        this.registerChild((SBase)this.dimensions);
    }

    public void setPosition(Point point) {
        Point oldValue = this.position;
        this.position = point;
        if (oldValue != null) {
            oldValue.fireNodeRemovedEvent();
        }
        if (this.position != null) {
            this.position.setElementName("position");
        }
        this.registerChild((SBase)this.position);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("layout:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            logger.warn((Object)MessageFormat.format(ResourceManager.getBundle((String)"org.sbml.jsbml.resources.cfg.Messages").getString("UNDEFINED_ATTRIBUTE"), "name", this.getLevel(), this.getVersion(), this.getElementName()));
        }
        return attributes;
    }
}

