/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.GeneralGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.NamedSBaseReferenceFilter;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.util.filters.NameFilter;

public class Layout
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = 8866612784809904674L;
    private Dimensions dimensions;
    private ListOf<GraphicalObject> listOfAdditionalGraphicalObjects;
    private ListOf<CompartmentGlyph> listOfCompartmentGlyphs;
    private ListOf<ReactionGlyph> listOfReactionGlyphs;
    private ListOf<SpeciesGlyph> listOfSpeciesGlyphs;
    private ListOf<TextGlyph> listOfTextGlyphs;

    public Layout() {
        this.initDefault();
    }

    public Layout(int level, int version) {
        super(level, version);
        this.initDefault();
    }

    public Layout(Layout layout) {
        super((AbstractNamedSBase)layout);
        if (layout.listOfAdditionalGraphicalObjects != null) {
            this.setListOfAdditionalGraphicalObjects((ListOf<GraphicalObject>)layout.getListOfAdditionalGraphicalObjects().clone());
        }
        if (layout.dimensions != null) {
            this.setDimensions(layout.getDimensions().clone());
        }
        if (layout.listOfCompartmentGlyphs != null) {
            this.setListOfCompartmentGlyphs((ListOf<CompartmentGlyph>)layout.getListOfCompartmentGlyphs().clone());
        }
        if (layout.listOfReactionGlyphs != null) {
            this.setListOfReactionGlyphs((ListOf<ReactionGlyph>)layout.getListOfReactionGlyphs().clone());
        }
        if (layout.listOfSpeciesGlyphs != null) {
            this.setListOfSpeciesGlyphs((ListOf<SpeciesGlyph>)layout.getListOfSpeciesGlyphs().clone());
        }
        if (layout.listOfTextGlyphs != null) {
            this.setListOfTextGlyphs((ListOf<TextGlyph>)layout.getListOfTextGlyphs().clone());
        }
    }

    public Layout(String id, int level, int version) {
        super(id, level, version);
        this.initDefault();
    }

    public void addAdditionalGraphicalObject(GraphicalObject object) {
        this.addGraphicalObject(object);
    }

    public boolean addCompartmentGlyph(CompartmentGlyph compartmentGlyph) {
        return this.getListOfCompartmentGlyphs().add((SBase)compartmentGlyph);
    }

    public void addGeneralGlyph(GeneralGlyph object) {
        if (object != null) {
            this.getListOfAdditionalGraphicalObjects().add((SBase)object);
        }
    }

    public void addGraphicalObject(GraphicalObject object) {
        if (object != null) {
            this.getListOfAdditionalGraphicalObjects().add((SBase)object);
        }
    }

    public void addReactionGlyph(ReactionGlyph reactionGlyph) {
        if (reactionGlyph != null) {
            this.getListOfReactionGlyphs().add((SBase)reactionGlyph);
        }
    }

    public void addSpeciesGlyph(SpeciesGlyph speciesGlyph) {
        if (speciesGlyph != null) {
            this.getListOfSpeciesGlyphs().add((SBase)speciesGlyph);
        }
    }

    public void addTextGlyph(TextGlyph TextGlyph2) {
        if (TextGlyph2 != null) {
            this.getListOfTextGlyphs().add((SBase)TextGlyph2);
        }
    }

    public Layout clone() {
        return new Layout(this);
    }

    public boolean containsGlyph(Compartment compartment) {
        return this.containsGlyph(this.listOfCompartmentGlyphs, (NamedSBase)compartment);
    }

    private <T extends AbstractReferenceGlyph> boolean containsGlyph(ListOf<T> listOfGlyphs, NamedSBase nsb) {
        if (nsb != null && listOfGlyphs != null && !listOfGlyphs.isEmpty()) {
            NamedSBaseReferenceFilter filter = new NamedSBaseReferenceFilter(nsb.getId());
            filter.setFilterForReference(true);
            return listOfGlyphs.firstHit((Filter)filter) != null;
        }
        return false;
    }

    public boolean containsGlyph(Reaction reaction) {
        return this.containsGlyph(this.listOfReactionGlyphs, (NamedSBase)reaction);
    }

    public boolean containsGlyph(Species species) {
        return this.containsGlyph(this.listOfSpeciesGlyphs, (NamedSBase)species);
    }

    public CompartmentGlyph createCompartmentGlyph(String id) {
        return this.createCompartmentGlyph(id, null);
    }

    public CompartmentGlyph createCompartmentGlyph(String id, String compartment) {
        CompartmentGlyph glyph = new CompartmentGlyph(id, this.getLevel(), this.getVersion());
        glyph.setCompartment(compartment);
        this.addCompartmentGlyph(glyph);
        return glyph;
    }

    public Dimensions createDimensions(double width, double height, double depth) {
        return this.createDimensions(null, width, height, depth);
    }

    public Dimensions createDimensions(String id, double width, double height, double depth) {
        Dimensions d = new Dimensions(id, this.getLevel(), this.getVersion());
        d.setWidth(width);
        d.setHeight(height);
        d.setDepth(depth);
        this.setDimensions(d);
        return d;
    }

    public GeneralGlyph createGeneralGlyph(String id) {
        return this.createGeneralGlyph(id, null);
    }

    public GeneralGlyph createGeneralGlyph(String id, String reference) {
        GeneralGlyph glyph = new GeneralGlyph(id, this.getLevel(), this.getVersion());
        glyph.setReference(reference);
        this.addGeneralGlyph(glyph);
        return glyph;
    }

    public ReactionGlyph createReactionGlyph(String id) {
        return this.createReactionGlyph(id, null);
    }

    public ReactionGlyph createReactionGlyph(String id, String reaction) {
        ReactionGlyph glyph = new ReactionGlyph(id, this.getLevel(), this.getVersion());
        glyph.setReaction(reaction);
        this.addReactionGlyph(glyph);
        return glyph;
    }

    public SpeciesGlyph createSpeciesGlyph(String id) {
        return this.createSpeciesGlyph(id, null);
    }

    public SpeciesGlyph createSpeciesGlyph(String id, String species) {
        SpeciesGlyph glyph = new SpeciesGlyph(id, this.getLevel(), this.getVersion());
        glyph.setSpecies(species);
        this.addSpeciesGlyph(glyph);
        return glyph;
    }

    public TextGlyph createTextGlyph(String id) {
        return this.createTextGlyph(id, null);
    }

    public TextGlyph createTextGlyph(String id, String text) {
        TextGlyph glyph = new TextGlyph(id, this.getLevel(), this.getVersion());
        glyph.setText(text);
        this.addTextGlyph(glyph);
        return glyph;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            Layout layout = (Layout)((Object)object);
            if ((equals &= layout.isSetDimensions() == this.isSetDimensions()) && this.isSetDimensions()) {
                equals &= layout.getDimensions().equals((Object)this.getDimensions());
            }
            if ((equals &= layout.isSetListOfAdditionalGraphicalObjects() == this.isSetListOfAdditionalGraphicalObjects()) && this.isSetListOfAdditionalGraphicalObjects()) {
                equals &= layout.getListOfAdditionalGraphicalObjects().equals(this.getListOfAdditionalGraphicalObjects());
            }
            if (equals && this.isSetListOfCompartmentGlyphs()) {
                equals &= layout.getListOfCompartmentGlyphs().equals(this.getListOfCompartmentGlyphs());
            }
            if (equals && this.isSetListOfReactionGlyphs()) {
                equals &= layout.getListOfReactionGlyphs().equals(this.getListOfReactionGlyphs());
            }
            if (equals && this.isSetListOfSpeciesGlyphs()) {
                equals &= layout.getListOfSpeciesGlyphs().equals(this.getListOfSpeciesGlyphs());
            }
            if (equals && this.isSetListOfTextGlyphs()) {
                equals &= layout.getListOfTextGlyphs().equals(this.getListOfTextGlyphs());
            }
        }
        return equals;
    }

    public List<CompartmentGlyph> findCompartmentGlyphs(String compartmentID) {
        return this.findGlyphs(this.listOfCompartmentGlyphs, compartmentID);
    }

    private <T> List<T> findGlyphs(ListOf<? extends T> listOfGlyphs, String id) {
        if (this.isSetListOfReactionGlyphs() && listOfGlyphs != null && !listOfGlyphs.isEmpty()) {
            NamedSBaseReferenceFilter filter = new NamedSBaseReferenceFilter(id);
            filter.setFilterForReference(true);
            return this.listOfReactionGlyphs.filter((Filter)filter);
        }
        return new ArrayList(0);
    }

    public List<ReactionGlyph> findReactionGlyphs(String reactionID) {
        return this.findGlyphs(this.listOfReactionGlyphs, reactionID);
    }

    public List<SpeciesGlyph> findSpeciesGlyphs(String speciesID) {
        return this.findGlyphs(this.listOfSpeciesGlyphs, speciesID);
    }

    public List<TextGlyph> findTextGlyphs(String id) {
        return this.findGlyphs(this.listOfTextGlyphs, id);
    }

    public GraphicalObject getAdditionalGraphicalObject(int i) {
        if (this.isSetListOfAdditionalGraphicalObjects()) {
            return (GraphicalObject)this.listOfAdditionalGraphicalObjects.get(i);
        }
        return null;
    }

    public int getAdditionalGraphicalObjectCount() {
        return this.isSetListOfAdditionalGraphicalObjects() ? this.listOfAdditionalGraphicalObjects.size() : 0;
    }

    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetDimensions()) {
            if (index == pos) {
                return this.getDimensions();
            }
            ++pos;
        }
        if (this.isSetAddGraphicalObjects()) {
            if (index == pos) {
                return this.getListOfAdditionalGraphicalObjects();
            }
            ++pos;
        }
        if (this.isSetListOfCompartmentGlyphs()) {
            if (index == pos) {
                return this.getListOfCompartmentGlyphs();
            }
            ++pos;
        }
        if (this.isSetListOfSpeciesGlyphs()) {
            if (index == pos) {
                return this.getListOfSpeciesGlyphs();
            }
            ++pos;
        }
        if (this.isSetListOfReactionGlyphs()) {
            if (index == pos) {
                return this.getListOfReactionGlyphs();
            }
            ++pos;
        }
        if (this.isSetListOfTextGlyphs() && index == pos) {
            return this.getListOfTextGlyphs();
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }

    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetDimensions()) {
            ++count;
        }
        if (this.isSetListOfCompartmentGlyphs()) {
            ++count;
        }
        if (this.isSetListOfSpeciesGlyphs()) {
            ++count;
        }
        if (this.isSetListOfReactionGlyphs()) {
            ++count;
        }
        if (this.isSetListOfTextGlyphs()) {
            ++count;
        }
        if (this.isSetAddGraphicalObjects()) {
            ++count;
        }
        return count;
    }

    public CompartmentGlyph getCompartmentGlyph(int i) {
        if (!this.isSetListOfCompartmentGlyphs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CompartmentGlyph)this.getListOfCompartmentGlyphs().get(i);
    }

    public CompartmentGlyph getCompartmentGlyph(String id) {
        if (this.isSetListOfCompartmentGlyphs()) {
            return (CompartmentGlyph)this.getListOfCompartmentGlyphs().firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getCompartmentGlyphCount() {
        return this.isSetListOfCompartmentGlyphs() ? this.listOfCompartmentGlyphs.size() : 0;
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public ListOf<GraphicalObject> getListOfAdditionalGraphicalObjects() {
        if (!this.isSetListOfAdditionalGraphicalObjects()) {
            this.listOfAdditionalGraphicalObjects = new ListOf();
            this.listOfAdditionalGraphicalObjects.setSBaseListType(ListOf.Type.other);
            this.listOfAdditionalGraphicalObjects.setPackageVersion(-1);
            this.listOfAdditionalGraphicalObjects.setPackageName(null);
            this.listOfAdditionalGraphicalObjects.setPackageName("layout");
            this.listOfAdditionalGraphicalObjects.setOtherListName("listOfAdditionalGraphicalObjects");
            this.registerChild((SBase)this.listOfAdditionalGraphicalObjects);
        }
        return this.listOfAdditionalGraphicalObjects;
    }

    public ListOf<CompartmentGlyph> getListOfCompartmentGlyphs() {
        if (!this.isSetListOfCompartmentGlyphs()) {
            this.listOfCompartmentGlyphs = ListOf.newInstance((SBase)this, CompartmentGlyph.class);
            this.listOfCompartmentGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfCompartmentGlyphs.setPackageVersion(-1);
            this.listOfCompartmentGlyphs.setPackageName(null);
            this.listOfCompartmentGlyphs.setPackageName("layout");
            this.listOfCompartmentGlyphs.setOtherListName("listOfCompartmentGlyphs");
            this.registerChild((SBase)this.listOfCompartmentGlyphs);
        }
        return this.listOfCompartmentGlyphs;
    }

    public ListOf<ReactionGlyph> getListOfReactionGlyphs() {
        if (!this.isSetListOfReactionGlyphs()) {
            this.listOfReactionGlyphs = ListOf.newInstance((SBase)this, ReactionGlyph.class);
            this.listOfReactionGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfReactionGlyphs.setPackageVersion(-1);
            this.listOfReactionGlyphs.setPackageName(null);
            this.listOfReactionGlyphs.setPackageName("layout");
            this.listOfReactionGlyphs.setOtherListName("listOfReactionGlyphs");
            this.registerChild((SBase)this.listOfReactionGlyphs);
        }
        return this.listOfReactionGlyphs;
    }

    public ListOf<SpeciesGlyph> getListOfSpeciesGlyphs() {
        if (!this.isSetListOfSpeciesGlyphs()) {
            this.listOfSpeciesGlyphs = ListOf.newInstance((SBase)this, SpeciesGlyph.class);
            this.listOfSpeciesGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfSpeciesGlyphs.setPackageVersion(-1);
            this.listOfSpeciesGlyphs.setPackageName(null);
            this.listOfSpeciesGlyphs.setPackageName("layout");
            this.listOfSpeciesGlyphs.setOtherListName("listOfSpeciesGlyphs");
            this.registerChild((SBase)this.listOfSpeciesGlyphs);
        }
        return this.listOfSpeciesGlyphs;
    }

    public ListOf<TextGlyph> getListOfTextGlyphs() {
        if (!this.isSetListOfTextGlyphs()) {
            this.listOfTextGlyphs = ListOf.newInstance((SBase)this, TextGlyph.class);
            this.listOfTextGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfTextGlyphs.setPackageVersion(-1);
            this.listOfTextGlyphs.setPackageName(null);
            this.listOfTextGlyphs.setPackageName("layout");
            this.listOfTextGlyphs.setOtherListName("listOfTextGlyphs");
            this.registerChild((SBase)this.listOfTextGlyphs);
        }
        return this.listOfTextGlyphs;
    }

    public int getNumCompartmentGlyphs() {
        return this.getCompartmentGlyphCount();
    }

    public int getNumReactionGlyphs() {
        return this.getReactionGlyphCount();
    }

    public int getNumSpeciesGlyphs() {
        return this.getSpeciesGlyphCount();
    }

    public int getNumTextGlyphs() {
        return this.getTextGlyphCount();
    }

    public ReactionGlyph getReactionGlyph(int i) {
        return (ReactionGlyph)this.getListOfReactionGlyphs().get(i);
    }

    public ReactionGlyph getReactionGlyph(String id) {
        if (this.isSetListOfReactionGlyphs()) {
            return (ReactionGlyph)this.listOfReactionGlyphs.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getReactionGlyphCount() {
        return this.isSetListOfReactionGlyphs() ? this.listOfReactionGlyphs.size() : 0;
    }

    public SpeciesGlyph getSpeciesGlyph(int i) {
        return (SpeciesGlyph)this.getListOfSpeciesGlyphs().get(i);
    }

    public SpeciesGlyph getSpeciesGlyph(String id) {
        if (this.isSetListOfSpeciesGlyphs()) {
            return (SpeciesGlyph)this.listOfSpeciesGlyphs.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getSpeciesGlyphCount() {
        return this.isSetListOfSpeciesGlyphs() ? this.listOfSpeciesGlyphs.size() : 0;
    }

    public TextGlyph getTextGlyph(int i) {
        return (TextGlyph)this.getListOfTextGlyphs().get(i);
    }

    public TextGlyph getTextGlyph(String id) {
        if (this.isSetListOfTextGlyphs()) {
            return (TextGlyph)this.listOfTextGlyphs.firstHit((Filter)new NameFilter(id));
        }
        return null;
    }

    public int getTextGlyphCount() {
        return this.isSetListOfTextGlyphs() ? this.listOfTextGlyphs.size() : 0;
    }

    public int hashCode() {
        int prime = 947;
        int hashCode = super.hashCode();
        if (this.isSetDimensions()) {
            hashCode += 947 * this.getDimensions().hashCode();
        }
        if (this.isSetListOfAdditionalGraphicalObjects()) {
            hashCode += 947 * this.getListOfAdditionalGraphicalObjects().hashCode();
        }
        if (this.isSetListOfCompartmentGlyphs()) {
            hashCode += 947 * this.getListOfCompartmentGlyphs().hashCode();
        }
        if (this.isSetListOfReactionGlyphs()) {
            hashCode += 947 * this.getListOfReactionGlyphs().hashCode();
        }
        if (this.isSetListOfSpeciesGlyphs()) {
            hashCode += 947 * this.getListOfSpeciesGlyphs().hashCode();
        }
        if (this.isSetListOfTextGlyphs()) {
            hashCode += 947 * this.getListOfTextGlyphs().hashCode();
        }
        return hashCode;
    }

    private void initDefault() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public boolean isIdMandatory() {
        return true;
    }

    public boolean isSetAddGraphicalObjects() {
        return this.listOfAdditionalGraphicalObjects != null && this.listOfAdditionalGraphicalObjects.size() > 0;
    }

    public boolean isSetDimensions() {
        return this.dimensions != null;
    }

    public boolean isSetListOfAdditionalGraphicalObjects() {
        return this.listOfAdditionalGraphicalObjects != null && this.listOfAdditionalGraphicalObjects.size() > 0;
    }

    public boolean isSetListOfCompartmentGlyphs() {
        return this.listOfCompartmentGlyphs != null && this.listOfCompartmentGlyphs.size() > 0;
    }

    public boolean isSetListOfReactionGlyphs() {
        return this.listOfReactionGlyphs != null && this.listOfReactionGlyphs.size() > 0;
    }

    public boolean isSetListOfSpeciesGlyphs() {
        return this.listOfSpeciesGlyphs != null && this.listOfSpeciesGlyphs.size() > 0;
    }

    public boolean isSetListOfTextGlyphs() {
        return this.listOfTextGlyphs != null && this.listOfTextGlyphs.size() > 0;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        return isAttributeRead;
    }

    public boolean removeCompartmentGlyph(CompartmentGlyph compartmentGlyph) {
        if (this.isSetListOfCompartmentGlyphs()) {
            return this.getListOfCompartmentGlyphs().remove((NamedSBase)compartmentGlyph);
        }
        return false;
    }

    public CompartmentGlyph removeCompartmentGlyph(int i) {
        if (!this.isSetListOfCompartmentGlyphs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (CompartmentGlyph)this.getListOfCompartmentGlyphs().remove(i);
    }

    public CompartmentGlyph removeCompartmentGlyph(String compartmentGlyphId) {
        if (this.isSetListOfCompartmentGlyphs()) {
            return (CompartmentGlyph)this.getListOfCompartmentGlyphs().remove(compartmentGlyphId);
        }
        return null;
    }

    public GeneralGlyph removeGeneralGlyph(GeneralGlyph toBeRemoved) {
        if (this.isSetListOfAdditionalGraphicalObjects() && this.getListOfAdditionalGraphicalObjects().contains((Object)toBeRemoved) && toBeRemoved.removeFromParent()) {
            return toBeRemoved;
        }
        return null;
    }

    public GeneralGlyph removeGeneralGlyph(int i) {
        if (!this.isSetListOfAdditionalGraphicalObjects()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (GeneralGlyph)this.getListOfAdditionalGraphicalObjects().remove(i);
    }

    public GeneralGlyph removeGeneralGlyph(String id) {
        if (this.isSetListOfAdditionalGraphicalObjects()) {
            return (GeneralGlyph)this.getListOfAdditionalGraphicalObjects().remove(id);
        }
        return null;
    }

    public ReactionGlyph removeReactionGlyph(int i) {
        if (!this.isSetListOfReactionGlyphs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (ReactionGlyph)this.getListOfReactionGlyphs().remove(i);
    }

    public boolean removeReactionGlyph(ReactionGlyph reactionGlyph) {
        if (this.isSetListOfReactionGlyphs()) {
            return this.getListOfReactionGlyphs().remove((NamedSBase)reactionGlyph);
        }
        return false;
    }

    public ReactionGlyph removeReactionGlyph(String reactionGlyphId) {
        if (this.isSetListOfReactionGlyphs()) {
            return (ReactionGlyph)this.getListOfReactionGlyphs().remove(reactionGlyphId);
        }
        return null;
    }

    public boolean removeSingletons() {
        HashSet<String> speciesGlyphsToKeep = new HashSet<String>();
        if (this.isSetListOfReactionGlyphs()) {
            for (ReactionGlyph rxnGlyph : this.getListOfReactionGlyphs()) {
                for (SpeciesReferenceGlyph srg : rxnGlyph.getListOfSpeciesReferenceGlyphs()) {
                    speciesGlyphsToKeep.add(srg.getSpeciesGlyph());
                }
            }
            Iterator it = this.getListOfSpeciesGlyphs().iterator();
            while (it.hasNext()) {
                if (speciesGlyphsToKeep.contains(((SpeciesGlyph)it.next()).getId())) continue;
                it.remove();
            }
            Iterator it2 = this.getListOfTextGlyphs().iterator();
            while (it2.hasNext()) {
                GraphicalObject go = ((TextGlyph)it2.next()).getGraphicalObjectInstance();
                if (!(go instanceof SpeciesGlyph) || speciesGlyphsToKeep.contains(go.getId())) continue;
                it2.remove();
            }
            return true;
        }
        return false;
    }

    public SpeciesGlyph removeSpeciesGlyph(int i) {
        if (!this.isSetListOfSpeciesGlyphs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (SpeciesGlyph)this.getListOfSpeciesGlyphs().remove(i);
    }

    public boolean removeSpeciesGlyph(SpeciesGlyph speciesGlyph) {
        if (this.isSetListOfSpeciesGlyphs()) {
            return this.getListOfSpeciesGlyphs().remove((NamedSBase)speciesGlyph);
        }
        return false;
    }

    public SpeciesGlyph removeSpeciesGlyph(String speciesGlyphId) {
        if (this.isSetListOfSpeciesGlyphs()) {
            return (SpeciesGlyph)this.getListOfSpeciesGlyphs().remove(speciesGlyphId);
        }
        return null;
    }

    public TextGlyph removeTextGlyph(int i) {
        if (!this.isSetListOfTextGlyphs()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        return (TextGlyph)this.getListOfTextGlyphs().remove(i);
    }

    public TextGlyph removeTextGlyph(String textGlyphId) {
        if (this.isSetListOfTextGlyphs()) {
            return (TextGlyph)this.getListOfTextGlyphs().remove(textGlyphId);
        }
        return null;
    }

    public boolean removeTextGlyph(TextGlyph textGlyph) {
        if (this.isSetListOfTextGlyphs()) {
            return this.getListOfTextGlyphs().remove((NamedSBase)textGlyph);
        }
        return false;
    }

    public void setAddGraphicalObjects(ListOf<GraphicalObject> addGraphicalObjects) {
        this.setListOfAdditionalGraphicalObjects(addGraphicalObjects);
    }

    public void setDimensions(Dimensions dimensions) {
        if (this.dimensions != null) {
            this.dimensions.fireNodeRemovedEvent();
        }
        this.dimensions = dimensions;
        this.registerChild((SBase)this.dimensions);
    }

    public void setListOfAdditionalGraphicalObjects(ListOf<GraphicalObject> additionalGraphicalObjects) {
        this.unsetListOfAdditionalGraphicalObjects();
        if (additionalGraphicalObjects != null) {
            this.listOfAdditionalGraphicalObjects = additionalGraphicalObjects;
            this.listOfAdditionalGraphicalObjects.setPackageVersion(-1);
            this.listOfAdditionalGraphicalObjects.setPackageName(null);
            this.listOfAdditionalGraphicalObjects.setPackageName("layout");
            this.listOfAdditionalGraphicalObjects.setSBaseListType(ListOf.Type.other);
            this.listOfAdditionalGraphicalObjects.setOtherListName("listOfAdditionalGraphicalObjects");
            this.registerChild((SBase)this.listOfAdditionalGraphicalObjects);
        }
    }

    public void setListOfCompartmentGlyphs(ListOf<CompartmentGlyph> compartmentGlyphs) {
        this.unsetListOfCompartmentGlyphs();
        this.listOfCompartmentGlyphs = compartmentGlyphs;
        if (this.listOfCompartmentGlyphs != null) {
            this.listOfCompartmentGlyphs.setPackageVersion(-1);
            this.listOfCompartmentGlyphs.setPackageName(null);
            this.listOfCompartmentGlyphs.setPackageName("layout");
            this.listOfCompartmentGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfCompartmentGlyphs.setOtherListName("listOfCompartmentGlyphs");
            this.registerChild((SBase)this.listOfCompartmentGlyphs);
        }
    }

    public void setListOfReactionGlyphs(ListOf<ReactionGlyph> reactionGlyphs) {
        this.unsetListOfReactionGlyphs();
        this.listOfReactionGlyphs = reactionGlyphs;
        if (this.listOfReactionGlyphs != null) {
            this.listOfReactionGlyphs.setPackageVersion(-1);
            this.listOfReactionGlyphs.setPackageName(null);
            this.listOfReactionGlyphs.setPackageName("layout");
            this.listOfReactionGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfReactionGlyphs.setOtherListName("listOfReactionGlyphs");
            this.registerChild((SBase)this.listOfReactionGlyphs);
        }
    }

    public void setListOfSpeciesGlyphs(ListOf<SpeciesGlyph> speciesGlyphs) {
        this.unsetListOfSpeciesGlyphs();
        this.listOfSpeciesGlyphs = speciesGlyphs;
        if (this.listOfSpeciesGlyphs != null) {
            this.listOfSpeciesGlyphs.setPackageVersion(-1);
            this.listOfSpeciesGlyphs.setPackageName(null);
            this.listOfSpeciesGlyphs.setPackageName("layout");
            this.listOfSpeciesGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfSpeciesGlyphs.setOtherListName("listOfSpeciesGlyphs");
            this.registerChild((SBase)this.listOfSpeciesGlyphs);
        }
    }

    public void setListOfTextGlyphs(ListOf<TextGlyph> textGlyphs) {
        this.unsetListOfTextGlyphs();
        this.listOfTextGlyphs = textGlyphs;
        if (this.listOfTextGlyphs != null) {
            this.listOfTextGlyphs.setPackageVersion(-1);
            this.listOfTextGlyphs.setPackageName(null);
            this.listOfTextGlyphs.setPackageName("layout");
            this.listOfTextGlyphs.setSBaseListType(ListOf.Type.other);
            this.listOfTextGlyphs.setOtherListName("listOfTextGlyphs");
            this.registerChild((SBase)this.listOfTextGlyphs);
        }
    }

    public boolean unsetListOfAdditionalGraphicalObjects() {
        if (this.listOfAdditionalGraphicalObjects != null) {
            ListOf<GraphicalObject> oldListOfAdditionalGraphicalObjects = this.listOfAdditionalGraphicalObjects;
            this.listOfAdditionalGraphicalObjects = null;
            oldListOfAdditionalGraphicalObjects.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfCompartmentGlyphs() {
        if (this.listOfCompartmentGlyphs != null) {
            ListOf<CompartmentGlyph> oldListOfCompartmentGlyphs = this.listOfCompartmentGlyphs;
            this.listOfCompartmentGlyphs = null;
            oldListOfCompartmentGlyphs.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfReactionGlyphs() {
        if (this.listOfReactionGlyphs != null) {
            ListOf<ReactionGlyph> oldListOfReactionGlyphs = this.listOfReactionGlyphs;
            this.listOfReactionGlyphs = null;
            oldListOfReactionGlyphs.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfSpeciesGlyphs() {
        if (this.listOfSpeciesGlyphs != null) {
            ListOf<SpeciesGlyph> oldListOfSpeciesGlyphs = this.listOfSpeciesGlyphs;
            this.listOfSpeciesGlyphs = null;
            oldListOfSpeciesGlyphs.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public boolean unsetListOfTextGlyphs() {
        if (this.listOfTextGlyphs != null) {
            ListOf<TextGlyph> oldListOfTextGlyphs = this.listOfTextGlyphs;
            this.listOfTextGlyphs = null;
            oldListOfTextGlyphs.fireNodeRemovedEvent();
            return true;
        }
        return false;
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("layout:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            attributes.put("layout:name", this.getName());
        }
        return attributes;
    }
}

