/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.util.Map;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.Species;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;

public class SpeciesGlyph
extends AbstractReferenceGlyph {
    private static final long serialVersionUID = 1077785483575936434L;

    public SpeciesGlyph() {
        this.initDefaults();
    }

    public SpeciesGlyph(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public SpeciesGlyph(SpeciesGlyph speciesGlyph) {
        super(speciesGlyph);
        this.initDefaults();
    }

    public SpeciesGlyph(String id) {
        super(id);
        this.initDefaults();
    }

    public SpeciesGlyph(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    @Override
    public SpeciesGlyph clone() {
        return new SpeciesGlyph(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public String getSpecies() {
        return this.getReference();
    }

    public NamedSBase getSpeciesInstance() {
        return this.getNamedSBaseInstance();
    }

    public boolean isSetSpecies() {
        return this.isSetReference();
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("species")) {
                this.setSpecies(value);
            } else {
                return false;
            }
        }
        return true;
    }

    public void setSpecies(Species species) {
        this.setSpecies(species.getId());
    }

    public void setSpecies(String species) {
        this.setReference(species, "species");
    }

    public void unsetSpecies() {
        this.unsetReference();
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSpecies()) {
            attributes.put("layout:species", this.getSpecies());
        }
        return attributes;
    }
}

