/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.xml.parsers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.sbml.jsbml.ASTNode;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.SBMLDocument;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.ASTNodePlugin;
import org.sbml.jsbml.ext.SBasePlugin;
import org.sbml.jsbml.ext.layout.BoundingBox;
import org.sbml.jsbml.ext.layout.CompartmentGlyph;
import org.sbml.jsbml.ext.layout.CubicBezier;
import org.sbml.jsbml.ext.layout.Curve;
import org.sbml.jsbml.ext.layout.CurveSegment;
import org.sbml.jsbml.ext.layout.Dimensions;
import org.sbml.jsbml.ext.layout.GeneralGlyph;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.IBoundingBox;
import org.sbml.jsbml.ext.layout.ICurve;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.LayoutConstants;
import org.sbml.jsbml.ext.layout.LayoutModelPlugin;
import org.sbml.jsbml.ext.layout.LineSegment;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.ext.layout.ReferenceGlyph;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.util.ResourceManager;
import org.sbml.jsbml.util.filters.Filter;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;
import org.sbml.jsbml.xml.parsers.PackageParser;
import org.sbml.jsbml.xml.stax.SBMLObjectForXML;

public class L3LayoutParser
extends AbstractReaderWriter
implements PackageParser {
    private static final transient ResourceBundle bundle = ResourceManager.getBundle((String)"org.sbml.jsbml.resources.cfg.Messages");
    private static final transient Logger logger = Logger.getLogger(L3LayoutParser.class);
    private static final List<String> namespaces = new ArrayList<String>();

    public String getNamespaceURI() {
        return "http://www.sbml.org/sbml/level3/version1/layout/version1";
    }

    public String getShortLabel() {
        return "layout";
    }

    public List<Object> getListOfSBMLElementsToWrite(Object sbase) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getListOfSBMLElementsToWrite: " + sbase.getClass().getCanonicalName()));
        }
        List listOfElementsToWrite = new ArrayList();
        if (sbase instanceof Model) {
            SBasePlugin modelPlugin = ((Model)sbase).getExtension(this.getNamespaceURI());
            if (modelPlugin != null) {
                listOfElementsToWrite = super.getListOfSBMLElementsToWrite((Object)modelPlugin);
            }
        } else {
            listOfElementsToWrite = super.getListOfSBMLElementsToWrite(sbase);
        }
        return listOfElementsToWrite;
    }

    public Object processStartElement(String elementName, String uri, String prefix, boolean hasAttributes, boolean hasNamespaces, Object contextObject) {
        if (contextObject instanceof Model) {
            Model model = (Model)contextObject;
            if (elementName.equals("listOfLayouts")) {
                LayoutModelPlugin layoutModel = new LayoutModelPlugin(model);
                model.addExtension(this.getNamespaceURI(), (SBasePlugin)layoutModel);
                return layoutModel.getListOfLayouts();
            }
            logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
            return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
        }
        if (contextObject instanceof Layout) {
            Layout layout = (Layout)((Object)contextObject);
            Object newElement = null;
            if (elementName.equals("listOfCompartmentGlyphs")) {
                newElement = layout.getListOfCompartmentGlyphs();
            } else if (elementName.equals("listOfSpeciesGlyphs")) {
                newElement = layout.getListOfSpeciesGlyphs();
            } else if (elementName.equals("listOfReactionGlyphs")) {
                newElement = layout.getListOfReactionGlyphs();
            } else if (elementName.equals("listOfTextGlyphs")) {
                newElement = layout.getListOfTextGlyphs();
            } else if (elementName.equals("listOfAdditionalGraphicalObjects")) {
                newElement = layout.getListOfAdditionalGraphicalObjects();
            } else if (elementName.equals("dimensions")) {
                Dimensions dimension = new Dimensions();
                layout.setDimensions(dimension);
                newElement = dimension;
            } else {
                logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
            }
            if (newElement != null) {
                return newElement;
            }
        } else {
            if (contextObject instanceof IBoundingBox) {
                IBoundingBox graphicalObject = (IBoundingBox)contextObject;
                if (elementName.equals("boundingBox")) {
                    BoundingBox bbox = new BoundingBox();
                    graphicalObject.setBoundingBox(bbox);
                    return bbox;
                }
                if (graphicalObject instanceof ReactionGlyph) {
                    ReactionGlyph reactionGlyph = (ReactionGlyph)graphicalObject;
                    if (elementName.equals("curve")) {
                        Curve curve = new Curve();
                        reactionGlyph.setCurve(curve);
                        return curve;
                    }
                    if (elementName.equals("listOfSpeciesReferenceGlyphs")) {
                        ListOf<SpeciesReferenceGlyph> list = reactionGlyph.getListOfSpeciesReferenceGlyphs();
                        return list;
                    }
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                if (graphicalObject instanceof SpeciesReferenceGlyph) {
                    SpeciesReferenceGlyph speciesRefGlyph = (SpeciesReferenceGlyph)contextObject;
                    if (elementName.equals("curve")) {
                        Curve curve = new Curve();
                        speciesRefGlyph.setCurve(curve);
                        return curve;
                    }
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                if (graphicalObject instanceof GeneralGlyph) {
                    GeneralGlyph generalGlyph = (GeneralGlyph)graphicalObject;
                    if (elementName.equals("curve")) {
                        Curve curve = new Curve();
                        generalGlyph.setCurve(curve);
                        return curve;
                    }
                    if (elementName.equals("listOfSubGlyphs")) {
                        ListOf<GraphicalObject> list = generalGlyph.getListOfSubGlyphs();
                        return list;
                    }
                    if (elementName.equals("listOfReferenceGlyphs")) {
                        ListOf<ReferenceGlyph> list = generalGlyph.getListOfReferenceGlyphs();
                        return list;
                    }
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                if (graphicalObject instanceof ReferenceGlyph) {
                    ReferenceGlyph refGlyph = (ReferenceGlyph)contextObject;
                    if (elementName.equals("curve")) {
                        Curve curve = new Curve();
                        refGlyph.setCurve(curve);
                        return curve;
                    }
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
            }
            if (contextObject instanceof BoundingBox) {
                BoundingBox bbox = (BoundingBox)((Object)contextObject);
                if (elementName.equals("position")) {
                    Point position = new Point();
                    bbox.setPosition(position);
                    return position;
                }
                if (elementName.equals("dimensions")) {
                    Dimensions dimension = new Dimensions();
                    bbox.setDimensions(dimension);
                    return dimension;
                }
                logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
            }
            if (contextObject instanceof ICurve) {
                ICurve curve = (ICurve)contextObject;
                ListOf<CurveSegment> newElement = null;
                if (!elementName.equals("listOfCurveSegments")) {
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                newElement = curve.getListOfCurveSegments();
                if (newElement != null) {
                    return newElement;
                }
            } else {
                if (contextObject instanceof CurveSegment) {
                    CubicBezier curveSegment = (CubicBezier)((Object)contextObject);
                    if (elementName.equals("start")) {
                        Point point = new Point();
                        curveSegment.setStart(point);
                        return point;
                    }
                    if (elementName.equals("end")) {
                        Point point = new Point();
                        curveSegment.setEnd(point);
                        return point;
                    }
                    if (elementName.equals("basePoint1")) {
                        Point point = new Point();
                        curveSegment.setBasePoint1(point);
                        return point;
                    }
                    if (elementName.equals("basePoint2")) {
                        Point point = new Point();
                        curveSegment.setBasePoint2(point);
                        return point;
                    }
                    logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                    return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                }
                if (contextObject instanceof ListOf) {
                    ListOf listOf = (ListOf)contextObject;
                    Object newElement = null;
                    if (elementName.equals("layout")) {
                        newElement = new Layout();
                    } else if (elementName.equals("compartmentGlyph")) {
                        newElement = new CompartmentGlyph();
                    } else if (elementName.equals("speciesGlyph")) {
                        newElement = new SpeciesGlyph();
                    } else if (elementName.equals("reactionGlyph")) {
                        newElement = new ReactionGlyph();
                    } else if (elementName.equals("textGlyph")) {
                        newElement = new TextGlyph();
                    } else if (elementName.equals("curveSegment") || elementName.equals("cubicBezier") || elementName.equals("lineSegment")) {
                        newElement = new CubicBezier();
                    } else if (elementName.equals("speciesReferenceGlyph")) {
                        newElement = new SpeciesReferenceGlyph();
                    } else if (elementName.equals("referenceGlyph")) {
                        newElement = new ReferenceGlyph();
                    } else if (elementName.equals("generalGlyph")) {
                        newElement = new GeneralGlyph();
                    } else if (elementName.equals("graphicalObject")) {
                        newElement = new GraphicalObject();
                    } else {
                        logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                        return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                    }
                    if (newElement != null) {
                        try {
                            listOf.add((SBase)newElement);
                        }
                        catch (ClassCastException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Exception catched: " + e.getMessage()));
                            }
                            logger.warn((Object)MessageFormat.format(bundle.getString("SBMLCoreParser.unknownElement"), elementName));
                            return AbstractReaderWriter.processUnknownElement((String)elementName, (String)uri, (String)prefix, (Object)contextObject);
                        }
                        catch (RuntimeException e) {
                            logger.warn((Object)("RuntimeException catched: " + e.getMessage()));
                        }
                    }
                    return newElement;
                }
            }
        }
        return contextObject;
    }

    public void processEndDocument(SBMLDocument sbmlDocument) {
        if (sbmlDocument.isSetModel() && sbmlDocument.getModel().getExtension(this.getShortLabel()) != null) {
            List curveElements = sbmlDocument.getModel().getExtension(this.getShortLabel()).filter(new Filter(){

                public boolean accepts(Object o) {
                    return o instanceof ICurve;
                }
            });
            for (TreeNode curveNode : curveElements) {
                ICurve curve = (ICurve)((Object)curveNode);
                int i = 0;
                for (CurveSegment curveSegment : curve.getListOfCurveSegments().clone()) {
                    if (!curveSegment.isSetType()) {
                        if (((CubicBezier)curveSegment).isSetBasePoint1() || ((CubicBezier)curveSegment).isSetBasePoint2()) {
                            curveSegment.readAttribute("type", "", CurveSegment.Type.CUBIC_BEZIER.toString());
                        } else {
                            curveSegment.readAttribute("type", "", CurveSegment.Type.LINE_SEGMENT.toString());
                        }
                    }
                    if (curveSegment.getType().equals((Object)CurveSegment.Type.LINE_SEGMENT)) {
                        LineSegment realCurveSegment = new LineSegment(curveSegment);
                        logger.debug((Object)("Transformed a CubicBezier: '" + (Object)((Object)curveSegment) + "' into a LineSegment."));
                        curve.getListOfCurveSegments().remove(i);
                        curve.getListOfCurveSegments().add(i, (SBase)realCurveSegment);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CurveSegment = " + curve.getListOfCurveSegments().get(i)));
                    }
                    ++i;
                }
            }
        }
    }

    public void writeElement(SBMLObjectForXML xmlObject, Object sbmlElementToWrite) {
        super.writeElement(xmlObject, sbmlElementToWrite);
        String name = xmlObject.getName();
        if (name.equals("lineSegment") || name.equals("cubicBezier")) {
            xmlObject.setName("curveSegment");
        }
        if (name.equals("listOfLineSegments")) {
            xmlObject.setName("listOfCurveSegments");
        }
        if (name.equals("listOfLayouts")) {
            xmlObject.getAttributes().put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public List<String> getNamespaces() {
        return LayoutConstants.all_L3_namespaces;
    }

    public List<String> getPackageNamespaces() {
        return LayoutConstants.namespaces_L3;
    }

    public String getNamespaceFor(int level, int version, int packageVersion) {
        if (level == 3 && version == 1 && packageVersion == 1) {
            return "http://www.sbml.org/sbml/level3/version1/layout/version1";
        }
        return null;
    }

    public String getPackageName() {
        return "layout";
    }

    public boolean isRequired() {
        return false;
    }

    public SBasePlugin createPluginFor(SBase sbase) {
        if (sbase != null && sbase instanceof Model) {
            return new LayoutModelPlugin((Model)sbase);
        }
        return null;
    }

    public ASTNodePlugin createPluginFor(ASTNode astNode) {
        return null;
    }

    static {
        namespaces.addAll(LayoutConstants.namespaces_L3);
        namespaces.add("http://www.w3.org/2001/XMLSchema-instance");
    }
}

