/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import org.sbml.jsbml.SBO;

public enum SpeciesReferenceRole {
    ACTIVATOR,
    INHIBITOR,
    MODIFIER,
    PRODUCT,
    SIDEPRODUCT,
    SIDESUBSTRATE,
    SUBSTRATE,
    UNDEFINED;


    public int toSBOterm() {
        switch (this) {
            case ACTIVATOR: {
                return SBO.getActivator();
            }
            case INHIBITOR: {
                return SBO.getInhibitor();
            }
            case MODIFIER: {
                return SBO.getModifier();
            }
            case PRODUCT: {
                return SBO.getProduct();
            }
            case SIDEPRODUCT: {
                return SBO.getSideProduct();
            }
            case SIDESUBSTRATE: {
                return SBO.getSideSubstrate();
            }
            case SUBSTRATE: {
                return SBO.getReactant();
            }
            case UNDEFINED: {
                return SBO.getParticipantRole();
            }
        }
        return -1;
    }

    public static SpeciesReferenceRole valueOf(int sboTerm) {
        if (SBO.isChildOf((int)sboTerm, (int)ACTIVATOR.toSBOterm())) {
            return ACTIVATOR;
        }
        if (SBO.isChildOf((int)sboTerm, (int)INHIBITOR.toSBOterm())) {
            return INHIBITOR;
        }
        if (SBO.isChildOf((int)sboTerm, (int)MODIFIER.toSBOterm())) {
            return MODIFIER;
        }
        if (SBO.isChildOf((int)sboTerm, (int)SIDEPRODUCT.toSBOterm())) {
            return SIDEPRODUCT;
        }
        if (SBO.isChildOf((int)sboTerm, (int)PRODUCT.toSBOterm())) {
            return PRODUCT;
        }
        if (SBO.isChildOf((int)sboTerm, (int)SIDESUBSTRATE.toSBOterm())) {
            return SIDESUBSTRATE;
        }
        if (SBO.isChildOf((int)sboTerm, (int)SUBSTRATE.toSBOterm())) {
            return SUBSTRATE;
        }
        return UNDEFINED;
    }
}

