/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.layout.Point;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;
import org.sbml.jsbml.xml.XMLNode;

public class PointConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021201, 6021204);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021201: {
                func = new ValidationFunction<Point>(){

                    public boolean check(ValidationContext ctx, Point point) {
                        return new UnknownCoreElementValidationFunction().check(ctx, (TreeNodeWithChangeSupport)point) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)point);
                    }
                };
                break;
            }
            case 6021202: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021203: {
                func = new UnknownPackageAttributeValidationFunction<Point>("layout"){

                    public boolean check(ValidationContext ctx, Point point) {
                        if (!point.isSetX() || !point.isSetY()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)point);
                    }
                };
                break;
            }
            case 6021204: {
                func = new ValidationFunction<Point>(){

                    public boolean check(ValidationContext ctx, Point point) {
                        if (point.getUserObject("jsbml.unknown.xml") != null) {
                            XMLNode unknown = (XMLNode)point.getUserObject("jsbml.unknown.xml");
                            if (!point.isSetX() && unknown.getAttrIndex("x") != -1) {
                                return false;
                            }
                            if (!point.isSetY() && unknown.getAttrIndex("y") != -1) {
                                return false;
                            }
                            if (!point.isSetZ() && unknown.getAttrIndex("z") != -1) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

