/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Reaction;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.ReactionGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class ReactionGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020701, 6020712);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020701: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020702: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020703: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        return reactionGlyph.isSetListOfSpeciesReferenceGlyphs() && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)reactionGlyph) && new DuplicatedElementValidationFunction("curve").check(ctx, (SBase)reactionGlyph) && new DuplicatedElementValidationFunction("listOfSpeciesReferenceGlyphs").check(ctx, (SBase)reactionGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)reactionGlyph);
                    }
                };
                break;
            }
            case 6020704: {
                func = new UnknownPackageAttributeValidationFunction<ReactionGlyph>("layout"){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (!reactionGlyph.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)reactionGlyph);
                    }
                };
                break;
            }
            case 6020705: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)reactionGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020706: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetMetaidRef()) {
                            return reactionGlyph.getSBMLDocument().getElementByMetaId(reactionGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020707: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetReaction()) {
                            return SyntaxChecker.isValidId((String)reactionGlyph.getReaction(), (int)reactionGlyph.getLevel(), (int)reactionGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020708: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetReaction()) {
                            return reactionGlyph.getModel().getReaction(reactionGlyph.getReaction()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020709: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetReaction() && reactionGlyph.isSetMetaidRef()) {
                            try {
                                Reaction c = reactionGlyph.getModel().getReaction(reactionGlyph.getReaction());
                                Reaction cFromRef = (Reaction)reactionGlyph.getSBMLDocument().getElementByMetaId(reactionGlyph.getMetaidRef());
                                if ((c == null || cFromRef == null) && c != cFromRef) {
                                    return false;
                                }
                                if (c == null || cFromRef == null || !c.equals((Object)cFromRef)) {
                                    return false;
                                }
                            }
                            catch (ClassCastException e) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020710: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
                            return new UnknownElementValidationFunction().check(ctx, reactionGlyph.getListOfSpeciesReferenceGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020711: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, reactionGlyph.getListOfSpeciesReferenceGlyphs()) && new UnknownPackageAttributeValidationFunction("layout").check(ctx, reactionGlyph.getListOfSpeciesReferenceGlyphs());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020712: {
                func = new ValidationFunction<ReactionGlyph>(){

                    public boolean check(ValidationContext ctx, ReactionGlyph reactionGlyph) {
                        if (reactionGlyph.isSetListOfSpeciesReferenceGlyphs()) {
                            return reactionGlyph.getSpeciesReferenceGlyphCount() > 0;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

