/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.ReferenceGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class ReferenceGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021101, 6021112);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021101: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021102: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021103: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        return new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)referenceGlyph) && new DuplicatedElementValidationFunction("curve").check(ctx, (SBase)referenceGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)referenceGlyph);
                    }
                };
                break;
            }
            case 6021104: {
                func = new UnknownPackageAttributeValidationFunction<ReferenceGlyph>("layout"){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (!referenceGlyph.isSetId() || !referenceGlyph.isSetGlyph()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)referenceGlyph);
                    }
                };
                break;
            }
            case 6021105: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)referenceGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021106: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetMetaidRef()) {
                            return referenceGlyph.getSBMLDocument().getElementByMetaId(referenceGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021107: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetReference()) {
                            return SyntaxChecker.isValidId((String)referenceGlyph.getReference(), (int)referenceGlyph.getLevel(), (int)referenceGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021108: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetReference()) {
                            SBase sbase = referenceGlyph.getModel().getElementBySId(referenceGlyph.getReference());
                            return sbase != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021109: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetReference() && referenceGlyph.isSetMetaidRef()) {
                            SBase sbase = referenceGlyph.getModel().getElementBySId(referenceGlyph.getReference());
                            SBase sbaseFromMetaidRef = referenceGlyph.getSBMLDocument().getElementByMetaId(referenceGlyph.getMetaidRef());
                            if ((sbase == null || sbaseFromMetaidRef == null) && sbase != sbaseFromMetaidRef) {
                                return false;
                            }
                            if (sbase == null || sbaseFromMetaidRef == null || !sbase.equals((Object)sbaseFromMetaidRef)) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021110: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetGlyph()) {
                            return SyntaxChecker.isValidId((String)referenceGlyph.getGlyph(), (int)referenceGlyph.getLevel(), (int)referenceGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021111: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        if (referenceGlyph.isSetGlyph()) {
                            Layout layout = (Layout)((Object)referenceGlyph.getParent().getParent().getParent().getParent());
                            SBase sbase = layout.getElementBySId(referenceGlyph.getGlyph());
                            return sbase != null && sbase instanceof GraphicalObject;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021112: {
                func = new ValidationFunction<ReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, ReferenceGlyph referenceGlyph) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

