/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.SpeciesReference;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.SpeciesGlyph;
import org.sbml.jsbml.ext.layout.SpeciesReferenceGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;
import org.sbml.jsbml.xml.XMLNode;

public class SpeciesReferenceGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6021001, 6021012);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6021001: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6021002: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6021003: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        return new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)speciesRefGlyph) && new DuplicatedElementValidationFunction("curve").check(ctx, (SBase)speciesRefGlyph) && new UnknownPackageElementValidationFunction("layout").check(ctx, (TreeNodeWithChangeSupport)speciesRefGlyph);
                    }
                };
                break;
            }
            case 6021004: {
                func = new UnknownPackageAttributeValidationFunction<SpeciesReferenceGlyph>("layout"){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (!speciesRefGlyph.isSetId() || !speciesRefGlyph.isSetSpeciesGlyph()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)speciesRefGlyph);
                    }
                };
                break;
            }
            case 6021005: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)speciesRefGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021006: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetMetaidRef()) {
                            return speciesRefGlyph.getSBMLDocument().getElementByMetaId(speciesRefGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021007: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetSpeciesReference()) {
                            return SyntaxChecker.isValidId((String)speciesRefGlyph.getSpeciesReference(), (int)speciesRefGlyph.getLevel(), (int)speciesRefGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021008: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetSpeciesReference()) {
                            SBase sbase = speciesRefGlyph.getModel().getElementBySId(speciesRefGlyph.getSpeciesReference());
                            return sbase != null && sbase instanceof SpeciesReference;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021009: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetSpeciesReference() && speciesRefGlyph.isSetMetaidRef()) {
                            SBase c = speciesRefGlyph.getModel().getElementBySId(speciesRefGlyph.getSpeciesReference());
                            SBase cFromRef = speciesRefGlyph.getSBMLDocument().getElementByMetaId(speciesRefGlyph.getMetaidRef());
                            if ((c == null || cFromRef == null) && c != cFromRef) {
                                return false;
                            }
                            if (c == null || cFromRef == null || !c.equals((Object)cFromRef)) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021010: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetSpeciesGlyph()) {
                            return SyntaxChecker.isValidId((String)speciesRefGlyph.getSpeciesGlyph(), (int)speciesRefGlyph.getLevel(), (int)speciesRefGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021011: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        if (speciesRefGlyph.isSetSpeciesGlyph()) {
                            Layout layout = (Layout)((Object)speciesRefGlyph.getParent().getParent().getParent().getParent());
                            SBase sbase = layout.getElementBySId(speciesRefGlyph.getSpeciesGlyph());
                            return sbase != null && sbase instanceof SpeciesGlyph;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6021012: {
                func = new ValidationFunction<SpeciesReferenceGlyph>(){

                    public boolean check(ValidationContext ctx, SpeciesReferenceGlyph speciesRefGlyph) {
                        XMLNode unknown;
                        return speciesRefGlyph.isSetSpeciesReferenceRole() || speciesRefGlyph.getUserObject("jsbml.unknown.xml") == null || (unknown = (XMLNode)speciesRefGlyph.getUserObject("jsbml.unknown.xml")).getAttrIndex("role") == -1;
                    }
                };
            }
        }
        return func;
    }
}

