/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.GraphicalObject;
import org.sbml.jsbml.ext.layout.Layout;
import org.sbml.jsbml.ext.layout.TextGlyph;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.SyntaxChecker;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class TextGlyphConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                this.addRangeToSet(set, 6020901, 6020912);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 6020901: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 6020902: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 6020903: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        return textGlyph.isSetBoundingBox() && new DuplicatedElementValidationFunction("boundingBox").check(ctx, (SBase)textGlyph);
                    }
                };
                break;
            }
            case 6020904: {
                func = new UnknownPackageAttributeValidationFunction<TextGlyph>("layout"){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (!textGlyph.isSetId()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)textGlyph);
                    }
                };
                break;
            }
            case 6020905: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetMetaidRef()) {
                            return SyntaxChecker.isValidMetaId((String)textGlyph.getMetaidRef());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020906: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetMetaidRef()) {
                            return textGlyph.getSBMLDocument().getElementByMetaId(textGlyph.getMetaidRef()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020907: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetOriginOfText()) {
                            return SyntaxChecker.isValidId((String)textGlyph.getOriginOfText(), (int)textGlyph.getLevel(), (int)textGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020908: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetOriginOfText()) {
                            return textGlyph.getModel().getElementBySId(textGlyph.getOriginOfText()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020909: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetGraphicalObject() && textGlyph.isSetMetaidRef()) {
                            SBase sbase = textGlyph.getModel().getElementBySId(textGlyph.getGraphicalObject());
                            SBase sbaseFromMetaidRef = textGlyph.getSBMLDocument().getElementByMetaId(textGlyph.getMetaidRef());
                            if ((sbase == null || sbaseFromMetaidRef == null) && sbase != sbaseFromMetaidRef) {
                                return false;
                            }
                            if (sbase == null || sbaseFromMetaidRef == null || !sbase.equals((Object)sbaseFromMetaidRef)) {
                                return false;
                            }
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020910: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetGraphicalObject()) {
                            return SyntaxChecker.isValidId((String)textGlyph.getGraphicalObject(), (int)textGlyph.getLevel(), (int)textGlyph.getVersion());
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020911: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        if (textGlyph.isSetGraphicalObject()) {
                            Layout layout = (Layout)((Object)textGlyph.getParent().getParent());
                            SBase sbase = layout.getElementBySId(textGlyph.getGraphicalObject());
                            return sbase != null && sbase instanceof GraphicalObject;
                        }
                        return true;
                    }
                };
                break;
            }
            case 6020712: {
                func = new ValidationFunction<TextGlyph>(){

                    public boolean check(ValidationContext ctx, TextGlyph textGlyph) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

