/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.util.Locale;
import java.util.Map;
import org.sbml.jsbml.Compartment;
import org.sbml.jsbml.CompartmentalizedSBase;
import org.sbml.jsbml.NamedSBase;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.layout.AbstractReferenceGlyph;
import org.sbml.jsbml.util.StringTools;

public class CompartmentGlyph
extends AbstractReferenceGlyph
implements CompartmentalizedSBase {
    private static final long serialVersionUID = -831178362695634919L;
    private Double order;

    public CompartmentGlyph() {
        this.initDefaults();
    }

    public CompartmentGlyph(CompartmentGlyph compartmentGlyph) {
        super(compartmentGlyph);
        this.initDefaults();
    }

    public CompartmentGlyph(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public CompartmentGlyph(String id) {
        super(id);
        this.initDefaults();
    }

    public CompartmentGlyph(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    @Override
    public CompartmentGlyph clone() {
        return new CompartmentGlyph(this);
    }

    @Override
    public void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
    }

    public String getCompartment() {
        return this.getReference();
    }

    public NamedSBase getCompartmentInstance() {
        return this.getNamedSBaseInstance();
    }

    public double getOrder() {
        if (this.isSetOrder()) {
            return this.order;
        }
        throw new PropertyUndefinedError("order", (SBase)this);
    }

    public boolean isCompartmentMandatory() {
        return false;
    }

    public boolean isSetCompartment() {
        return this.isSetReference();
    }

    public boolean isSetCompartmentInstance() {
        return this.getCompartmentInstance() != null;
    }

    public boolean isSetOrder() {
        return this.order != null;
    }

    @Override
    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("compartment")) {
                this.setCompartment(value);
            } else if (attributeName.equals("order")) {
                Double valueDbl = StringTools.parseSBMLDouble((String)value);
                if (valueDbl.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setOrder(valueDbl);
            } else {
                return false;
            }
            return true;
        }
        return isAttributeRead;
    }

    public boolean setCompartment(Compartment compartment) {
        return this.setCompartment(compartment.getId());
    }

    public boolean setCompartment(String compartment) {
        return this.setReference(compartment, "compartment");
    }

    public void setOrder(double order) {
        Double oldOrder = this.order;
        this.order = order;
        this.firePropertyChange("order", oldOrder, this.order);
    }

    public boolean unsetCompartment() {
        return this.unsetReference();
    }

    public boolean unsetOrder() {
        if (this.isSetOrder()) {
            Double oldOrder = this.order;
            this.order = null;
            this.firePropertyChange("order", oldOrder, this.order);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetCompartment()) {
            attributes.put("layout:compartment", this.getCompartment());
        }
        if (this.isSetOrder()) {
            attributes.put("layout:order", StringTools.toString((Locale)Locale.ENGLISH, (double)this.order));
        }
        return attributes;
    }
}

