/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.layout;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.AbstractNamedSBase;
import org.sbml.jsbml.UniqueNamedSBase;
import org.sbml.jsbml.util.ResourceManager;
import org.sbml.jsbml.util.StringTools;

public class Dimensions
extends AbstractNamedSBase
implements UniqueNamedSBase {
    private static final long serialVersionUID = -6114634391235520057L;
    private static final transient Logger logger = Logger.getLogger(Dimensions.class);
    private double depth;
    private double height;
    private double width;

    public Dimensions() {
        this.initDefaults();
    }

    public Dimensions(Dimensions dimensions) {
        super((AbstractNamedSBase)dimensions);
        this.width = Double.NaN;
        this.height = Double.NaN;
        this.depth = Double.NaN;
        if (dimensions.isSetDepth()) {
            this.setDepth(dimensions.getDepth());
        } else {
            this.depth = Double.NaN;
        }
        if (dimensions.isSetHeight()) {
            this.setHeight(dimensions.getHeight());
        } else {
            this.height = Double.NaN;
        }
        if (dimensions.isSetWidth()) {
            this.setWidth(dimensions.getWidth());
        } else {
            this.width = Double.NaN;
        }
    }

    public Dimensions(double width, double height, double depth, int level, int version) {
        this(level, version);
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public Dimensions(int level, int version) {
        super(level, version);
        this.initDefaults();
    }

    public Dimensions(String id, int level, int version) {
        super(id, level, version);
        this.initDefaults();
    }

    public Dimensions clone() {
        return new Dimensions(this);
    }

    private void initDefaults() {
        this.setPackageVersion(-1);
        this.packageName = "layout";
        this.width = Double.NaN;
        this.height = Double.NaN;
        this.depth = Double.NaN;
    }

    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (equals) {
            Dimensions d = (Dimensions)((Object)object);
            if ((equals &= d.isSetDepth() == this.isSetDepth()) && this.isSetDepth()) {
                equals &= Double.valueOf(d.getDepth()).equals(this.getDepth());
            }
            if ((equals &= d.isSetHeight() == this.isSetHeight()) && this.isSetHeight()) {
                equals &= Double.valueOf(d.getHeight()).equals(this.getHeight());
            }
            if ((equals &= d.isSetWidth() == this.isSetWidth()) && this.isSetWidth()) {
                equals &= Double.valueOf(d.getWidth()).equals(this.getWidth());
            }
        }
        return equals;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public int hashCode() {
        int prime = 941;
        int hashCode = super.hashCode();
        hashCode += 941 * Double.valueOf(this.depth).hashCode();
        hashCode += 941 * Double.valueOf(this.height).hashCode();
        return hashCode += 941 * Double.valueOf(this.width).hashCode();
    }

    public boolean isIdMandatory() {
        return false;
    }

    public boolean isSetDepth() {
        return !Double.isNaN(this.depth);
    }

    public boolean isSetHeight() {
        return !Double.isNaN(this.height);
    }

    public boolean isSetWidth() {
        return !Double.isNaN(this.width);
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            if (attributeName.equals("width")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setWidth(valueDouble);
            } else if (attributeName.equals("height")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setHeight(valueDouble);
            } else if (attributeName.equals("depth")) {
                Double valueDouble = StringTools.parseSBMLDouble((String)value);
                if (valueDouble.isNaN()) {
                    try {
                        Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
                this.setDepth(valueDouble);
            } else {
                return false;
            }
            return true;
        }
        return isAttributeRead;
    }

    public void setDepth(double depth) {
        Double oldDepth = this.depth;
        this.depth = depth;
        this.firePropertyChange("depth", oldDepth, this.depth);
    }

    public void setHeight(double height) {
        Double oldHeight = this.height;
        this.height = height;
        this.firePropertyChange("height", oldHeight, this.height);
    }

    public void setWidth(double width) {
        Double oldWidth = this.width;
        this.width = width;
        this.firePropertyChange("width", oldWidth, this.width);
    }

    public Map<String, String> writeXMLAttributes() {
        Map attributes = super.writeXMLAttributes();
        if (this.isSetId()) {
            attributes.remove("id");
            attributes.put("layout:id", this.getId());
        }
        if (this.isSetName()) {
            attributes.remove("name");
            logger.warn((Object)MessageFormat.format(ResourceManager.getBundle((String)"org.sbml.jsbml.resources.cfg.Messages").getString("UNDEFINED_ATTRIBUTE"), "name", this.getLevel(), this.getVersion(), this.getElementName()));
        }
        if (this.isSetDepth()) {
            attributes.put("layout:depth", StringTools.toString((Locale)Locale.ENGLISH, (double)this.depth));
        }
        if (this.isSetHeight()) {
            attributes.put("layout:height", StringTools.toString((Locale)Locale.ENGLISH, (double)this.height));
        }
        if (this.isSetWidth()) {
            attributes.put("layout:width", StringTools.toString((Locale)Locale.ENGLISH, (double)this.width));
        }
        return attributes;
    }
}

